/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.rlscache;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceEndpointAddress;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceFrom;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceTo;
import org.mobicents.slee.sipevent.server.rlscache.RLSService;
import org.mobicents.slee.sipevent.server.rlscache.RLSServicesCacheResourceAdaptor;
import org.mobicents.slee.sipevent.server.rlscache.ResourceList;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.ListType;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.ResourceLists;
import org.openxdm.xcap.common.uri.DocumentSelector;
import org.openxdm.xcap.common.uri.ElementSelector;
import org.openxdm.xcap.common.uri.ElementSelectorStep;
import org.openxdm.xcap.common.uri.ElementSelectorStepByAttr;

public class ReferencedResourceLists {
    private static final ElementSelectorStep rootStep = new ElementSelectorStep("resource-lists");
    private final DocumentSelector documentSelector;
    private final ConcurrentHashMap<String, ResourceList> lists = new ConcurrentHashMap();
    private final RLSServicesCacheResourceAdaptor ra;
    private boolean resolved = false;

    public ReferencedResourceLists(DocumentSelector documentSelector, RLSServicesCacheResourceAdaptor ra) {
        this.documentSelector = documentSelector;
        this.ra = ra;
    }

    public void setResourceLists(ResourceLists resourceLists) {
        if (resourceLists == null) {
            for (ResourceList resourceList : this.lists.values()) {
                resourceList.setListType(null);
            }
        } else {
            HashSet<String> listsUpdated = new HashSet<String>();
            for (ListType listType : resourceLists.getList()) {
                ResourceList resourceList = this.lists.get(listType.getName());
                if (resourceList == null) {
                    resourceList = this.addResourceList(listType.getName());
                }
                resourceList.setListType(listType);
                listsUpdated.add(listType.getName());
            }
            for (Map.Entry entry : this.lists.entrySet()) {
                if (listsUpdated.contains(entry.getKey())) continue;
                ((ResourceList)entry.getValue()).setListType(null);
            }
        }
        this.resolved = true;
    }

    private ResourceList addResourceList(String name) {
        ResourceList resourceList = null;
        LinkedList<Object> elementSelectorSteps = new LinkedList<Object>();
        elementSelectorSteps.add(rootStep);
        elementSelectorSteps.add(new ElementSelectorStepByAttr("list", "name", name));
        ResourceList newResourceList = new ResourceList(new ListReferenceEndpointAddress(this.documentSelector, new ElementSelector(elementSelectorSteps)), null, this.ra);
        resourceList = this.lists.putIfAbsent(name, newResourceList);
        if (resourceList == null) {
            resourceList = newResourceList;
        }
        return resourceList;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public ListReferenceTo addFromReference(ListReferenceFrom from, ListReferenceEndpointAddress toAddress) {
        ElementSelectorStepByAttr elementSelectorStepByAttr = (ElementSelectorStepByAttr)toAddress.getElementSelector().getStep(1);
        ResourceList resourceList = this.lists.get(elementSelectorStepByAttr.getAttrValue());
        if (resourceList == null) {
            resourceList = this.addResourceList(elementSelectorStepByAttr.getAttrValue());
        }
        return resourceList.addFromReference(from, toAddress);
    }

    public void removeFromReference(ListReferenceEndpointAddress fromAddress, ListReferenceEndpointAddress toAddress) {
        ElementSelectorStepByAttr elementSelectorStepByAttr = (ElementSelectorStepByAttr)fromAddress.getElementSelector().getStep(1);
        ResourceList resourceList = this.lists.get(elementSelectorStepByAttr.getAttrValue());
        if (resourceList != null) {
            resourceList.removeFromReference(fromAddress, toAddress);
            if (resourceList.getStatus() == RLSService.Status.DOES_NOT_EXISTS && !resourceList.hasFromReferences()) {
                this.lists.remove(elementSelectorStepByAttr.getAttrValue());
            }
        }
    }

    public boolean hasFromReferences() {
        for (ResourceList resourceList : this.lists.values()) {
            if (!resourceList.hasFromReferences()) continue;
            return true;
        }
        return false;
    }
}

