/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.rlscache;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBElement;
import org.mobicents.slee.sipevent.server.rlscache.AbstractListReferenceTo;
import org.mobicents.slee.sipevent.server.rlscache.Entry;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceEndpointAddress;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceFrom;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceTo;
import org.mobicents.slee.sipevent.server.rlscache.RLSService;
import org.mobicents.slee.sipevent.server.rlscache.RLSServicesCacheResourceAdaptor;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.EntryRefType;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.EntryType;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.ExternalType;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.ListType;
import org.openxdm.xcap.common.uri.ElementSelector;
import org.openxdm.xcap.common.uri.ElementSelectorStep;
import org.openxdm.xcap.common.uri.ElementSelectorStepByAttr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceList
extends AbstractListReferenceTo
implements ListReferenceFrom {
    private final ListReferenceFrom parent;
    private final ConcurrentHashMap<String, Entry> localEntries = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ResourceList> lists = new ConcurrentHashMap(1);
    private final ConcurrentHashMap<ListReferenceEndpointAddress, ListReferenceTo> toReferences = new ConcurrentHashMap(1);
    private final RLSServicesCacheResourceAdaptor ra;
    private ListType listType;
    private boolean updating = false;
    private Set<EntryType> entriesCached;

    public ResourceList(ListReferenceEndpointAddress address, ListReferenceFrom parent, RLSServicesCacheResourceAdaptor ra) {
        super(address);
        this.parent = parent;
        this.ra = ra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListType(ListType listType) {
        ResourceList resourceList = this;
        synchronized (resourceList) {
            this.updating = true;
            this.listType = listType;
            if (listType == null) {
                if (this.status != RLSService.Status.DOES_NOT_EXISTS) {
                    this.status = RLSService.Status.DOES_NOT_EXISTS;
                    for (Entry entry : this.localEntries.values()) {
                        entry.setEntryType(null);
                    }
                    for (ResourceList list : this.lists.values()) {
                        list.setListType(null);
                    }
                    this.updated();
                }
            } else {
                RLSService.Status oldStatus = this.status;
                this.processListType(listType);
                if (this.status == RLSService.Status.OK || oldStatus != this.status) {
                    this.updated();
                }
            }
            this.updating = false;
        }
    }

    private void processListType(ListType listType) {
        this.status = RLSService.Status.OK;
        HashSet<String> entriesUpdated = new HashSet<String>();
        HashSet<String> listsUpdated = new HashSet<String>();
        HashSet<ListReferenceEndpointAddress> referencesToAdd = new HashSet<ListReferenceEndpointAddress>();
        for (JAXBElement element : listType.getListOrExternalOrEntry()) {
            if (element.getValue() instanceof EntryType) {
                EntryType entryType = (EntryType)element.getValue();
                entriesUpdated.add(entryType.getUri());
                Entry entry = this.localEntries.get(entryType.getUri());
                if (entry == null) {
                    entry = this.addEntry(entryType.getUri());
                }
                entry.setEntryType(entryType);
                continue;
            }
            if (element.getValue() instanceof EntryRefType) {
                EntryRefType entryRefType = (EntryRefType)element.getValue();
                ListReferenceEndpointAddress entryRefAddress = this.ra.getAddressParser().getAddress(entryRefType.getRef(), false);
                if (entryRefAddress == null) {
                    this.status = RLSService.Status.BAD_GATEWAY;
                    continue;
                }
                if (!entryRefAddress.getElementSelector().getLastStep().getNameWithoutPrefix().equals("entry")) {
                    this.status = RLSService.Status.BAD_GATEWAY;
                    continue;
                }
                referencesToAdd.add(entryRefAddress);
                continue;
            }
            if (element.getValue() instanceof ExternalType) {
                ExternalType externalType = (ExternalType)element.getValue();
                ListReferenceEndpointAddress externalTypeAddress = this.ra.getAddressParser().getAddress(externalType.getAnchor(), true);
                if (externalTypeAddress == null) {
                    this.status = RLSService.Status.BAD_GATEWAY;
                    continue;
                }
                if (!externalTypeAddress.getElementSelector().getLastStep().getNameWithoutPrefix().equals("list")) {
                    this.status = RLSService.Status.BAD_GATEWAY;
                    continue;
                }
                referencesToAdd.add(externalTypeAddress);
                continue;
            }
            if (!(element.getValue() instanceof ListType)) continue;
            ListType innerListType = (ListType)element.getValue();
            listsUpdated.add(innerListType.getName());
            ResourceList resourceList = this.lists.get(innerListType.getName());
            if (resourceList == null) {
                this.addResourceList(innerListType.getName());
            }
            resourceList.setListType(innerListType);
        }
        Entry entry = null;
        String entryName = null;
        Iterator it = this.localEntries.keySet().iterator();
        while (it.hasNext()) {
            entryName = (String)it.next();
            if (entriesUpdated.contains(entryName)) continue;
            entry = this.localEntries.get(entryName);
            if (entry.hasFromReferences()) {
                entry.setEntryType(null);
                continue;
            }
            it.remove();
        }
        ResourceList innerList = null;
        String innerListName = null;
        Iterator it2 = this.lists.keySet().iterator();
        while (it2.hasNext()) {
            innerListName = (String)it2.next();
            if (listsUpdated.contains(innerListName)) continue;
            innerList = this.lists.get(innerListName);
            if (innerList.hasFromReferences()) {
                innerList.setListType(null);
                continue;
            }
            it2.remove();
        }
        ListReferenceEndpointAddress referenceAddress = null;
        Iterator it3 = this.toReferences.keySet().iterator();
        while (it3.hasNext()) {
            referenceAddress = (ListReferenceEndpointAddress)it3.next();
            if (referencesToAdd.remove(referenceAddress)) continue;
            it3.remove();
            this.ra.removeReference(this.getAddress(), referenceAddress);
        }
        if (!referencesToAdd.isEmpty()) {
            ListReferenceTo referenceTo = null;
            for (ListReferenceEndpointAddress address : referencesToAdd) {
                referenceTo = this.ra.addReference(this, address);
                if (referenceTo == null) {
                    this.status = RLSService.Status.BAD_GATEWAY;
                    continue;
                }
                this.toReferences.put(address, referenceTo);
            }
        }
    }

    private Entry addEntry(String uri) {
        LinkedList<ElementSelectorStep> elementSelectorSteps = this.cloneListAddressElementSelectorSteps();
        elementSelectorSteps.add((ElementSelectorStep)new ElementSelectorStepByAttr("entry", "uri", uri));
        Entry newEntry = new Entry(new ListReferenceEndpointAddress(this.getAddress().getDocumentSelector(), new ElementSelector(elementSelectorSteps)));
        Entry entry = this.localEntries.putIfAbsent(uri, newEntry);
        if (entry == null) {
            entry = newEntry;
        }
        return entry;
    }

    private ResourceList addResourceList(String name) {
        LinkedList<ElementSelectorStep> elementSelectorSteps = this.cloneListAddressElementSelectorSteps();
        elementSelectorSteps.add((ElementSelectorStep)new ElementSelectorStepByAttr("list", "name", name));
        ResourceList newResourceList = new ResourceList(new ListReferenceEndpointAddress(this.getAddress().getDocumentSelector(), new ElementSelector(elementSelectorSteps)), this, this.ra);
        ResourceList resourceList = this.lists.putIfAbsent(name, newResourceList);
        if (resourceList == null) {
            resourceList = newResourceList;
        }
        return resourceList;
    }

    private LinkedList<ElementSelectorStep> cloneListAddressElementSelectorSteps() {
        LinkedList<ElementSelectorStep> elementSelectorSteps = new LinkedList<ElementSelectorStep>();
        ListReferenceEndpointAddress listAddress = this.getAddress();
        ElementSelector listElementSelector = listAddress.getElementSelector();
        for (int j = 0; j < listElementSelector.getStepsSize(); ++j) {
            elementSelectorSteps.add(listElementSelector.getStep(j));
        }
        return elementSelectorSteps;
    }

    public ConcurrentHashMap<ListReferenceEndpointAddress, ListReferenceTo> getToReferences() {
        return this.toReferences;
    }

    @Override
    public RLSService.Status getStatus() {
        if (this.status == RLSService.Status.BAD_GATEWAY || this.status == RLSService.Status.DOES_NOT_EXISTS) {
            return this.status;
        }
        boolean resolving = false;
        RLSService.Status s = null;
        for (ResourceList list : this.lists.values()) {
            s = list.getStatus();
            if (s == RLSService.Status.BAD_GATEWAY) {
                return RLSService.Status.BAD_GATEWAY;
            }
            if (s != RLSService.Status.RESOLVING) continue;
            resolving = true;
        }
        for (ListReferenceTo reference : this.toReferences.values()) {
            s = reference.getStatus();
            if (s == RLSService.Status.BAD_GATEWAY) {
                return RLSService.Status.BAD_GATEWAY;
            }
            if (s != RLSService.Status.RESOLVING) continue;
            resolving = true;
        }
        if (resolving) {
            return RLSService.Status.RESOLVING;
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updated(ListReferenceTo referenceUpdated) {
        ResourceList resourceList = this;
        synchronized (resourceList) {
            if (this.updating) {
                return;
            }
            RLSService.Status referenceStatus = referenceUpdated.getStatus();
            if (this.status == RLSService.Status.BAD_GATEWAY) {
                if (referenceStatus != RLSService.Status.BAD_GATEWAY) {
                    this.setListType(this.listType);
                }
            } else if (referenceStatus == RLSService.Status.BAD_GATEWAY) {
                this.status = RLSService.Status.BAD_GATEWAY;
                this.updated();
            } else {
                if (referenceUpdated.getClass() == this.getClass()) {
                    if (referenceStatus == RLSService.Status.OK && this.isLoop((ResourceList)referenceUpdated, new HashSet<ListReferenceEndpointAddress>())) {
                        this.status = RLSService.Status.BAD_GATEWAY;
                    }
                } else if (referenceStatus == RLSService.Status.DOES_NOT_EXISTS) {
                    this.status = RLSService.Status.BAD_GATEWAY;
                }
                this.updated();
            }
        }
    }

    @Override
    void updated() {
        this.entriesCached = null;
        if (this.parent != null) {
            this.parent.updated(this);
        }
        super.updated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<EntryType> getEntries() {
        if (this.status == RLSService.Status.BAD_GATEWAY) {
            throw new IllegalStateException("list is in bad gateway state");
        }
        if (this.entriesCached != null) {
            return this.entriesCached;
        }
        ResourceList resourceList = this;
        synchronized (resourceList) {
            HashSet<EntryType> result = new HashSet<EntryType>();
            HashSet<String> entryURIs = new HashSet<String>();
            for (Entry entry : this.localEntries.values()) {
                if (!entryURIs.add(entry.getEntryType().getUri())) continue;
                result.add(entry.getEntryType());
            }
            for (ResourceList list : this.lists.values()) {
                for (EntryType entryType : list.getEntries()) {
                    if (!entryURIs.add(entryType.getUri())) continue;
                    result.add(entryType);
                }
            }
            for (ListReferenceTo reference : this.toReferences.values()) {
                for (EntryType entryType : reference.getEntries()) {
                    if (!entryURIs.add(entryType.getUri())) continue;
                    result.add(entryType);
                }
            }
            this.entriesCached = result;
            return this.entriesCached;
        }
    }

    @Override
    public ListReferenceTo addFromReference(ListReferenceFrom from, ListReferenceEndpointAddress toAddress) {
        int thisAddressStepsSize = this.getAddress().getElementSelector().getStepsSize();
        if (toAddress.getElementSelector().getStepsSize() > thisAddressStepsSize) {
            ElementSelectorStepByAttr elementSelectorStep = (ElementSelectorStepByAttr)toAddress.getElementSelector().getStep(thisAddressStepsSize);
            if (elementSelectorStep.getNameWithoutPrefix().equals("list")) {
                ResourceList resourceList = this.lists.get(elementSelectorStep.getAttrValue());
                if (resourceList == null) {
                    this.addResourceList(elementSelectorStep.getAttrValue());
                }
                return resourceList.addFromReference(from, toAddress);
            }
            Entry entry = this.localEntries.get(elementSelectorStep.getAttrValue());
            if (entry == null) {
                entry = this.addEntry(elementSelectorStep.getAttrValue());
            }
            return entry.addFromReference(from, toAddress);
        }
        return super.addFromReference(from, toAddress);
    }

    @Override
    public void removeFromReference(ListReferenceEndpointAddress fromAddress, ListReferenceEndpointAddress toAddress) {
        int thisAddressStepsSize = this.getAddress().getElementSelector().getStepsSize();
        if (toAddress.getElementSelector().getStepsSize() > thisAddressStepsSize) {
            ElementSelectorStepByAttr elementSelectorStep = (ElementSelectorStepByAttr)toAddress.getElementSelector().getStep(thisAddressStepsSize);
            if (elementSelectorStep.getNameWithoutPrefix().equals("list")) {
                ResourceList resourceList = this.lists.get(elementSelectorStep.getAttrValue());
                if (resourceList != null) {
                    resourceList.removeFromReference(fromAddress, toAddress);
                    if (resourceList.getStatus() == RLSService.Status.DOES_NOT_EXISTS && !resourceList.hasFromReferences()) {
                        this.lists.remove(elementSelectorStep.getAttrValue());
                    }
                }
            } else {
                Entry entry = this.localEntries.get(elementSelectorStep.getAttrValue());
                if (entry != null) {
                    entry.removeFromReference(fromAddress, toAddress);
                    if (entry.getStatus() == RLSService.Status.DOES_NOT_EXISTS && !entry.hasFromReferences()) {
                        this.localEntries.remove(elementSelectorStep.getAttrValue());
                    }
                }
            }
        } else {
            super.removeFromReference(fromAddress, toAddress);
        }
    }

    @Override
    public boolean hasFromReferences() {
        if (super.hasFromReferences()) {
            return true;
        }
        for (ResourceList list : this.lists.values()) {
            if (!list.hasFromReferences()) continue;
            return true;
        }
        for (Entry entry : this.localEntries.values()) {
            if (!entry.hasFromReferences()) continue;
            return true;
        }
        return false;
    }

    private boolean isLoop(ResourceList list, Set<ListReferenceEndpointAddress> references) {
        for (ResourceList innerList : list.lists.values()) {
            if (!references.add(innerList.getAddress())) continue;
            if (this.isLoop(innerList, references)) {
                // empty if block
            }
            return true;
        }
        for (ListReferenceTo reference : list.toReferences.values()) {
            if (!references.add(reference.getAddress())) continue;
            if (this.getAddress().getDocumentSelector().equals((Object)reference.getAddress().getDocumentSelector()) && this.getAddress().getElementSelector().toString().startsWith(reference.getAddress().getElementSelector().toString())) {
                return true;
            }
            if (reference.getClass() != this.getClass()) continue;
            if (this.isLoop((ResourceList)reference, references)) {
                // empty if block
            }
            return true;
        }
        return false;
    }
}

