/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.rlscache;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceActivity;
import org.mobicents.slee.sipevent.server.rlscache.RLSServicesCacheSbbInterface;
import org.mobicents.slee.sipevent.server.rlscache.events.WatchRLSServicesEvent;
import org.openxdm.xcap.common.datasource.Document;
import org.openxdm.xcap.common.error.InternalServerErrorException;
import org.openxdm.xcap.common.uri.DocumentSelector;
import org.openxdm.xcap.server.slee.resource.datasource.AttributeUpdatedEvent;
import org.openxdm.xcap.server.slee.resource.datasource.CollectionActivity;
import org.openxdm.xcap.server.slee.resource.datasource.DataSourceActivityContextInterfaceFactory;
import org.openxdm.xcap.server.slee.resource.datasource.DataSourceSbbInterface;
import org.openxdm.xcap.server.slee.resource.datasource.DocumentUpdatedEvent;
import org.openxdm.xcap.server.slee.resource.datasource.ElementUpdatedEvent;

public abstract class RLSServicesWatcherSbb
implements Sbb {
    private SbbContext context;
    private Tracer tracer;
    private DataSourceSbbInterface dataSourceRASbbInterface;
    private DataSourceActivityContextInterfaceFactory dataSourceRAActivityContextInterfaceFactory;
    private RLSServicesCacheSbbInterface rlsCacheRASbbInterface;

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext context) {
        this.context = context;
        this.tracer = context.getTracer(this.getClass().getSimpleName());
        try {
            Context ic = (Context)new InitialContext().lookup("java:comp/env");
            this.dataSourceRASbbInterface = (DataSourceSbbInterface)ic.lookup("slee/resources/xdm/datasource/1.0/sbbinterface");
            this.dataSourceRAActivityContextInterfaceFactory = (DataSourceActivityContextInterfaceFactory)ic.lookup("slee/resources/xdm/datasource/1.0/acif");
            this.rlsCacheRASbbInterface = (RLSServicesCacheSbbInterface)ic.lookup("slee/resources/sipevent/rlscache/1.0/sbbinterface");
        }
        catch (NamingException e) {
            this.tracer.severe("Failed to set sbb context", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        this.context = null;
        this.tracer = null;
        this.dataSourceRASbbInterface = null;
        this.dataSourceRAActivityContextInterfaceFactory = null;
        this.rlsCacheRASbbInterface = null;
    }

    public void onWatchRLSServicesEvent(WatchRLSServicesEvent event, ActivityContextInterface aci) {
        long start = System.currentTimeMillis();
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("onWatchRLSServicesEvent");
        }
        CollectionActivity appUsageActivity = this.dataSourceRASbbInterface.createCollectionActivity("rls-services");
        ActivityContextInterface appUsageActivityContextInterface = this.dataSourceRAActivityContextInterfaceFactory.getActivityContextInterface(appUsageActivity);
        appUsageActivityContextInterface.attach(this.context.getSbbLocalObject());
        DocumentSelector documentSelector = null;
        try {
            Document[] documents;
            for (Document document : documents = this.dataSourceRASbbInterface.getDocuments("rls-services/users", true)) {
                documentSelector = new DocumentSelector(document.getCollection(), document.getDocumentName());
                if (!documentSelector.isUserDocument()) continue;
                this.rlsCacheRASbbInterface.rlsServicesUpdated(documentSelector, document.getAsString());
            }
        }
        catch (InternalServerErrorException e) {
            this.tracer.severe("unable to fetch current rls services docs", (Throwable)e);
        }
        this.tracer.info("Total time to init rls cache: " + (System.currentTimeMillis() - start) + "ms");
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        Object activity = aci.getActivity();
        if (activity != null && activity instanceof RLSServiceActivity) {
            SbbLocalObject sbbLocalObject = this.context.getSbbLocalObject();
            for (ActivityContextInterface attachedACIs : this.context.getActivities()) {
                attachedACIs.detach(sbbLocalObject);
            }
        }
    }

    public void onAttributeUpdatedEvent(AttributeUpdatedEvent event, ActivityContextInterface aci) {
        if (!event.getDocumentSelector().isUserDocument()) {
            return;
        }
        this.rlsCacheRASbbInterface.rlsServicesUpdated(event.getDocumentSelector(), event.getNewDocumentString());
    }

    public void onDocumentUpdatedEvent(DocumentUpdatedEvent event, ActivityContextInterface aci) {
        if (!event.getDocumentSelector().isUserDocument()) {
            return;
        }
        this.rlsCacheRASbbInterface.rlsServicesUpdated(event.getDocumentSelector(), event.getNewDocumentString());
    }

    public void onElementUpdatedEvent(ElementUpdatedEvent event, ActivityContextInterface aci) {
        if (!event.getDocumentSelector().isUserDocument()) {
            return;
        }
        this.rlsCacheRASbbInterface.rlsServicesUpdated(event.getDocumentSelector(), event.getNewDocumentString());
    }
}

