/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.rlscache;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.sipevent.server.rlscache.RLSServicesCacheSbbInterface;
import org.mobicents.slee.sipevent.server.rlscache.ResourceListsActivity;
import org.mobicents.slee.sipevent.server.rlscache.events.WatchResourceListsEvent;
import org.openxdm.xcap.common.datasource.Document;
import org.openxdm.xcap.server.slee.resource.datasource.AttributeUpdatedEvent;
import org.openxdm.xcap.server.slee.resource.datasource.DataSourceActivityContextInterfaceFactory;
import org.openxdm.xcap.server.slee.resource.datasource.DataSourceSbbInterface;
import org.openxdm.xcap.server.slee.resource.datasource.DocumentActivity;
import org.openxdm.xcap.server.slee.resource.datasource.DocumentUpdatedEvent;
import org.openxdm.xcap.server.slee.resource.datasource.ElementUpdatedEvent;

public abstract class ResourceListsWatcherSbb
implements Sbb {
    private SbbContext context;
    private Tracer tracer;
    private DataSourceSbbInterface dataSourceRASbbInterface;
    private DataSourceActivityContextInterfaceFactory dataSourceRAActivityContextInterfaceFactory;
    private RLSServicesCacheSbbInterface rlsCacheRASbbInterface;

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext context) {
        this.context = context;
        this.tracer = context.getTracer(this.getClass().getSimpleName());
        try {
            Context ic = (Context)new InitialContext().lookup("java:comp/env");
            this.dataSourceRASbbInterface = (DataSourceSbbInterface)ic.lookup("slee/resources/xdm/datasource/1.0/sbbinterface");
            this.dataSourceRAActivityContextInterfaceFactory = (DataSourceActivityContextInterfaceFactory)ic.lookup("slee/resources/xdm/datasource/1.0/acif");
            this.rlsCacheRASbbInterface = (RLSServicesCacheSbbInterface)ic.lookup("slee/resources/sipevent/rlscache/1.0/sbbinterface");
        }
        catch (NamingException e) {
            this.tracer.severe("Failed to set sbb context", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        this.context = null;
        this.tracer = null;
        this.dataSourceRASbbInterface = null;
        this.dataSourceRAActivityContextInterfaceFactory = null;
        this.rlsCacheRASbbInterface = null;
    }

    public void onWatchResourceListsEvent(WatchResourceListsEvent event, ActivityContextInterface aci) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Watching resource list " + event.getDocumentSelector());
        }
        DocumentActivity activity = this.dataSourceRASbbInterface.createDocumentActivity(event.getDocumentSelector());
        ActivityContextInterface activityContextInterface = this.dataSourceRAActivityContextInterfaceFactory.getActivityContextInterface(activity);
        activityContextInterface.attach(this.context.getSbbLocalObject());
        try {
            Document document = this.dataSourceRASbbInterface.getDocument(event.getDocumentSelector());
            this.rlsCacheRASbbInterface.resourceListsUpdated(event.getDocumentSelector(), document != null ? document.getAsString() : null);
        }
        catch (Throwable e) {
            this.tracer.severe("unable to fetch global rls services doc", e);
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        Object activity = aci.getActivity();
        if (activity != null && activity instanceof ResourceListsActivity) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Stopped watching resource list " + ((ResourceListsActivity)activity).getDocumentSelector());
            }
            SbbLocalObject sbbLocalObject = this.context.getSbbLocalObject();
            for (ActivityContextInterface attachedACIs : this.context.getActivities()) {
                attachedACIs.detach(sbbLocalObject);
            }
        }
    }

    public void onAttributeUpdatedEvent(AttributeUpdatedEvent event, ActivityContextInterface aci) {
        this.rlsCacheRASbbInterface.resourceListsUpdated(event.getDocumentSelector(), event.getNewDocumentString());
    }

    public void onDocumentUpdatedEvent(DocumentUpdatedEvent event, ActivityContextInterface aci) {
        this.rlsCacheRASbbInterface.resourceListsUpdated(event.getDocumentSelector(), event.getNewDocumentString());
    }

    public void onElementUpdatedEvent(ElementUpdatedEvent event, ActivityContextInterface aci) {
        this.rlsCacheRASbbInterface.resourceListsUpdated(event.getDocumentSelector(), event.getNewDocumentString());
    }
}

