/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription;

import gov.nist.javax.sip.Utils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.sip.SipActivityContextInterfaceFactory;
import org.mobicents.slee.resource.sip.SipResourceAdaptorSbbInterface;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.pojo.SubscriptionKey;
import org.mobicents.slee.sipevent.server.subscription.winfo.pojo.Watcher;
import org.mobicents.slee.sipevent.server.subscription.winfo.pojo.WatcherList;
import org.mobicents.slee.sipevent.server.subscription.winfo.pojo.Watcherinfo;

public abstract class SubscriptionControlSbb
implements Sbb,
SubscriptionControlSbbLocalObject {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    protected SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory;
    protected SipProvider sipProvider;
    protected AddressFactory addressFactory;
    protected MessageFactory messageFactory;
    protected HeaderFactory headerFactory;
    protected TimerFacility timerFacility;
    protected ActivityContextNamingFacility activityContextNamingfacility;
    protected SbbContext sbbContext;
    protected Context context;
    private static EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"sipevent-subscription-pu");
    private static final JAXBContext winfoJAXBContext = SubscriptionControlSbb.initWInfoJAXBContext();

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        try {
            this.context = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)this.context.lookup("slee/facilities/timer");
            this.sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory)this.context.lookup("slee/resources/jainsip/1.2/acifactory");
            SipResourceAdaptorSbbInterface sipFactoryProvider = (SipResourceAdaptorSbbInterface)this.context.lookup("slee/resources/jainsip/1.2/provider");
            this.sipProvider = sipFactoryProvider.getSipProvider();
            this.addressFactory = sipFactoryProvider.getAddressFactory();
            this.headerFactory = sipFactoryProvider.getHeaderFactory();
            this.messageFactory = sipFactoryProvider.getMessageFactory();
            this.activityContextNamingfacility = (ActivityContextNamingFacility)this.context.lookup("slee/facilities/activitycontextnaming");
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Unable to retrieve factories, facilities & providers", (Throwable)e);
        }
    }

    protected Logger getLogger() {
        return logger;
    }

    protected abstract String[] getEventPackages();

    protected int getDefaultExpires() {
        return 3600;
    }

    protected int getMaxExpires() {
        return 3600;
    }

    protected int getMinExpires() {
        return this.getDefaultExpires();
    }

    protected int getDefaultWaitingExpires() {
        return 86400;
    }

    protected abstract String getContactAddressString();

    protected int getMaxForwards() {
        return 70;
    }

    protected abstract void isSubscriberAuthorized(RequestEvent var1, String var2, String var3, String var4, String var5, int var6);

    protected abstract NotifyContent getNotifyContent(Subscription var1);

    protected abstract Object filterContentPerSubscriber(String var1, String var2, String var3, Object var4);

    protected abstract Marshaller getMarshaller();

    protected abstract void removingSubscription(Subscription var1);

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            ServiceActivity sa = ((ServiceActivityFactory)myEnv.lookup("slee/serviceactivity/factory")).getActivity();
            if (!sa.equals(aci.getActivity())) {
                aci.detach(this.sbbContext.getSbbLocalObject());
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"failed to process service started event", (Throwable)e);
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        Object activity = aci.getActivity();
        if (activity instanceof ServiceActivity) {
            entityManagerFactory.close();
        }
    }

    public void onSubscribeOutOfDialog(RequestEvent event, ActivityContextInterface aci) {
        aci.detach(this.sbbContext.getSbbLocalObject());
        this.processSubscribe(event, aci);
    }

    public void onSubscribeInDialog(RequestEvent event, ActivityContextInterface aci) {
        this.processSubscribe(event, aci);
    }

    private void processSubscribe(RequestEvent event, ActivityContextInterface aci) {
        EventHeader eventHeader;
        EntityManager entityManager = this.getEntityManager();
        if (event.getRequest().getHeader("User-Agent") != null) {
            event.getRequest().removeHeader("User-Agent");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Processing SUBSCRIBE request...");
        }
        if ((eventHeader = (EventHeader)event.getRequest().getHeader("Event")) != null) {
            String eventPackage = eventHeader.getEventType();
            if (this.acceptsEventPackage(eventPackage)) {
                ExpiresHeader expiresHeader = event.getRequest().getExpires();
                int expires = expiresHeader == null ? this.getDefaultExpires() : expiresHeader.getExpires();
                if (expires > 0) {
                    if (expires >= this.getMinExpires()) {
                        Dialog dialog;
                        if (expires > this.getMaxExpires()) {
                            expires = this.getMaxExpires();
                        }
                        if ((dialog = event.getDialog()) == null) {
                            this.newSubscription(event, aci, eventPackage, eventHeader.getEventId(), expires);
                        } else {
                            String eventId = eventHeader.getEventId();
                            Subscription subscription = this.getSubscription(entityManager, dialog.getDialogId(), eventPackage, eventId);
                            if (subscription != null) {
                                if (subscription.getStatus().equals((Object)Subscription.Status.active) || subscription.getStatus().equals((Object)Subscription.Status.pending)) {
                                    this.refreshSubscription(event, aci, eventPackage, eventId, expires, subscription, entityManager);
                                } else {
                                    this.sendResponse(412, event.getRequest(), event.getServerTransaction());
                                }
                            } else {
                                this.newSubscription(event, aci, eventPackage, eventId, expires);
                            }
                        }
                    } else {
                        this.sendResponse(423, event.getRequest(), event.getServerTransaction());
                    }
                } else if (expires == 0) {
                    Dialog dialog = event.getDialog();
                    if (dialog != null) {
                        String eventId = eventHeader.getEventId();
                        Subscription subscription = this.getSubscription(entityManager, dialog.getDialogId(), eventPackage, eventId);
                        if (subscription != null) {
                            if (subscription.getStatus().equals((Object)Subscription.Status.active) || subscription.getStatus().equals((Object)Subscription.Status.pending)) {
                                try {
                                    Response response = this.messageFactory.createResponse(200, event.getRequest());
                                    response = this.addContactHeader(response);
                                    response.addHeader((Header)this.headerFactory.createExpiresHeader(expires));
                                    event.getServerTransaction().sendResponse(response);
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug((Object)("Response sent:\n" + response.toString()));
                                    }
                                }
                                catch (Exception e) {
                                    this.getLogger().error((Object)"Can't send RESPONSE", (Throwable)e);
                                }
                                this.removeSubscription(aci, eventPackage, eventId, subscription, entityManager);
                            } else {
                                this.sendResponse(412, event.getRequest(), event.getServerTransaction());
                            }
                        } else {
                            this.sendResponse(412, event.getRequest(), event.getServerTransaction());
                        }
                    } else {
                        this.sendResponse(412, event.getRequest(), event.getServerTransaction());
                    }
                } else {
                    this.sendResponse(400, event.getRequest(), event.getServerTransaction());
                }
            } else {
                this.sendResponse(489, event.getRequest(), event.getServerTransaction());
            }
        } else {
            this.sendResponse(400, event.getRequest(), event.getServerTransaction());
        }
        entityManager.flush();
        entityManager.close();
    }

    public void onResponseClientErrorEvent(ResponseEvent event, ActivityContextInterface aci) {
        if (event.getDialog() != null) {
            this.removeDialogSubscriptions(event.getDialog());
        }
    }

    public void onResponseServerErrorEvent(ResponseEvent event, ActivityContextInterface aci) {
        if (event.getDialog() != null) {
            this.removeDialogSubscriptions(event.getDialog());
        }
    }

    private void newSubscription(RequestEvent event, ActivityContextInterface aci, String eventPackage, String eventId, int expires) {
        Address fromAddress = ((FromHeader)event.getRequest().getHeader("From")).getAddress();
        String subscriber = fromAddress.getURI().toString();
        ToHeader toHeader = (ToHeader)event.getRequest().getHeader("To");
        String notifier = toHeader.getAddress().getURI().toString();
        if (event.getDialog() == null) {
            try {
                this.sipProvider.getNewDialog((Transaction)event.getServerTransaction());
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Can't create dialog", (Throwable)e);
                try {
                    Response response = this.messageFactory.createResponse(500, event.getRequest());
                    response = this.addContactHeader(response);
                    event.getServerTransaction().sendResponse(response);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Response sent:\n" + response.toString()));
                    }
                }
                catch (Exception f) {
                    this.getLogger().error((Object)"Can't send RESPONSE", (Throwable)f);
                }
                return;
            }
        }
        if (eventPackage.endsWith(".winfo")) {
            this.newSubscriptionAuthorization(event, subscriber, notifier, eventPackage, eventId, expires, subscriber.equals(notifier) ? 200 : 403);
        } else {
            this.isSubscriberAuthorized(event, subscriber, notifier, eventPackage, eventId, expires);
        }
    }

    protected void newSubscriptionAuthorization(RequestEvent event, String subscriber, String notifier, String eventPackage, String eventId, int expires, int responseCode) {
        ActivityContextInterface dialogAci;
        Dialog dialog;
        EntityManager entityManager;
        block12: {
            entityManager = this.getEntityManager();
            dialog = event.getServerTransaction().getDialog();
            dialogAci = null;
            try {
                Response response = this.messageFactory.createResponse(responseCode, event.getRequest());
                if (responseCode == 202 || responseCode == 200) {
                    ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                    responseToHeader.setTag(Utils.generateTag());
                    SbbLocalObject sbbLocalObject = this.sbbContext.getSbbLocalObject();
                    dialogAci = this.sipActivityContextInterfaceFactory.getActivityContextInterface(dialog);
                    dialogAci.attach(sbbLocalObject);
                    response = this.addContactHeader(response);
                    response.addHeader((Header)this.headerFactory.createExpiresHeader(expires));
                    event.getServerTransaction().sendResponse(response);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Response sent:\n" + response.toString()));
                    }
                    break block12;
                }
                response = this.addContactHeader(response);
                event.getServerTransaction().sendResponse(response);
                this.getLogger().info((Object)("Subscription: subscriber=" + subscriber + ",notifier=" + notifier + ",eventPackage=" + eventPackage + " not authorized (" + responseCode + ")"));
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Response sent:\n" + response.toString()));
                }
                entityManager.close();
                return;
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Can't send new subscription request's reponse", (Throwable)e);
                try {
                    Response response = this.messageFactory.createResponse(500, event.getRequest());
                    response = this.addContactHeader(response);
                    event.getServerTransaction().sendResponse(response);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Response sent:\n" + response.toString()));
                    }
                }
                catch (Exception f) {
                    this.getLogger().error((Object)"Can't send RESPONSE", (Throwable)f);
                }
                entityManager.close();
                return;
            }
        }
        String subscriberDisplayName = ((FromHeader)event.getRequest().getHeader("From")).getAddress().getDisplayName();
        SubscriptionKey subscriptionKey = new SubscriptionKey(dialog.getDialogId(), eventPackage, eventId);
        Subscription.Status initialStatus = responseCode == 202 ? Subscription.Status.pending : Subscription.Status.active;
        Subscription subscription = new Subscription(subscriptionKey, subscriber, notifier, initialStatus, subscriberDisplayName, expires);
        try {
            this.createAndSendNotify(entityManager, subscription, dialog);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"failed to notify subscriber", (Throwable)e);
        }
        this.notifyWinfoSubscriptions(entityManager, subscription);
        try {
            this.activityContextNamingfacility.bind(dialogAci, subscriptionKey.toString());
        }
        catch (Exception e) {
            this.getLogger().error((Object)"failed to bind a name to dialog's aci", (Throwable)e);
        }
        this.setSubscriptionTimer(entityManager, subscription, expires + 5, dialogAci);
        entityManager.flush();
        entityManager.close();
        this.getLogger().info((Object)("Created " + subscription));
    }

    private void refreshSubscription(RequestEvent event, ActivityContextInterface aci, String eventPackage, String eventId, int expires, Subscription subscription, EntityManager entityManager) {
        this.timerFacility.cancelTimer(subscription.getTimerID());
        subscription.refresh(expires);
        try {
            Response response = this.messageFactory.createResponse(200, event.getRequest());
            response = this.addContactHeader(response);
            response.addHeader((Header)this.headerFactory.createExpiresHeader(expires));
            event.getServerTransaction().sendResponse(response);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Response sent:\n" + response.toString()));
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Can't send RESPONSE", (Throwable)e);
        }
        try {
            this.createAndSendNotify(entityManager, subscription, (Dialog)aci.getActivity());
        }
        catch (Exception e) {
            this.getLogger().error((Object)"failed to notify subscriber", (Throwable)e);
        }
        this.setSubscriptionTimer(entityManager, subscription, expires + 5, aci);
        this.getLogger().info((Object)("Refreshed " + subscription + " for " + expires + " seconds"));
    }

    private void removeSubscription(ActivityContextInterface aci, String eventPackage, String eventId, Subscription subscription, EntityManager entityManager) {
        this.timerFacility.cancelTimer(subscription.getTimerID());
        subscription.changeStatus(Subscription.Event.timeout);
        Dialog dialog = (Dialog)aci.getActivity();
        try {
            this.createAndSendNotify(entityManager, subscription, dialog);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"failed to notify subscriber", (Throwable)e);
        }
        this.notifyWinfoSubscriptions(entityManager, subscription);
        if (subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
            this.getLogger().info((Object)("Status changed for " + subscription));
            this.removeSubscriptionData(entityManager, subscription, dialog, aci);
        } else if (subscription.getStatus().equals((Object)Subscription.Status.waiting)) {
            this.getLogger().info((Object)("Status changed for " + subscription));
            subscription.refresh(this.getDefaultWaitingExpires());
            this.setSubscriptionTimer(entityManager, subscription, this.getDefaultWaitingExpires() + 5, aci);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        Dialog dialog = (Dialog)aci.getActivity();
        EntityManager entityManager = this.getEntityManager();
        Subscription subscription = (Subscription)entityManager.createQuery("SELECT s FROM Subscription s WHERE s.timerID = :timerID").setParameter("timerID", (Object)event.getTimerID()).getSingleResult();
        if (subscription != null) {
            this.getLogger().info((Object)("Timer expired for " + subscription));
            if (subscription.getStatus().equals((Object)Subscription.Status.waiting)) {
                subscription.changeStatus(Subscription.Event.giveup);
                this.getLogger().info((Object)("Status changed for " + subscription));
                this.notifyWinfoSubscriptions(entityManager, subscription);
                this.removeSubscriptionData(entityManager, subscription, dialog, aci);
            } else {
                this.removeSubscription(aci, subscription.getSubscriptionKey().getEventPackage(), subscription.getSubscriptionKey().getRealEventId(), subscription, entityManager);
                entityManager.flush();
            }
            entityManager.close();
        }
    }

    public void notifySubscribers(String notifier, String eventPackage, Object content, ContentTypeHeader contentTypeHeader) {
        EntityManager entityManager = this.getEntityManager();
        List resultList = entityManager.createQuery("SELECT s FROM Subscription s WHERE s.notifier = :notifier AND s.subscriptionKey.eventPackage = :eventPackage").setParameter("notifier", (Object)notifier).setParameter("eventPackage", (Object)eventPackage).getResultList();
        SbbLocalObject sbbLocalObject = this.sbbContext.getSbbLocalObject();
        for (Subscription subscription : resultList) {
            if (!subscription.getStatus().equals((Object)Subscription.Status.active)) continue;
            try {
                ActivityContextInterface dialogACI = this.activityContextNamingfacility.lookup(subscription.getSubscriptionKey().toString());
                if (dialogACI != null) {
                    Dialog dialog = (Dialog)dialogACI.getActivity();
                    Request notify = this.createNotify(dialog, subscription);
                    if (content != null) {
                        notify = this.setNotifyContent(subscription, notify, content, contentTypeHeader);
                    }
                    ClientTransaction clientTransaction = this.sipProvider.getNewClientTransaction(notify);
                    this.sipActivityContextInterfaceFactory.getActivityContextInterface(clientTransaction).attach(sbbLocalObject);
                    dialog.sendRequest(clientTransaction);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug((Object)("NotifySubscribers: subscription " + subscription.getSubscriptionKey() + " sent request:\n" + notify.toString()));
                    continue;
                }
                this.getLogger().warn((Object)("Unable to find dialog aci to notify subscription " + subscription.getSubscriptionKey() + ". Removing subscription data"));
                this.removeSubscriptionData(entityManager, subscription, null, null);
            }
            catch (Exception e) {
                this.getLogger().error((Object)"failed to notify subscriber", (Throwable)e);
            }
        }
        entityManager.close();
    }

    public void notifySubscriber(SubscriptionKey key, Object content, ContentTypeHeader contentTypeHeader) {
        EntityManager entityManager = this.getEntityManager();
        Subscription subscription = (Subscription)entityManager.createQuery("SELECT s FROM Subscription s WHERE s.subscriptionKey.dialogId = :dialogId AND s.subscriptionKey.eventPackage = :eventPackage AND s.subscriptionKey.eventId = :eventId").setParameter("dialogId", (Object)key.getDialogId()).setParameter("eventPackage", (Object)key.getEventPackage()).setParameter("eventId", (Object)key.getEventId()).getSingleResult();
        if (subscription != null && subscription.getStatus().equals((Object)Subscription.Status.active)) {
            try {
                ActivityContextInterface dialogACI = this.activityContextNamingfacility.lookup(subscription.getSubscriptionKey().toString());
                if (dialogACI != null) {
                    Dialog dialog = (Dialog)dialogACI.getActivity();
                    Request notify = this.createNotify(dialog, subscription);
                    if (content != null) {
                        notify = this.setNotifyContent(subscription, notify, content, contentTypeHeader);
                    }
                    ClientTransaction clientTransaction = this.sipProvider.getNewClientTransaction(notify);
                    this.sipActivityContextInterfaceFactory.getActivityContextInterface(clientTransaction).attach(this.sbbContext.getSbbLocalObject());
                    dialog.sendRequest(clientTransaction);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Notify subscriber: subscription " + subscription.getSubscriptionKey() + " sent request:\n" + notify.toString()));
                    }
                } else {
                    this.getLogger().warn((Object)("Unable to find dialog aci to notify subscription " + subscription.getSubscriptionKey() + ". Removing subscription data"));
                    this.removeSubscriptionData(entityManager, subscription, null, null);
                }
            }
            catch (Exception e) {
                this.getLogger().error((Object)"failed to notify subscriber", (Throwable)e);
            }
        }
        entityManager.close();
    }

    protected void authorizationChanged(String subscriber, String notifier, String eventPackage, int authorizationCode) {
        EntityManager entityManager = this.getEntityManager();
        Dialog dialog = null;
        ActivityContextInterface dialogACI = null;
        for (ActivityContextInterface aci : this.sbbContext.getActivities()) {
            Object activity = aci.getActivity();
            if (!(activity instanceof Dialog)) continue;
            dialogACI = aci;
            dialog = (Dialog)activity;
        }
        if (dialog != null) {
            block8: for (Object object : this.getDialogSubscriptions(entityManager, dialog)) {
                Subscription subscription = (Subscription)object;
                if (!subscription.getSubscriber().equals(subscriber) || !subscription.getNotifier().equals(notifier) || !subscription.getSubscriptionKey().getEventPackage().equals(eventPackage)) continue;
                Subscription.Status oldStatus = subscription.getStatus();
                switch (authorizationCode) {
                    case 403: {
                        subscription.changeStatus(Subscription.Event.rejected);
                        break;
                    }
                    case 202: {
                        if (!subscription.getStatus().equals((Object)Subscription.Status.active)) break;
                        subscription.setStatus(Subscription.Status.pending);
                        subscription.setLastEvent(null);
                        break;
                    }
                    case 200: {
                        subscription.changeStatus(Subscription.Event.approved);
                        break;
                    }
                    default: {
                        this.getLogger().warn((Object)("Received authorization update with unknown auth code " + authorizationCode));
                        continue block8;
                    }
                }
                if (oldStatus.equals((Object)subscription.getStatus())) continue;
                this.getLogger().info((Object)("Status changed for " + subscription));
                try {
                    this.createAndSendNotify(entityManager, subscription, dialog);
                }
                catch (Exception e) {
                    this.getLogger().error((Object)"failed to notify subscriber", (Throwable)e);
                }
                this.notifyWinfoSubscriptions(entityManager, subscription);
                if (subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
                    this.removeSubscriptionData(entityManager, subscription, dialog, dialogACI);
                    continue;
                }
                if (!subscription.getStatus().equals((Object)Subscription.Status.waiting)) continue;
                subscription.refresh(this.getDefaultWaitingExpires());
                this.setSubscriptionTimer(entityManager, subscription, this.getDefaultWaitingExpires() + 5, dialogACI);
            }
        }
        entityManager.flush();
        entityManager.close();
    }

    private Request setNotifyContent(Subscription subscription, Request notify, Object content, ContentTypeHeader contentTypeHeader) throws JAXBException, ParseException, IOException {
        Object filteredContent = this.filterContentPerSubscriber(subscription.getSubscriber(), subscription.getNotifier(), subscription.getSubscriptionKey().getEventPackage(), content);
        StringWriter stringWriter = new StringWriter();
        this.getMarshaller().marshal(filteredContent, (Writer)stringWriter);
        notify.setContent((Object)stringWriter.toString(), contentTypeHeader);
        stringWriter.close();
        return notify;
    }

    private void setSubscriptionTimer(EntityManager entityManager, Subscription subscription, long delay, ActivityContextInterface aci) {
        TimerOptions options = new TimerOptions();
        options.setPersistent(true);
        options.setPreserveMissed(TimerPreserveMissed.ALL);
        TimerID timerId = this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + delay * 1000L, 1L, 1, options);
        subscription.setTimerID(timerId);
        entityManager.persist((Object)subscription);
    }

    private void createAndSendNotify(EntityManager entityManager, Subscription subscription, Dialog dialog) throws TransactionDoesNotExistException, SipException, ParseException {
        Request notify = this.createNotify(dialog, subscription);
        if (subscription.getStatus().equals((Object)Subscription.Status.active)) {
            if (subscription.getSubscriptionKey().getEventPackage().endsWith(".winfo")) {
                subscription.incrementVersion();
                entityManager.persist((Object)subscription);
                entityManager.flush();
                notify.setContent((Object)this.getFullWatcherInfoContent(entityManager, subscription), this.getWatcherInfoContentHeader());
            } else {
                NotifyContent notifyContent = this.getNotifyContent(subscription);
                if (notifyContent != null) {
                    try {
                        notify = this.setNotifyContent(subscription, notify, notifyContent.getContent(), notifyContent.getContentTypeHeader());
                    }
                    catch (Exception e) {
                        this.getLogger().error((Object)"failed to set notify content", (Throwable)e);
                    }
                }
            }
        }
        ClientTransaction clientTransaction = this.sipProvider.getNewClientTransaction(notify);
        dialog.sendRequest(clientTransaction);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Request sent:\n" + notify.toString()));
        }
    }

    private void removeSubscriptionData(EntityManager entityManager, Subscription subscription, Dialog dialog, ActivityContextInterface aci) {
        this.removingSubscription(subscription);
        entityManager.remove((Object)subscription);
        try {
            this.activityContextNamingfacility.unbind(subscription.getSubscriptionKey().toString());
        }
        catch (Exception e) {
            this.getLogger().error((Object)"failed to unbind subscription dialog aci name");
        }
        if (dialog != null) {
            this.verifyDialogSubscriptions(entityManager, subscription, dialog, aci);
        }
        entityManager.flush();
        this.getLogger().info((Object)("Removed data for " + subscription));
    }

    private List getDialogSubscriptions(EntityManager entityManager, Dialog dialog) {
        return entityManager.createQuery("SELECT s FROM Subscription s WHERE s.subscriptionKey.dialogId = :dialogId").setParameter("dialogId", (Object)dialog.getDialogId()).getResultList();
    }

    private void verifyDialogSubscriptions(EntityManager entityManager, Subscription removedSubscription, Dialog dialog, ActivityContextInterface dialogAci) {
        List subscriptionsInDialog = this.getDialogSubscriptions(entityManager, dialog);
        if (subscriptionsInDialog.size() == 0) {
            this.getLogger().info((Object)"No more subscriptions on dialog, deleting...");
            dialogAci.detach(this.sbbContext.getSbbLocalObject());
            dialog.delete();
        }
    }

    private void notifyWinfoSubscriptions(EntityManager entityManager, Subscription subscription) {
        List winfoSubscriptions;
        if (!subscription.getSubscriptionKey().getEventPackage().endsWith(".winfo") && !(winfoSubscriptions = entityManager.createQuery("SELECT s FROM Subscription s WHERE s.notifier = :notifier AND s.subscriptionKey.eventPackage = :eventPackage").setParameter("notifier", (Object)subscription.getNotifier()).setParameter("eventPackage", (Object)(subscription.getSubscriptionKey().getEventPackage() + ".winfo")).getResultList()).isEmpty()) {
            SbbLocalObject sbbLocalObject = this.sbbContext.getSbbLocalObject();
            for (Subscription winfoSubscription : winfoSubscriptions) {
                if (!winfoSubscription.getStatus().equals((Object)Subscription.Status.active)) continue;
                try {
                    ActivityContextInterface winfoDialogAci = this.activityContextNamingfacility.lookup(winfoSubscription.getSubscriptionKey().toString());
                    if (winfoDialogAci != null) {
                        Dialog winfoDialog = (Dialog)winfoDialogAci.getActivity();
                        winfoSubscription.incrementVersion();
                        Request notify = this.createNotify(winfoDialog, winfoSubscription);
                        notify.setContent((Object)this.getPartialWatcherInfoContent(winfoSubscription, subscription), this.getWatcherInfoContentHeader());
                        ClientTransaction clientTransaction = this.sipProvider.getNewClientTransaction(notify);
                        this.sipActivityContextInterfaceFactory.getActivityContextInterface(clientTransaction).attach(sbbLocalObject);
                        winfoDialog.sendRequest(clientTransaction);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)("Request sent:\n" + notify.toString()));
                        }
                        entityManager.persist((Object)winfoSubscription);
                        continue;
                    }
                    this.getLogger().warn((Object)("Unable to find dialog aci to notify subscription " + winfoSubscription.getSubscriptionKey() + ". Removing subscription data"));
                    this.removeSubscriptionData(entityManager, winfoSubscription, null, null);
                }
                catch (Exception e) {
                    this.getLogger().error((Object)"failed to notify winfo subscriber", (Throwable)e);
                }
            }
            entityManager.flush();
        }
    }

    private Subscription getSubscription(EntityManager entityManager, String dialogId, String eventPackage, String eventId) {
        try {
            return (Subscription)entityManager.createQuery("SELECT s FROM Subscription s WHERE s.subscriptionKey.dialogId = :dialogId AND s.subscriptionKey.eventPackage = :eventPackage AND s.subscriptionKey.eventId = :eventId").setParameter("dialogId", (Object)dialogId).setParameter("eventPackage", (Object)eventPackage).setParameter("eventId", (Object)SubscriptionKey.getEventIdPersisted((String)eventId)).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private void sendResponse(int responseCode, Request request, ServerTransaction serverTransaction) {
        try {
            Response response = this.messageFactory.createResponse(responseCode, request);
            if (responseCode == 489) {
                String allowEventsHeader = "";
                boolean first = true;
                for (String acceptedEventPackage : this.getEventPackages()) {
                    allowEventsHeader = first ? allowEventsHeader + acceptedEventPackage + "," + acceptedEventPackage + ".winfo" : allowEventsHeader + "," + acceptedEventPackage + "," + acceptedEventPackage + ".winfo";
                }
                response.addHeader((Header)this.headerFactory.createAllowEventsHeader(allowEventsHeader));
            } else if (responseCode == 423) {
                response.addHeader((Header)this.headerFactory.createMinExpiresHeader(this.getMinExpires()));
            }
            response = this.addContactHeader(response);
            serverTransaction.sendResponse(response);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Response sent:\n" + response.toString()));
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Can't send response!", (Throwable)e);
        }
    }

    private Response addContactHeader(Response response) {
        if (response.getHeader("Contact") != null) {
            response.removeHeader("Contact");
        }
        try {
            ListeningPoint listeningPoint = this.sipProvider.getListeningPoint("udp");
            Address address = this.addressFactory.createAddress(this.getContactAddressString() + " <sip:" + listeningPoint.getIPAddress() + ">");
            ((SipURI)address.getURI()).setPort(listeningPoint.getPort());
            response.addHeader((Header)this.headerFactory.createContactHeader(address));
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Can't add contact header", (Throwable)e);
        }
        return response;
    }

    private Request createNotify(Dialog dialog, Subscription subscription) {
        Request notify = null;
        try {
            notify = dialog.createRequest("NOTIFY");
            EventHeader eventHeader = this.headerFactory.createEventHeader(subscription.getSubscriptionKey().getEventPackage());
            if (subscription.getSubscriptionKey().getRealEventId() != null) {
                eventHeader.setEventId(subscription.getSubscriptionKey().getRealEventId());
            }
            notify.setHeader((Header)eventHeader);
            notify.setHeader((Header)this.headerFactory.createMaxForwardsHeader(this.getMaxForwards()));
            SubscriptionStateHeader ssh = null;
            if (subscription.getStatus().equals((Object)Subscription.Status.active) || subscription.getStatus().equals((Object)Subscription.Status.pending)) {
                ssh = this.headerFactory.createSubscriptionStateHeader(subscription.getStatus().toString());
                ssh.setExpires(subscription.getRemainingExpires());
            } else if (subscription.getStatus().equals((Object)Subscription.Status.waiting) || subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
                ssh = this.headerFactory.createSubscriptionStateHeader("terminated");
                ssh.setReasonCode(subscription.getLastEvent().toString());
            }
            notify.addHeader((Header)ssh);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"unable to fill notify headers", (Throwable)e);
        }
        return notify;
    }

    private boolean acceptsEventPackage(String eventPackage) {
        if (eventPackage != null) {
            for (String acceptedEventPackage : this.getEventPackages()) {
                if (!eventPackage.equals(acceptedEventPackage) && !eventPackage.equals(acceptedEventPackage + ".winfo")) continue;
                return true;
            }
        }
        return false;
    }

    private void removeDialogSubscriptions(Dialog dialog) {
        EntityManager entityManager = this.getEntityManager();
        for (Object object : this.getDialogSubscriptions(entityManager, dialog)) {
            Subscription subscription = (Subscription)object;
            this.getLogger().info((Object)("Removing " + subscription.getSubscriptionKey() + " data due to error on notify response."));
            this.removeSubscriptionData(entityManager, subscription, dialog, this.activityContextNamingfacility.lookup(subscription.getSubscriptionKey().toString()));
        }
        entityManager.flush();
        entityManager.close();
    }

    private EntityManager getEntityManager() {
        return entityManagerFactory.createEntityManager();
    }

    private static JAXBContext initWInfoJAXBContext() {
        try {
            return JAXBContext.newInstance((String)"org.mobicents.slee.sipevent.server.subscription.winfo.pojo");
        }
        catch (JAXBException e) {
            logger.error((Object)"failed to create winfo jaxb context");
            return null;
        }
    }

    private Marshaller getWInfoMarshaller() {
        try {
            return winfoJAXBContext.createMarshaller();
        }
        catch (JAXBException e) {
            this.getLogger().error((Object)"failed to create winfo unmarshaller", (Throwable)e);
            return null;
        }
    }

    private Watcher createWInfoWatcher(Subscription subscription) {
        Watcher watcher = new Watcher();
        watcher.setId(String.valueOf(subscription.hashCode()));
        watcher.setStatus(subscription.getStatus().toString());
        watcher.setDurationSubscribed(BigInteger.valueOf(subscription.getSubscriptionDuration()));
        if (subscription.getLastEvent() != null) {
            watcher.setEvent(subscription.getLastEvent().toString());
        }
        if (subscription.getSubscriberDisplayName() != null) {
            watcher.setDisplayName(subscription.getSubscriberDisplayName());
        }
        if (!subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
            watcher.setExpiration(BigInteger.valueOf(subscription.getRemainingExpires()));
        }
        watcher.setValue(subscription.getSubscriber());
        return watcher;
    }

    private String marshallWInfo(Watcherinfo watcherinfo) {
        String result = null;
        StringWriter stringWriter = new StringWriter();
        try {
            Marshaller marshaller = this.getWInfoMarshaller();
            marshaller.marshal((Object)watcherinfo, (Writer)stringWriter);
            result = stringWriter.toString();
            stringWriter.close();
        }
        catch (Exception e) {
            this.getLogger().error((Object)"failed to marshall winfo", (Throwable)e);
            try {
                stringWriter.close();
            }
            catch (Exception f) {
                this.getLogger().error((Object)"failed to close winfo string writer", (Throwable)f);
            }
        }
        return result;
    }

    private String getPartialWatcherInfoContent(Subscription winfoSubscription, Subscription subscription) {
        Watcherinfo watcherinfo = new Watcherinfo();
        watcherinfo.setVersion(BigInteger.valueOf(winfoSubscription.getVersion()));
        watcherinfo.setState("partial");
        WatcherList watcherList = new WatcherList();
        watcherList.setResource(winfoSubscription.getNotifier());
        watcherList.setPackage(subscription.getSubscriptionKey().getEventPackage());
        watcherList.getWatcher().add(this.createWInfoWatcher(subscription));
        watcherinfo.getWatcherList().add(watcherList);
        return this.marshallWInfo(watcherinfo);
    }

    private String getFullWatcherInfoContent(EntityManager entityManager, Subscription winfoSubscription) {
        Watcherinfo watcherinfo = new Watcherinfo();
        watcherinfo.setVersion(BigInteger.valueOf(winfoSubscription.getVersion()));
        watcherinfo.setState("full");
        WatcherList watcherList = new WatcherList();
        watcherList.setResource(winfoSubscription.getNotifier());
        String winfoEventPackage = winfoSubscription.getSubscriptionKey().getEventPackage();
        String eventPackage = winfoEventPackage.substring(0, winfoEventPackage.indexOf(".winfo"));
        watcherList.setPackage(eventPackage);
        List resultList = entityManager.createQuery("SELECT s FROM Subscription s WHERE s.subscriptionKey.eventPackage=:eventPackage AND s.notifier=:notifier").setParameter("eventPackage", (Object)eventPackage).setParameter("notifier", (Object)winfoSubscription.getNotifier()).getResultList();
        List watchers = watcherList.getWatcher();
        for (Subscription subscription : resultList) {
            watchers.add(this.createWInfoWatcher(subscription));
        }
        watcherinfo.getWatcherList().add(watcherList);
        return this.marshallWInfo(watcherinfo);
    }

    private ContentTypeHeader getWatcherInfoContentHeader() throws ParseException {
        return this.headerFactory.createContentTypeHeader("application", "watcherinfo+xml");
    }

    public InitialEventSelector ies(InitialEventSelector ies) {
        if (ies.getActivity() instanceof ServerTransaction && ((RequestEvent)ies.getEvent()).getDialog() != null) {
            this.getLogger().warn((Object)"Filtering request event on server tx activity with dialog not null");
            ies.setInitialEvent(false);
        } else {
            ies.setActivityContextSelected(true);
        }
        return ies;
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }
}

