/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.sip;

import gov.nist.javax.sip.Utils;
import javax.persistence.EntityManager;
import javax.sip.Dialog;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.SbbLocalObject;
import net.java.slee.resource.sip.DialogActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.pojo.SubscriptionKey;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;

public class NewSipSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private SipSubscriptionHandler sipSubscriptionHandler;

    public NewSipSubscriptionHandler(SipSubscriptionHandler sipSubscriptionHandler) {
        this.sipSubscriptionHandler = sipSubscriptionHandler;
    }

    public void newSipSubscription(RequestEvent event, ActivityContextInterface aci, String eventPackage, String eventId, int expires, EntityManager entityManager, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        Address fromAddress = ((FromHeader)event.getRequest().getHeader("From")).getAddress();
        String subscriber = fromAddress.getURI().toString();
        ToHeader toHeader = (ToHeader)event.getRequest().getHeader("To");
        String notifier = toHeader.getAddress().getURI().toString();
        Dialog dialog = event.getDialog();
        if (dialog == null) {
            try {
                dialog = this.sipSubscriptionHandler.sbb.getSipProvider().getNewDialog((Transaction)event.getServerTransaction());
            }
            catch (Exception e) {
                logger.error((Object)"Can't create dialog", (Throwable)e);
                try {
                    Response response = this.sipSubscriptionHandler.sbb.getMessageFactory().createResponse(500, event.getRequest());
                    response = this.sipSubscriptionHandler.addContactHeader(response);
                    event.getServerTransaction().sendResponse(response);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Response sent:\n" + response.toString()));
                    }
                }
                catch (Exception f) {
                    logger.error((Object)"Can't send RESPONSE", (Throwable)f);
                }
                return;
            }
        }
        SubscriptionKey key = new SubscriptionKey(dialog.getCallId().getCallId(), dialog.getRemoteTag(), eventPackage, eventId);
        if (eventPackage.endsWith(".winfo")) {
            this.newSipSubscriptionAuthorization(event.getServerTransaction(), aci, subscriber, fromAddress.getDisplayName(), notifier, key, expires, subscriber.equals(notifier) ? 200 : 403, entityManager, childSbb);
        } else {
            String content = null;
            String contentType = null;
            String contentSubtype = null;
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)event.getRequest().getHeader("Content-Type");
            if (contentTypeHeader != null) {
                contentType = contentTypeHeader.getContentType();
                contentSubtype = contentTypeHeader.getContentSubType();
                content = new String(event.getRequest().getRawContent());
            }
            childSbb.isSubscriberAuthorized(subscriber, fromAddress.getDisplayName(), notifier, key, expires, content, contentType, contentSubtype);
        }
    }

    public void newSipSubscriptionAuthorization(ServerTransaction serverTransaction, ActivityContextInterface serverTransactionACI, String subscriber, String subscriberDisplayName, String notifier, SubscriptionKey key, int expires, int responseCode, EntityManager entityManager, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        ActivityContextInterface dialogAci;
        Dialog dialog;
        block15: {
            dialog = serverTransaction.getDialog();
            dialogAci = null;
            try {
                Response response = this.sipSubscriptionHandler.sbb.getMessageFactory().createResponse(responseCode, serverTransaction.getRequest());
                if (responseCode == 202 || responseCode == 200) {
                    ToHeader responseToHeader = (ToHeader)response.getHeader("To");
                    responseToHeader.setTag(Utils.generateTag());
                    SbbLocalObject sbbLocalObject = this.sipSubscriptionHandler.sbb.getSbbContext().getSbbLocalObject();
                    dialogAci = this.sipSubscriptionHandler.sbb.getSipActivityContextInterfaceFactory().getActivityContextInterface((DialogActivity)dialog);
                    dialogAci.attach(sbbLocalObject);
                    if (serverTransactionACI != null) {
                        serverTransactionACI.detach(sbbLocalObject);
                    }
                    response = this.sipSubscriptionHandler.addContactHeader(response);
                    response.addHeader((Header)this.sipSubscriptionHandler.sbb.getHeaderFactory().createExpiresHeader(expires));
                    serverTransaction.sendResponse(response);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Response sent:\n" + response.toString()));
                    }
                    break block15;
                }
                response = this.sipSubscriptionHandler.addContactHeader(response);
                serverTransaction.sendResponse(response);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Subscription: subscriber=" + subscriber + ",notifier=" + notifier + ",eventPackage=" + key.getEventPackage() + " not authorized (" + responseCode + ")"));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Response sent:\n" + response.toString()));
                }
                return;
            }
            catch (Exception e) {
                logger.error((Object)"Can't send new subscription request's reponse", (Throwable)e);
                try {
                    Response response = this.sipSubscriptionHandler.sbb.getMessageFactory().createResponse(500, serverTransaction.getRequest());
                    response = this.sipSubscriptionHandler.addContactHeader(response);
                    serverTransaction.sendResponse(response);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Response sent:\n" + response.toString()));
                    }
                }
                catch (Exception f) {
                    logger.error((Object)"Can't send RESPONSE", (Throwable)f);
                }
                return;
            }
        }
        Subscription.Status initialStatus = responseCode == 202 ? Subscription.Status.pending : Subscription.Status.active;
        Subscription subscription = new Subscription(key, subscriber, notifier, initialStatus, subscriberDisplayName, expires);
        try {
            this.sipSubscriptionHandler.getSipSubscriberNotificationHandler().createAndSendNotify(entityManager, subscription, dialog, childSbb);
        }
        catch (Exception e) {
            logger.error((Object)"failed to notify subscriber", (Throwable)e);
        }
        this.sipSubscriptionHandler.sbb.getWInfoSubscriptionHandler().notifyWinfoSubscriptions(entityManager, subscription, childSbb);
        try {
            this.sipSubscriptionHandler.sbb.getActivityContextNamingfacility().bind(dialogAci, key.toString());
        }
        catch (Exception e) {
            logger.error((Object)"failed to bind a name to dialog's aci", (Throwable)e);
        }
        this.sipSubscriptionHandler.sbb.setSubscriptionTimerAndPersistSubscription(entityManager, subscription, expires + 1, dialogAci);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Created " + subscription));
        }
    }
}

