/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.sip;

import javax.persistence.EntityManager;
import javax.sip.Dialog;
import javax.sip.ResponseEvent;
import javax.sip.header.EventHeader;
import javax.slee.ActivityContextInterface;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;

public class RemoveSipSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private SipSubscriptionHandler sipSubscriptionHandler;

    public RemoveSipSubscriptionHandler(SipSubscriptionHandler sipSubscriptionHandler) {
        this.sipSubscriptionHandler = sipSubscriptionHandler;
    }

    public void removeSipSubscription(ActivityContextInterface aci, Subscription subscription, EntityManager entityManager, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        this.sipSubscriptionHandler.sbb.getTimerFacility().cancelTimer(subscription.getTimerID());
        subscription.setStatus(Subscription.Status.terminated);
        subscription.setLastEvent(null);
        Dialog dialog = (Dialog)aci.getActivity();
        try {
            this.sipSubscriptionHandler.getSipSubscriberNotificationHandler().createAndSendNotify(entityManager, subscription, dialog, childSbb);
        }
        catch (Exception e) {
            logger.error((Object)"failed to notify subscriber", (Throwable)e);
        }
        this.sipSubscriptionHandler.sbb.getWInfoSubscriptionHandler().notifyWinfoSubscriptions(entityManager, subscription, childSbb);
        if (subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Status changed for " + subscription));
            }
            this.sipSubscriptionHandler.sbb.removeSubscriptionData(entityManager, subscription, dialog, aci, childSbb);
        } else if (subscription.getStatus().equals((Object)Subscription.Status.waiting)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Status changed for " + subscription));
            }
            int defaultWaitingExpires = this.sipSubscriptionHandler.sbb.getConfiguration().getDefaultWaitingExpires();
            subscription.refresh(defaultWaitingExpires);
            this.sipSubscriptionHandler.sbb.setSubscriptionTimerAndPersistSubscription(entityManager, subscription, defaultWaitingExpires + 1, aci);
        }
    }

    public void removeSipSubscriptionOnNotifyError(ResponseEvent event) {
        Subscription subscription;
        EntityManager entityManager = this.sipSubscriptionHandler.sbb.getEntityManager();
        EventHeader eventHeader = (EventHeader)event.getResponse().getHeader("Event");
        Dialog dialog = event.getDialog();
        if (eventHeader != null && dialog != null && (subscription = Subscription.getSubscription((EntityManager)entityManager, (String)dialog.getCallId().getCallId(), (String)dialog.getRemoteTag(), (String)eventHeader.getEventType(), (String)eventHeader.getEventId())) != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Removing " + subscription.getKey() + " data due to error on notify response."));
            }
            this.sipSubscriptionHandler.sbb.removeSubscriptionData(entityManager, subscription, dialog, this.sipSubscriptionHandler.sbb.getActivityContextNamingfacility().lookup(subscription.getKey().toString()), this.sipSubscriptionHandler.sbb.getImplementedControlChildSbb());
            entityManager.flush();
        }
        entityManager.close();
    }
}

