/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.sip;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import javax.persistence.EntityManager;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.SipException;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.Header;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;

public class SipSubscriberNotificationHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private SipSubscriptionHandler sipSubscriptionHandler;

    public SipSubscriberNotificationHandler(SipSubscriptionHandler sipSubscriptionHandler) {
        this.sipSubscriptionHandler = sipSubscriptionHandler;
    }

    public void notifySipSubscriber(Object content, ContentTypeHeader contentTypeHeader, Subscription subscription, EntityManager entityManager, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        try {
            ActivityContextInterface dialogACI = this.sipSubscriptionHandler.sbb.getActivityContextNamingfacility().lookup(subscription.getKey().toString());
            if (dialogACI != null) {
                Dialog dialog = (Dialog)dialogACI.getActivity();
                Request notify = this.createNotify(dialog, subscription);
                if (content != null) {
                    notify = this.setNotifyContent(subscription, notify, content, contentTypeHeader, childSbb);
                }
                dialog.sendRequest(this.sipSubscriptionHandler.sbb.getSipProvider().getNewClientTransaction(notify));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("NotifySubscribers: subscription " + subscription.getKey() + " sent request:\n" + notify.toString()));
                }
            } else {
                logger.warn((Object)("Unable to find dialog aci to notify subscription " + subscription.getKey() + ". Removing subscription data"));
                this.sipSubscriptionHandler.sbb.removeSubscriptionData(entityManager, subscription, null, null, childSbb);
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to notify subscriber", (Throwable)e);
        }
    }

    public Request setNotifyContent(Subscription subscription, Request notify, Object content, ContentTypeHeader contentTypeHeader, ImplementedSubscriptionControlSbbLocalObject childSbb) throws JAXBException, ParseException, IOException {
        Object filteredContent = childSbb.filterContentPerSubscriber(subscription.getSubscriber(), subscription.getNotifier(), subscription.getKey().getEventPackage(), content);
        StringWriter stringWriter = new StringWriter();
        childSbb.getMarshaller().marshal(filteredContent, (Writer)stringWriter);
        notify.setContent((Object)stringWriter.toString(), contentTypeHeader);
        stringWriter.close();
        return notify;
    }

    public void createAndSendNotify(EntityManager entityManager, Subscription subscription, Dialog dialog, ImplementedSubscriptionControlSbbLocalObject childSbb) throws TransactionDoesNotExistException, SipException, ParseException {
        Request notify = this.createNotify(dialog, subscription);
        if (subscription.getStatus().equals((Object)Subscription.Status.active)) {
            if (subscription.getKey().getEventPackage().endsWith(".winfo")) {
                subscription.incrementVersion();
                entityManager.persist((Object)subscription);
                entityManager.flush();
                notify.setContent((Object)this.sipSubscriptionHandler.sbb.getWInfoSubscriptionHandler().getFullWatcherInfoContent(entityManager, subscription), this.sipSubscriptionHandler.sbb.getWInfoSubscriptionHandler().getWatcherInfoContentHeader());
            } else {
                NotifyContent notifyContent = childSbb.getNotifyContent(subscription);
                if (notifyContent != null) {
                    try {
                        notify = this.setNotifyContent(subscription, notify, notifyContent.getContent(), notifyContent.getContentTypeHeader(), childSbb);
                    }
                    catch (Exception e) {
                        logger.error((Object)"failed to set notify content", (Throwable)e);
                    }
                }
            }
        }
        ClientTransaction clientTransaction = this.sipSubscriptionHandler.sbb.getSipProvider().getNewClientTransaction(notify);
        dialog.sendRequest(clientTransaction);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request sent:\n" + notify.toString()));
        }
    }

    public Request createNotify(Dialog dialog, Subscription subscription) {
        Request notify = null;
        try {
            notify = dialog.createRequest("NOTIFY");
            EventHeader eventHeader = this.sipSubscriptionHandler.sbb.getHeaderFactory().createEventHeader(subscription.getKey().getEventPackage());
            if (subscription.getKey().getRealEventId() != null) {
                eventHeader.setEventId(subscription.getKey().getRealEventId());
            }
            notify.setHeader((Header)eventHeader);
            notify.setHeader((Header)this.sipSubscriptionHandler.sbb.getHeaderFactory().createMaxForwardsHeader(this.sipSubscriptionHandler.sbb.getConfiguration().getMaxForwards()));
            SubscriptionStateHeader ssh = null;
            if (subscription.getStatus().equals((Object)Subscription.Status.active) || subscription.getStatus().equals((Object)Subscription.Status.pending)) {
                ssh = this.sipSubscriptionHandler.sbb.getHeaderFactory().createSubscriptionStateHeader(subscription.getStatus().toString());
                ssh.setExpires(subscription.getRemainingExpires());
            } else if (subscription.getStatus().equals((Object)Subscription.Status.waiting) || subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
                ssh = this.sipSubscriptionHandler.sbb.getHeaderFactory().createSubscriptionStateHeader("terminated");
                if (subscription.getLastEvent() != null) {
                    ssh.setReasonCode(subscription.getLastEvent().toString());
                }
            }
            notify.addHeader((Header)ssh);
        }
        catch (Exception e) {
            logger.error((Object)"unable to fill notify headers", (Throwable)e);
        }
        return notify;
    }
}

