/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription;

import java.text.ParseException;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sip.Dialog;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.address.AddressFactory;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.Address;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.internal.InternalNotifyEvent;
import org.mobicents.slee.sipevent.server.internal.InternalSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriptionControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.eventlist.MultiPart;
import org.mobicents.slee.sipevent.server.subscription.jmx.SubscriptionControlManagement;
import org.mobicents.slee.sipevent.server.subscription.jmx.SubscriptionControlManagementMBean;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.pojo.SubscriptionKey;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.winfo.WInfoSubscriptionHandler;

public abstract class SubscriptionControlSbb
implements Sbb,
SubscriptionControlSbbLocalObject {
    private static final Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private static final SubscriptionControlManagement configuration = new SubscriptionControlManagement();
    private SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory;
    private SleeSipProvider sipProvider;
    private AddressFactory addressFactory;
    private MessageFactory messageFactory;
    private HeaderFactory headerFactory;
    private TimerFacility timerFacility;
    private ActivityContextNamingFacility activityContextNamingfacility;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private NullActivityFactory nullActivityFactory;
    private SbbContext sbbContext;
    private static EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"sipevent-subscription-pu");

    public SipSubscriptionHandler getSipSubscribeHandler() {
        return new SipSubscriptionHandler(this);
    }

    public WInfoSubscriptionHandler getWInfoSubscriptionHandler() {
        return new WInfoSubscriptionHandler(this);
    }

    public InternalSubscriptionHandler getInternalSubscriptionHandler() {
        return new InternalSubscriptionHandler(this);
    }

    public ActivityContextNamingFacility getActivityContextNamingfacility() {
        return this.activityContextNamingfacility;
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    public HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public NullActivityContextInterfaceFactory getNullACIFactory() {
        return this.nullACIFactory;
    }

    public NullActivityFactory getNullActivityFactory() {
        return this.nullActivityFactory;
    }

    public SbbContext getSbbContext() {
        return this.sbbContext;
    }

    public SipActivityContextInterfaceFactory getSipActivityContextInterfaceFactory() {
        return this.sipActivityContextInterfaceFactory;
    }

    public SleeSipProvider getSipProvider() {
        return this.sipProvider;
    }

    public TimerFacility getTimerFacility() {
        return this.timerFacility;
    }

    public SubscriptionControlManagementMBean getConfiguration() {
        return configuration;
    }

    public EntityManager getEntityManager() {
        return entityManagerFactory.createEntityManager();
    }

    public void setParentSbb(SubscriptionClientControlParentSbbLocalObject parentSbb) {
        this.setParentSbbCMP(parentSbb);
    }

    public abstract SubscriptionClientControlParentSbbLocalObject getParentSbbCMP();

    public abstract void setParentSbbCMP(SubscriptionClientControlParentSbbLocalObject var1);

    public abstract ChildRelation getImplementedControlChildRelation();

    public abstract ImplementedSubscriptionControlSbbLocalObject getImplementedControlChildSbbCMP();

    public abstract void setImplementedControlChildSbbCMP(ImplementedSubscriptionControlSbbLocalObject var1);

    public ImplementedSubscriptionControlSbbLocalObject getImplementedControlChildSbb() {
        ImplementedSubscriptionControlSbbLocalObject childSbb = this.getImplementedControlChildSbbCMP();
        if (childSbb == null) {
            try {
                childSbb = (ImplementedSubscriptionControlSbbLocalObject)this.getImplementedControlChildRelation().create();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create child sbb", (Throwable)e);
                return null;
            }
            this.setImplementedControlChildSbbCMP(childSbb);
            childSbb.setParentSbb((ImplementedSubscriptionControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        return childSbb;
    }

    public abstract ChildRelation getEventListControlChildRelation();

    public abstract EventListSubscriptionControlSbbLocalObject getEventListControlChildSbbCMP();

    public abstract void setEventListControlChildSbbCMP(EventListSubscriptionControlSbbLocalObject var1);

    public EventListSubscriptionControlSbbLocalObject getEventListControlChildSbb() {
        EventListSubscriptionControlSbbLocalObject childSbb = this.getEventListControlChildSbbCMP();
        if (childSbb == null) {
            try {
                childSbb = (EventListSubscriptionControlSbbLocalObject)this.getEventListControlChildRelation().create();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create child sbb", (Throwable)e);
                return null;
            }
            this.setEventListControlChildSbbCMP(childSbb);
            childSbb.setParentSbb((EventListSubscriptionControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        return childSbb;
    }

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        try {
            ServiceActivity sa = ((ServiceActivityFactory)new InitialContext().lookup("java:comp/env/slee/serviceactivity/factory")).getActivity();
            if (!sa.equals(aci.getActivity())) {
                aci.detach(this.sbbContext.getSbbLocalObject());
            } else {
                configuration.startService();
                this.getEventListControlChildSbb().initRLSCache();
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to process service started event", (Throwable)e);
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        Object activity = aci.getActivity();
        if (activity instanceof ServiceActivity) {
            entityManagerFactory.close();
            configuration.stopService();
        }
    }

    public void onSubscribeOutOfDialog(RequestEvent event, ActivityContextInterface aci) {
        new SipSubscriptionHandler(this).processRequest(event, aci);
    }

    public void onSubscribeInDialog(RequestEvent event, ActivityContextInterface aci) {
        new SipSubscriptionHandler(this).processRequest(event, aci);
    }

    public void onResponseClientErrorEvent(ResponseEvent event, ActivityContextInterface aci) {
        new SipSubscriptionHandler(this).getRemoveSipSubscriptionHandler().removeSipSubscriptionOnNotifyError(event);
    }

    public void onResponseServerErrorEvent(ResponseEvent event, ActivityContextInterface aci) {
        new SipSubscriptionHandler(this).getRemoveSipSubscriptionHandler().removeSipSubscriptionOnNotifyError(event);
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        Object activity = aci.getActivity();
        Dialog dialog = null;
        if (activity instanceof Dialog) {
            dialog = (Dialog)activity;
        }
        EntityManager entityManager = this.getEntityManager();
        for (Object object : entityManager.createNamedQuery("selectSubscriptionFromTimerID").setParameter("timerID", (Object)event.getTimerID()).getResultList()) {
            Subscription subscription = (Subscription)object;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Timer expired for " + subscription));
            }
            ImplementedSubscriptionControlSbbLocalObject childSbb = this.getImplementedControlChildSbb();
            if (subscription.getStatus().equals((Object)Subscription.Status.waiting)) {
                subscription.changeStatus(Subscription.Event.giveup);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Status changed for " + subscription));
                }
                this.getWInfoSubscriptionHandler().notifyWinfoSubscriptions(entityManager, subscription, childSbb);
                this.removeSubscriptionData(entityManager, subscription, dialog, aci, childSbb);
            } else {
                subscription.changeStatus(Subscription.Event.timeout);
                if (subscription.getResourceList().booleanValue()) {
                    this.getEventListControlChildSbb().removeSubscription(subscription);
                }
                if (dialog != null) {
                    new SipSubscriptionHandler(this).getRemoveSipSubscriptionHandler().removeSipSubscription(aci, subscription, entityManager, childSbb);
                } else {
                    new InternalSubscriptionHandler(this).getRemoveInternalSubscriptionHandler().removeInternalSubscription(aci, subscription, entityManager, childSbb);
                }
            }
            entityManager.flush();
        }
        entityManager.close();
    }

    public void onInternalNotifyEvent(InternalNotifyEvent event, ActivityContextInterface aci) {
        this.getParentSbbCMP().notifyEvent(event.getSubscriber(), event.getNotifier(), event.getEventPackage(), event.getSubscriptionId(), event.getTerminationReason(), event.getSubscriptionStatus(), event.getContent(), event.getContentType(), event.getContentSubtype());
        if (event.getSubscriptionStatus().equals((Object)Subscription.Status.terminated)) {
            ((NullActivity)aci.getActivity()).endActivity();
            aci.detach(this.getSbbContext().getSbbLocalObject());
        }
    }

    public void newSubscriptionAuthorization(String subscriber, String subscriberDisplayName, String notifier, SubscriptionKey key, int expires, int responseCode, boolean eventList, ServerTransaction serverTransaction) {
        EntityManager entityManager = this.getEntityManager();
        try {
            if (!key.isInternalSubscription()) {
                ActivityContextInterface serverTransactionACI = null;
                for (ActivityContextInterface aci : this.getSbbContext().getActivities()) {
                    Object activity = aci.getActivity();
                    if (!(activity instanceof ServerTransaction)) continue;
                    serverTransactionACI = aci;
                    break;
                }
                new SipSubscriptionHandler(this).getNewSipSubscriptionHandler().newSipSubscriptionAuthorization(serverTransaction, serverTransactionACI, subscriber, subscriberDisplayName, notifier, key, expires, responseCode, eventList, entityManager, this.getImplementedControlChildSbb());
            } else {
                new InternalSubscriptionHandler(this).getNewInternalSubscriptionHandler().newInternalSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, responseCode, eventList, entityManager, this.getImplementedControlChildSbb());
            }
            entityManager.flush();
        }
        catch (Exception e) {
            logger.error((Object)"Error processing new subscription authorization", (Throwable)e);
            if (!key.isInternalSubscription()) {
                if (serverTransaction != null) {
                    try {
                        Response response = new SipSubscriptionHandler(this).addContactHeader(this.messageFactory.createResponse(500, serverTransaction.getRequest()));
                        serverTransaction.sendResponse(response);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Response sent:\n" + response.toString()));
                        }
                    }
                    catch (Exception f) {
                        logger.error((Object)"Can't send RESPONSE", (Throwable)f);
                    }
                }
            } else {
                this.getParentSbbCMP().subscribeError(subscriber, notifier, key.getEventPackage(), key.getRealEventId(), 500);
            }
            return;
        }
        entityManager.close();
    }

    public void notifySubscribers(String notifier, String eventPackage, Object content, ContentTypeHeader contentTypeHeader) {
        ImplementedSubscriptionControlSbbLocalObject childSbb = this.getImplementedControlChildSbb();
        EntityManager entityManager = this.getEntityManager();
        for (Object object : entityManager.createNamedQuery("selectSubscriptionsFromNotifierAndEventPackage").setParameter("notifier", (Object)notifier).setParameter("eventPackage", (Object)eventPackage).getResultList()) {
            Subscription subscription = (Subscription)object;
            if (!subscription.getStatus().equals((Object)Subscription.Status.active)) continue;
            if (subscription.getKey().isInternalSubscription()) {
                new InternalSubscriptionHandler(this).getInternalSubscriberNotificationHandler().notifyInternalSubscriber(entityManager, subscription, content, contentTypeHeader, childSbb);
                continue;
            }
            new SipSubscriptionHandler(this).getSipSubscriberNotificationHandler().notifySipSubscriber(content, contentTypeHeader, subscription, entityManager, childSbb);
        }
        entityManager.close();
    }

    public void notifySubscriber(SubscriptionKey key, Object content, ContentTypeHeader contentTypeHeader) {
        ImplementedSubscriptionControlSbbLocalObject childSbb = this.getImplementedControlChildSbb();
        EntityManager entityManager = this.getEntityManager();
        Subscription subscription = (Subscription)entityManager.find(Subscription.class, (Object)key);
        if (subscription != null && subscription.getStatus().equals((Object)Subscription.Status.active)) {
            if (subscription.getKey().isInternalSubscription()) {
                new InternalSubscriptionHandler(this).getInternalSubscriberNotificationHandler().notifyInternalSubscriber(entityManager, subscription, content, contentTypeHeader, childSbb);
            } else {
                new SipSubscriptionHandler(this).getSipSubscriberNotificationHandler().notifySipSubscriber(content, contentTypeHeader, subscription, entityManager, childSbb);
            }
        }
        entityManager.close();
    }

    public void authorizationChanged(String subscriber, String notifier, String eventPackage, String eventId, int authorizationCode) {
        Subscription subscription;
        EntityManager entityManager = this.getEntityManager();
        Dialog dialog = null;
        ActivityContextInterface subscriptionAci = null;
        for (ActivityContextInterface aci : this.sbbContext.getActivities()) {
            Object activity = aci.getActivity();
            if (activity instanceof Dialog) {
                subscriptionAci = aci;
                dialog = (Dialog)activity;
                break;
            }
            if (!(activity instanceof NullActivity)) continue;
            subscriptionAci = aci;
            break;
        }
        String callId = " ";
        String remoteTag = " ";
        if (dialog != null) {
            callId = dialog.getCallId().getCallId();
            remoteTag = dialog.getRemoteTag();
        }
        if ((subscription = (Subscription)entityManager.find(Subscription.class, (Object)new SubscriptionKey(callId, remoteTag, eventPackage, eventId))) != null) {
            Subscription.Status oldStatus = subscription.getStatus();
            switch (authorizationCode) {
                case 403: {
                    subscription.changeStatus(Subscription.Event.rejected);
                    break;
                }
                case 202: {
                    if (!subscription.getStatus().equals((Object)Subscription.Status.active)) break;
                    subscription.setStatus(Subscription.Status.pending);
                    subscription.setLastEvent(null);
                    break;
                }
                case 200: {
                    subscription.changeStatus(Subscription.Event.approved);
                    break;
                }
                default: {
                    logger.warn((Object)("Received authorization update with unknown auth code " + authorizationCode));
                    return;
                }
            }
            if (!oldStatus.equals((Object)subscription.getStatus())) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Status changed for " + subscription));
                }
                ImplementedSubscriptionControlSbbLocalObject childSbb = this.getImplementedControlChildSbb();
                if (subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
                    if (subscription.getResourceList().booleanValue()) {
                        this.getEventListControlChildSbb().removeSubscription(subscription);
                    }
                    if (dialog == null) {
                        new InternalSubscriptionHandler(this).getRemoveInternalSubscriptionHandler().removeInternalSubscription(subscriptionAci, subscription, entityManager, childSbb);
                    } else {
                        new SipSubscriptionHandler(this).getRemoveSipSubscriptionHandler().removeSipSubscription(subscriptionAci, subscription, entityManager, childSbb);
                    }
                } else {
                    boolean notifySubscriber = true;
                    if (subscription.getResourceList().booleanValue() && subscription.getStatus().equals((Object)Subscription.Status.active)) {
                        notifySubscriber = false;
                        if (!this.getEventListControlChildSbb().createSubscription(subscription)) {
                            if (dialog == null) {
                                new InternalSubscriptionHandler(this).getRemoveInternalSubscriptionHandler().removeInternalSubscription(subscriptionAci, subscription, entityManager, childSbb);
                            } else {
                                new SipSubscriptionHandler(this).getRemoveSipSubscriptionHandler().removeSipSubscription(subscriptionAci, subscription, entityManager, childSbb);
                            }
                        }
                    }
                    if (notifySubscriber) {
                        if (dialog == null) {
                            new InternalSubscriptionHandler(this).getInternalSubscriberNotificationHandler().notifyInternalSubscriber(entityManager, subscription, subscriptionAci, childSbb);
                        } else {
                            try {
                                new SipSubscriptionHandler(this).getSipSubscriberNotificationHandler().createAndSendNotify(entityManager, subscription, dialog, childSbb);
                            }
                            catch (Exception e) {
                                logger.error((Object)"failed to notify subscriber", (Throwable)e);
                            }
                        }
                    }
                    new WInfoSubscriptionHandler(this).notifyWinfoSubscriptions(entityManager, subscription, childSbb);
                    if (subscription.getStatus().equals((Object)Subscription.Status.waiting)) {
                        int defaultWaitingExpires = this.getConfiguration().getDefaultWaitingExpires();
                        subscription.refresh(defaultWaitingExpires);
                        this.setSubscriptionTimerAndPersistSubscription(entityManager, subscription, defaultWaitingExpires + 1, subscriptionAci);
                    }
                }
            }
        }
        entityManager.flush();
        entityManager.close();
    }

    public void notifyEventListSubscriber(SubscriptionKey key, MultiPart multiPart) {
        try {
            ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("multipart", "related");
            contentTypeHeader.setParameter("type", multiPart.getType());
            contentTypeHeader.setParameter("boundary", multiPart.getBoundary());
            this.notifySubscriber(key, multiPart.toString(), contentTypeHeader);
        }
        catch (ParseException e) {
            logger.error((Object)"failed to create content type header for event list notification", (Throwable)e);
        }
    }

    public Subscription getSubscription(SubscriptionKey key) {
        EntityManager entityManager = this.getEntityManager();
        Subscription subscription = (Subscription)entityManager.find(Subscription.class, (Object)key);
        if (subscription != null) {
            subscription.setEntityManager(entityManager);
        }
        return subscription;
    }

    public void newRlsService(String uri) {
        if (configuration.getEventListSupportOn()) {
            EntityManager entityManager = this.getEntityManager();
            for (Object object : entityManager.createNamedQuery("selectSubscriptionsFromNotifier").setParameter("notifier", (Object)uri).getResultList()) {
                Subscription subscription = (Subscription)object;
                if (subscription.getResourceList().booleanValue()) continue;
                subscription.changeStatus(Subscription.Event.deactivated);
                try {
                    ActivityContextInterface aci = this.getActivityContextNamingfacility().lookup(subscription.getKey().toString());
                    if (aci == null) continue;
                    if (subscription.getKey().isInternalSubscription()) {
                        new InternalSubscriptionHandler(this).getRemoveInternalSubscriptionHandler().removeInternalSubscription(aci, subscription, entityManager, this.getImplementedControlChildSbb());
                        continue;
                    }
                    new SipSubscriptionHandler(this).getRemoveSipSubscriptionHandler().removeSipSubscription(aci, subscription, entityManager, this.getImplementedControlChildSbb());
                }
                catch (Exception e) {
                    logger.error((Object)"failed to notify internal subscriber", (Throwable)e);
                }
            }
            entityManager.close();
        }
    }

    private void subscribe(String subscriber, String subscriberDisplayName, String notifier, String eventPackage, String subscriptionId, int expires, String content, String contentType, String contentSubtype, boolean eventList) {
        EntityManager entityManager = this.getEntityManager();
        this.getInternalSubscriptionHandler().getNewInternalSubscriptionHandler().newInternalSubscription(subscriber, subscriberDisplayName, notifier, eventPackage, subscriptionId, expires, content, contentType, contentSubtype, eventList, entityManager, this.getImplementedControlChildSbb());
        entityManager.flush();
        entityManager.close();
    }

    public void subscribe(String subscriber, String subscriberDisplayName, String notifier, String eventPackage, String subscriptionId, int expires, String content, String contentType, String contentSubtype) {
        if (this.getConfiguration().getEventListSupportOn()) {
            int rlsResponse = this.getEventListControlChildSbb().validateSubscribeRequest(subscriber, notifier, eventPackage, null);
            switch (rlsResponse) {
                case 404: {
                    this.subscribe(subscriber, subscriberDisplayName, notifier, eventPackage, subscriptionId, expires, content, contentType, contentSubtype, false);
                    break;
                }
                case 200: {
                    this.subscribe(subscriber, subscriberDisplayName, notifier, eventPackage, subscriptionId, expires, content, contentType, contentSubtype, true);
                    break;
                }
                default: {
                    this.getParentSbbCMP().subscribeError(subscriber, notifier, eventPackage, subscriptionId, rlsResponse);
                    break;
                }
            }
        } else {
            this.subscribe(subscriber, subscriberDisplayName, notifier, eventPackage, subscriptionId, expires, content, contentType, contentSubtype, false);
        }
    }

    public void resubscribe(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires) {
        EntityManager entityManager = this.getEntityManager();
        this.getInternalSubscriptionHandler().getRefreshInternalSubscriptionHandler().refreshInternalSubscription(subscriber, notifier, eventPackage, subscriptionId, expires, entityManager, this.getImplementedControlChildSbb());
        entityManager.flush();
        entityManager.close();
    }

    public void unsubscribe(String subscriber, String notifier, String eventPackage, String subscriptionId) {
        EntityManager entityManager = this.getEntityManager();
        this.getInternalSubscriptionHandler().getRemoveInternalSubscriptionHandler().removeInternalSubscription(subscriber, notifier, eventPackage, subscriptionId, entityManager, this.getImplementedControlChildSbb());
        entityManager.flush();
        entityManager.close();
    }

    public void setSubscriptionTimerAndPersistSubscription(EntityManager entityManager, Subscription subscription, long delay, ActivityContextInterface aci) {
        TimerOptions options = new TimerOptions();
        options.setPersistent(true);
        options.setPreserveMissed(TimerPreserveMissed.ALL);
        TimerID timerId = this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + delay * 1000L, 1L, 1, options);
        subscription.setTimerID(timerId);
        entityManager.persist((Object)subscription);
    }

    public void removeSubscriptionData(EntityManager entityManager, Subscription subscription, Dialog dialog, ActivityContextInterface aci, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        List subscriptionsInDialog;
        childSbb.removingSubscription(subscription);
        entityManager.remove((Object)subscription);
        try {
            this.getActivityContextNamingfacility().unbind(subscription.getKey().toString());
        }
        catch (Exception e) {
            logger.error((Object)"failed to unbind subscription aci name");
        }
        if (dialog != null && (subscriptionsInDialog = Subscription.getDialogSubscriptions((EntityManager)entityManager, (String)dialog.getCallId().getCallId(), (String)dialog.getRemoteTag())).size() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"No more subscriptions on dialog, deleting...");
            }
            aci.detach(this.getSbbContext().getSbbLocalObject());
            dialog.delete();
        }
        entityManager.flush();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Removed data for " + subscription));
        }
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        try {
            Context context = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)context.lookup("slee/facilities/timer");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)context.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)context.lookup("slee/nullactivity/factory");
            this.sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory)context.lookup("slee/resources/jainsip/1.2/acifactory");
            this.sipProvider = (SleeSipProvider)context.lookup("slee/resources/jainsip/1.2/provider");
            this.addressFactory = this.sipProvider.getAddressFactory();
            this.headerFactory = this.sipProvider.getHeaderFactory();
            this.messageFactory = this.sipProvider.getMessageFactory();
            this.activityContextNamingfacility = (ActivityContextNamingFacility)context.lookup("slee/facilities/activitycontextnaming");
        }
        catch (Exception e) {
            logger.error((Object)"Unable to retrieve factories, facilities & providers", (Throwable)e);
        }
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public abstract void fireInternalNotifyEvent(InternalNotifyEvent var1, ActivityContextInterface var2, Address var3);
}

