/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.eventlist;

import java.io.Reader;
import java.io.StringReader;
import java.util.ListIterator;
import java.util.Map;
import javax.sip.RequestEvent;
import javax.sip.header.AcceptHeader;
import javax.sip.header.SupportedHeader;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriberParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriberSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriptionControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.FlatListMakerParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.FlatListMakerSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.eventlist.FlatList;
import org.mobicents.slee.sipevent.server.subscription.eventlist.MultiPart;
import org.mobicents.slee.sipevent.server.subscription.eventlist.RlsServicesCache;
import org.mobicents.slee.sipevent.server.subscription.eventlist.ServiceTypePackageVerifier;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.pojo.SubscriptionKey;
import org.mobicents.slee.xdm.server.XDMClientControlParentSbbLocalObject;
import org.mobicents.slee.xdm.server.XDMClientControlSbbLocalObject;
import org.openxdm.xcap.client.appusage.rlsservices.jaxb.RlsServices;
import org.openxdm.xcap.client.appusage.rlsservices.jaxb.ServiceType;
import org.openxdm.xcap.common.key.GlobalDocumentUriKey;
import org.openxdm.xcap.common.key.XcapUriKey;
import org.openxdm.xcap.common.uri.AttributeSelector;
import org.openxdm.xcap.common.uri.DocumentSelector;
import org.openxdm.xcap.common.uri.NodeSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventListSubscriptionControlSbb
implements Sbb,
EventListSubscriptionControlSbbLocalObject {
    private static final Logger logger = Logger.getLogger(EventListSubscriptionControlSbb.class);
    private static final RlsServicesCache rlsServicesCache = new RlsServicesCache();
    private static final GlobalDocumentUriKey globalRLSDocumentKey = new GlobalDocumentUriKey("rls-services", "index");
    private static final ServiceTypePackageVerifier serviceTypePackageVerifier = new ServiceTypePackageVerifier();
    private static final JAXBContext context = EventListSubscriptionControlSbb.initJAXBContext();
    private SbbContext sbbContext;

    public abstract void setParentSbbCMP(EventListSubscriptionControlParentSbbLocalObject var1);

    public abstract EventListSubscriptionControlParentSbbLocalObject getParentSbbCMP();

    public void setParentSbb(EventListSubscriptionControlParentSbbLocalObject sbbLocalObject) {
        this.setParentSbbCMP(sbbLocalObject);
    }

    public void initRLSCache() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Mobicents Resource List Server: starting cache of XDM's global rls-services document.");
        }
        XDMClientControlSbbLocalObject xdm = this.getXDMClientControlSbb();
        xdm.get((XcapUriKey)globalRLSDocumentKey);
        xdm.subscribeDocument(globalRLSDocumentKey.getDocumentSelector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache(String document) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Mobicents Resource List Server: updating cache...");
        }
        rlsServicesCache.clear();
        StringReader stringReader = new StringReader(document);
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object obj = unmarshaller.unmarshal((Reader)stringReader);
            if (obj instanceof RlsServices) {
                for (ServiceType serviceType : ((RlsServices)obj).getService()) {
                    this.getFlatListMakerSbb().makeFlatList(serviceType);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to unmarshall rls services content", (Throwable)e);
        }
        finally {
            stringReader.close();
        }
    }

    public void flatListMade(FlatList flatList) {
        rlsServicesCache.putFlatList(flatList);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Mobicents Resource List Server: updated cache with " + flatList));
        }
        this.getParentSbbCMP().newRlsService(flatList.getServiceType().getUri());
    }

    public void getResponse(XcapUriKey key, int responseCode, String mimetype, String content, String tag) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got " + responseCode + " response for retreival of global rls services document."));
        }
        if (responseCode == 200) {
            this.updateCache(content);
        }
    }

    public void documentUpdated(DocumentSelector documentSelector, String oldETag, String newETag, String documentAsString) {
        if (documentSelector.equals((Object)globalRLSDocumentKey.getDocumentSelector())) {
            this.updateCache(documentAsString);
        }
    }

    public void attributeUpdated(DocumentSelector documentSelector, NodeSelector nodeSelector, AttributeSelector attributeSelector, Map<String, String> namespaces, String oldETag, String newETag, String documentAsString, String attributeValue) {
        this.documentUpdated(documentSelector, oldETag, newETag, documentAsString);
    }

    public void elementUpdated(DocumentSelector documentSelector, NodeSelector nodeSelector, Map<String, String> namespaces, String oldETag, String newETag, String documentAsString, String elementAsString) {
        this.documentUpdated(documentSelector, oldETag, newETag, documentAsString);
    }

    public int validateSubscribeRequest(String subscriber, String notifier, String eventPackage, RequestEvent event) {
        FlatList flatList = rlsServicesCache.getFlatList(notifier);
        if (flatList != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(notifier + " is a resource list."));
            }
            if (event != null) {
                boolean isEventListSupported = false;
                ListIterator lit = event.getRequest().getHeaders("Supported");
                while (lit.hasNext()) {
                    SupportedHeader sh = (SupportedHeader)lit.next();
                    if (!sh.getOptionTag().equals("eventlist")) continue;
                    isEventListSupported = true;
                    break;
                }
                if (!isEventListSupported) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"SIP subscription request for resource list doesn't included Supported: eventlist header");
                    }
                    return 421;
                }
                boolean isMultipartAccepted = false;
                boolean isRlmiAccepted = false;
                ListIterator lit2 = event.getRequest().getHeaders("Accept");
                while (lit2.hasNext()) {
                    AcceptHeader ah = (AcceptHeader)lit2.next();
                    if (ah.allowsAllContentTypes() && ah.allowsAllContentSubTypes()) {
                        isMultipartAccepted = true;
                        isRlmiAccepted = true;
                        break;
                    }
                    if (!isMultipartAccepted && ah.getContentSubType().equals("related") && ah.getContentType().equals("multipart")) {
                        isMultipartAccepted = true;
                    }
                    if (isRlmiAccepted || !ah.getContentSubType().equals("rlmi+xml") || !ah.getContentType().equals("application")) continue;
                    isRlmiAccepted = true;
                }
                if (!isMultipartAccepted || !isRlmiAccepted) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"SIP subscription request for resource list doesn't included proper Accept headers");
                    }
                    return 406;
                }
            }
            if (!serviceTypePackageVerifier.hasPackage(flatList.getServiceType(), eventPackage)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Resource list " + notifier + " doesn't applies to event package " + eventPackage));
                }
                return 489;
            }
            if (flatList.getEntries().isEmpty() && flatList.getStatus() != 200) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Resource list " + notifier + " can't be subscribed due to failure in making flat list"));
                }
                return flatList.getStatus();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resource list " + notifier + " subscription request validated with sucess."));
            }
            return 200;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(notifier + " is not a resource list."));
        }
        return 404;
    }

    public boolean createSubscription(Subscription subscription) {
        FlatList flatList = rlsServicesCache.getFlatList(subscription.getNotifier());
        if (flatList == null) {
            return false;
        }
        EventListSubscriberSbbLocalObject subscriptionChildSbb = null;
        try {
            subscriptionChildSbb = (EventListSubscriberSbbLocalObject)this.getEventListSubscriberChildRelation().create();
            subscriptionChildSbb.setParentSbb((EventListSubscriberParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create child sbb", (Throwable)e);
            return false;
        }
        subscriptionChildSbb.subscribe(subscription, flatList);
        return true;
    }

    public void refreshSubscription(Subscription subscription) {
        EventListSubscriberSbbLocalObject childSbb = this.getEventListSubscriberSbb(subscription.getKey());
        if (childSbb != null) {
            childSbb.resubscribe(subscription);
        } else {
            logger.warn((Object)"trying to refresh a event list subscription but child sbb not found");
        }
    }

    public void removeSubscription(Subscription subscription) {
        EventListSubscriberSbbLocalObject childSbb = this.getEventListSubscriberSbb(subscription.getKey());
        if (childSbb != null) {
            childSbb.unsubscribe(subscription);
        } else {
            logger.warn((Object)"trying to unsubscribe a event list subscription but child sbb not found");
        }
    }

    public void notifyEventListSubscriber(SubscriptionKey key, MultiPart multiPart) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("notifying event list subscription " + key));
        }
        this.getParentSbbCMP().notifyEventListSubscriber(key, multiPart);
    }

    public Subscription getSubscription(SubscriptionKey key) {
        return this.getParentSbbCMP().getSubscription(key);
    }

    public abstract ChildRelation getFlatListMakerChildRelation();

    public abstract FlatListMakerSbbLocalObject getFlatListMakerChildSbbCMP();

    public abstract void setFlatListMakerChildSbbCMP(FlatListMakerSbbLocalObject var1);

    public FlatListMakerSbbLocalObject getFlatListMakerSbb() {
        FlatListMakerSbbLocalObject childSbb = this.getFlatListMakerChildSbbCMP();
        if (childSbb == null) {
            try {
                childSbb = (FlatListMakerSbbLocalObject)this.getFlatListMakerChildRelation().create();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create child sbb", (Throwable)e);
                return null;
            }
            this.setFlatListMakerChildSbbCMP(childSbb);
            childSbb.setParentSbb((FlatListMakerParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        return childSbb;
    }

    public abstract ChildRelation getEventListSubscriberChildRelation();

    public EventListSubscriberSbbLocalObject getEventListSubscriberSbb(SubscriptionKey subscriptionKey) {
        ChildRelation childRelation = this.getEventListSubscriberChildRelation();
        EventListSubscriberSbbLocalObject subscriptionChildSbb = null;
        for (EventListSubscriberSbbLocalObject childSbb : childRelation) {
            SubscriptionKey childSbbSubscriptionKey = childSbb.getSubscriptionKey();
            if (childSbbSubscriptionKey == null || !childSbbSubscriptionKey.equals((Object)subscriptionKey)) continue;
            subscriptionChildSbb = childSbb;
            break;
        }
        return subscriptionChildSbb;
    }

    public abstract ChildRelation getXDMClientControlChildRelation();

    public abstract XDMClientControlSbbLocalObject getXDMClientControlChildSbbCMP();

    public abstract void setXDMClientControlChildSbbCMP(XDMClientControlSbbLocalObject var1);

    public XDMClientControlSbbLocalObject getXDMClientControlSbb() {
        XDMClientControlSbbLocalObject childSbb = this.getXDMClientControlChildSbbCMP();
        if (childSbb == null) {
            try {
                childSbb = (XDMClientControlSbbLocalObject)this.getXDMClientControlChildRelation().create();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create child sbb", (Throwable)e);
                return null;
            }
            this.setXDMClientControlChildSbbCMP(childSbb);
            childSbb.setParentSbb((XDMClientControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        return childSbb;
    }

    private static JAXBContext initJAXBContext() {
        try {
            return JAXBContext.newInstance((String)"org.openxdm.xcap.client.appusage.rlsservices.jaxb");
        }
        catch (JAXBException e) {
            logger.error((Object)"failed to create jaxb context for rls services", (Throwable)e);
            return null;
        }
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }
}

