/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import javax.persistence.EntityManager;
import javax.sip.header.ContentTypeHeader;
import javax.slee.ActivityContextInterface;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.internal.InternalNotifyEvent;
import org.mobicents.slee.sipevent.server.internal.InternalSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;

public class InternalSubscriberNotificationHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private InternalSubscriptionHandler internalSubscriptionHandler;

    public InternalSubscriberNotificationHandler(InternalSubscriptionHandler sbb) {
        this.internalSubscriptionHandler = sbb;
    }

    public void notifyInternalSubscriber(EntityManager entityManager, Subscription subscription, ActivityContextInterface aci, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        NotifyContent notifyContent = null;
        if (subscription.getStatus().equals((Object)Subscription.Status.active)) {
            notifyContent = childSbb.getNotifyContent(subscription);
        }
        if (notifyContent != null) {
            this.notifyInternalSubscriber(entityManager, subscription, notifyContent.getContent(), notifyContent.getContentTypeHeader(), childSbb);
        } else {
            this.notifyInternalSubscriber(entityManager, subscription, null, null, childSbb);
        }
    }

    public void notifyInternalSubscriber(EntityManager entityManager, Subscription subscription, String content, ContentTypeHeader contentTypeHeader, ActivityContextInterface subscriptionACI) {
        Subscription.Status status;
        String contentType = null;
        String contentSubtype = null;
        if (contentTypeHeader != null) {
            contentType = contentTypeHeader.getContentType();
            contentSubtype = contentTypeHeader.getContentSubType();
        }
        if ((status = subscription.getStatus()).equals((Object)Subscription.Status.waiting)) {
            status = Subscription.Status.terminated;
        }
        Subscription.Event lastEvent = null;
        if (status.equals((Object)Subscription.Status.terminated)) {
            lastEvent = subscription.getLastEvent();
        }
        InternalNotifyEvent internalNotifyEvent = new InternalNotifyEvent(subscription.getSubscriber(), subscription.getNotifier(), subscription.getKey().getEventPackage(), subscription.getKey().getRealEventId(), lastEvent, status, content, contentType, contentSubtype);
        this.internalSubscriptionHandler.sbb.fireInternalNotifyEvent(internalNotifyEvent, subscriptionACI, null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notifying Internal Subscriber:" + internalNotifyEvent.toString()));
        }
    }

    public void notifyInternalSubscriber(EntityManager entityManager, Subscription subscription, Object content, ContentTypeHeader contentTypeHeader, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        try {
            ActivityContextInterface aci = this.internalSubscriptionHandler.sbb.getActivityContextNamingfacility().lookup(subscription.getKey().toString());
            if (aci != null) {
                if (!subscription.getResourceList().booleanValue()) {
                    this.notifyInternalSubscriber(entityManager, subscription, content != null ? this.getFilteredNotifyContent(subscription, content, childSbb) : null, contentTypeHeader, aci);
                } else {
                    this.notifyInternalSubscriber(entityManager, subscription, content != null ? (String)content : null, contentTypeHeader, aci);
                }
            } else {
                logger.warn((Object)("Unable to find subscription aci to notify " + subscription.getKey() + ". Removing subscription data"));
                this.internalSubscriptionHandler.sbb.removeSubscriptionData(entityManager, subscription, null, null, childSbb);
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to notify internal subscriber", (Throwable)e);
        }
    }

    private String getFilteredNotifyContent(Subscription subscription, Object content, ImplementedSubscriptionControlSbbLocalObject childSbb) throws JAXBException, ParseException, IOException {
        Object filteredContent = childSbb.filterContentPerSubscriber(subscription.getSubscriber(), subscription.getNotifier(), subscription.getKey().getEventPackage(), content);
        StringWriter stringWriter = new StringWriter();
        childSbb.getMarshaller().marshal(filteredContent, (Writer)stringWriter);
        String result = stringWriter.toString();
        stringWriter.close();
        return result;
    }
}

