/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.internal;

import javax.persistence.EntityManager;
import javax.slee.ActivityContextInterface;
import javax.slee.nullactivity.NullActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.internal.InternalSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.pojo.SubscriptionKey;

public class NewInternalSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private InternalSubscriptionHandler internalSubscriptionHandler;

    public NewInternalSubscriptionHandler(InternalSubscriptionHandler internalSubscriptionHandler) {
        this.internalSubscriptionHandler = internalSubscriptionHandler;
    }

    public void newInternalSubscription(String subscriber, String subscriberDisplayName, String notifier, String eventPackage, String subscriptionId, int expires, String content, String contentType, String contentSubtype, boolean eventList, EntityManager entityManager, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        SubscriptionControlSbb sbb;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"newInternalSubscription()");
        }
        if (expires >= (sbb = this.internalSubscriptionHandler.sbb).getConfiguration().getMinExpires()) {
            if (expires > sbb.getConfiguration().getMaxExpires()) {
                expires = sbb.getConfiguration().getMaxExpires();
            }
        } else {
            sbb.getParentSbbCMP().subscribeError(subscriber, notifier, eventPackage, subscriptionId, 423);
            return;
        }
        SubscriptionKey key = new SubscriptionKey(" ", " ", eventPackage, subscriptionId);
        Subscription subscription = (Subscription)entityManager.find(Subscription.class, (Object)key);
        if (subscription != null) {
            sbb.getParentSbbCMP().subscribeError(subscriber, notifier, eventPackage, subscriptionId, 412);
        } else {
            this.authorizeNewInternalSubscription(subscriber, subscriberDisplayName, notifier, key, expires, content, contentType, contentSubtype, eventList, entityManager, childSbb);
        }
    }

    private void authorizeNewInternalSubscription(String subscriber, String subscriberDisplayName, String notifier, SubscriptionKey key, int expires, String content, String contentType, String contentSubtype, boolean eventList, EntityManager entityManager, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        if (key.getEventPackage().endsWith(".winfo")) {
            this.newInternalSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, subscriber.equals(notifier) ? 200 : 403, eventList, entityManager, childSbb);
        } else {
            childSbb.isSubscriberAuthorized(subscriber, subscriberDisplayName, notifier, key, expires, content, contentType, contentSubtype, eventList, null);
        }
    }

    public void newInternalSubscriptionAuthorization(String subscriber, String subscriberDisplayName, String notifier, SubscriptionKey subscriptionKey, int expires, int responseCode, boolean eventList, EntityManager entityManager, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"newInternalSubscriptionAuthorization()");
        }
        SubscriptionControlSbb sbb = this.internalSubscriptionHandler.sbb;
        ActivityContextInterface aci = null;
        if (responseCode == 202 || responseCode == 200) {
            NullActivity nullActivity = sbb.getNullActivityFactory().createNullActivity();
            try {
                aci = sbb.getNullACIFactory().getActivityContextInterface(nullActivity);
                sbb.getActivityContextNamingfacility().bind(aci, subscriptionKey.toString());
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create internal subscription aci", (Throwable)e);
                sbb.getParentSbbCMP().subscribeError(subscriber, notifier, subscriptionKey.getEventPackage(), subscriptionKey.getEventId(), 500);
                return;
            }
        } else {
            sbb.getParentSbbCMP().subscribeError(subscriber, notifier, subscriptionKey.getEventPackage(), subscriptionKey.getEventId(), responseCode);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Subscription: subscriber=" + subscriber + ",notifier=" + notifier + ",eventPackage=" + subscriptionKey.getEventPackage() + " not authorized (" + responseCode + ")"));
            }
            return;
        }
        aci.attach(sbb.getSbbContext().getSbbLocalObject());
        sbb.getParentSbbCMP().subscribeOk(subscriber, notifier, subscriptionKey.getEventPackage(), subscriptionKey.getEventId(), expires, responseCode);
        Subscription.Status initialStatus = responseCode == 202 ? Subscription.Status.pending : Subscription.Status.active;
        Subscription subscription = new Subscription(subscriptionKey, subscriber, notifier, initialStatus, subscriberDisplayName, expires, eventList);
        if (!eventList || responseCode == 202) {
            this.internalSubscriptionHandler.getInternalSubscriberNotificationHandler().notifyInternalSubscriber(entityManager, subscription, aci, childSbb);
        }
        sbb.getWInfoSubscriptionHandler().notifyWinfoSubscriptions(entityManager, subscription, childSbb);
        sbb.setSubscriptionTimerAndPersistSubscription(entityManager, subscription, expires + 1, aci);
        if (eventList && responseCode == 200 && !this.internalSubscriptionHandler.sbb.getEventListControlChildSbb().createSubscription(subscription)) {
            this.internalSubscriptionHandler.getRemoveInternalSubscriptionHandler().removeInternalSubscription(aci, subscription, entityManager, childSbb);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Created " + subscription));
        }
    }
}

