/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.internal;

import javax.persistence.EntityManager;
import javax.slee.ActivityContextInterface;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.internal.InternalSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.pojo.SubscriptionKey;

public class RemoveInternalSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private InternalSubscriptionHandler internalSubscriptionHandler;

    public RemoveInternalSubscriptionHandler(InternalSubscriptionHandler sipSubscriptionHandler) {
        this.internalSubscriptionHandler = sipSubscriptionHandler;
    }

    public void removeInternalSubscription(String subscriber, String notifier, String eventPackage, String subscriptionId, EntityManager entityManager, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        SubscriptionControlSbb sbb = this.internalSubscriptionHandler.sbb;
        SubscriptionKey subscriptionKey = new SubscriptionKey(" ", " ", eventPackage, subscriptionId);
        Subscription subscription = (Subscription)entityManager.find(Subscription.class, (Object)subscriptionKey);
        if (subscription == null) {
            sbb.getParentSbbCMP().unsubscribeError(subscriber, notifier, eventPackage, subscriptionId, 412);
            return;
        }
        ActivityContextInterface aci = sbb.getActivityContextNamingfacility().lookup(subscriptionKey.toString());
        if (aci == null) {
            logger.error((Object)("Failed to retrieve aci for internal subscription with key " + subscriptionKey));
            sbb.getParentSbbCMP().unsubscribeError(subscriber, notifier, eventPackage, subscriptionId, 500);
            return;
        }
        sbb.getParentSbbCMP().unsubscribeOk(subscriber, notifier, eventPackage, subscriptionId);
        if (subscription.getResourceList().booleanValue()) {
            this.internalSubscriptionHandler.sbb.getEventListControlChildSbb().removeSubscription(subscription);
        }
        this.removeInternalSubscription(aci, subscription, entityManager, childSbb);
    }

    public void removeInternalSubscription(ActivityContextInterface aci, Subscription subscription, EntityManager entityManager, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        this.internalSubscriptionHandler.sbb.getTimerFacility().cancelTimer(subscription.getTimerID());
        if (!subscription.getStatus().equals((Object)Subscription.Status.terminated) && !subscription.getStatus().equals((Object)Subscription.Status.waiting)) {
            subscription.setStatus(Subscription.Status.terminated);
            subscription.setLastEvent(null);
        }
        this.internalSubscriptionHandler.getInternalSubscriberNotificationHandler().notifyInternalSubscriber(entityManager, subscription, aci, childSbb);
        this.internalSubscriptionHandler.sbb.getWInfoSubscriptionHandler().notifyWinfoSubscriptions(entityManager, subscription, childSbb);
        if (subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Status changed for " + subscription));
            }
            this.internalSubscriptionHandler.sbb.removeSubscriptionData(entityManager, subscription, null, aci, childSbb);
        } else if (subscription.getStatus().equals((Object)Subscription.Status.waiting)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Status changed for " + subscription));
            }
            int defaultWaitingExpires = this.internalSubscriptionHandler.sbb.getConfiguration().getDefaultWaitingExpires();
            subscription.refresh(defaultWaitingExpires);
            this.internalSubscriptionHandler.sbb.setSubscriptionTimerAndPersistSubscription(entityManager, subscription, defaultWaitingExpires + 1, aci);
        }
    }
}

