/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.eventlist;

import gov.nist.javax.sip.Utils;
import javax.persistence.EntityManager;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriberParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriberSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.eventlist.FlatList;
import org.mobicents.slee.sipevent.server.subscription.eventlist.MultiPart;
import org.mobicents.slee.sipevent.server.subscription.eventlist.NotificationData;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.pojo.SubscriptionKey;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.EntryType;

public abstract class EventListSubscriberSbb
implements Sbb,
EventListSubscriberSbbLocalObject {
    private static final Logger logger = Logger.getLogger(EventListSubscriberSbb.class);
    private SbbContext sbbContext;

    public abstract void setNotificationData(NotificationData var1);

    public abstract NotificationData getNotificationData();

    public abstract void setFlatList(FlatList var1);

    public abstract FlatList getFlatList();

    public abstract void setSubscriptionKey(SubscriptionKey var1);

    public abstract SubscriptionKey getSubscriptionKey();

    public abstract void setParentSbbCMP(EventListSubscriberParentSbbLocalObject var1);

    public abstract EventListSubscriberParentSbbLocalObject getParentSbbCMP();

    public void setParentSbb(EventListSubscriberParentSbbLocalObject parentSbb) {
        this.setParentSbbCMP(parentSbb);
    }

    private String getVirtualSubscriptionId(SubscriptionKey originalSubscriptionKey, String virtualSubscriptionNotifier) {
        return originalSubscriptionKey.toString() + ":list:" + virtualSubscriptionNotifier;
    }

    public void subscribe(Subscription subscription, FlatList flatList) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("creating backend subscriptions for rls subscription " + subscription.getKey()));
        }
        this.setSubscriptionKey(subscription.getKey());
        this.setFlatList(flatList);
        this.setNotificationData(new NotificationData(subscription.getNotifier(), subscription.getVersion(), flatList, Utils.generateTag(), Utils.generateTag()));
        SubscriptionClientControlSbbLocalObject subscriptionClient = this.getSubscriptionClientControlSbb();
        for (EntryType entryType : flatList.getEntries().values()) {
            subscriptionClient.subscribe(subscription.getSubscriber(), subscription.getSubscriberDisplayName(), entryType.getUri(), subscription.getKey().getEventPackage(), this.getVirtualSubscriptionId(subscription.getKey(), entryType.getUri()), subscription.getExpires(), null, null, null);
        }
    }

    public void resubscribe(Subscription subscription) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("refreshing backend subscriptions for rls subscription " + subscription.getKey()));
        }
        FlatList flatList = this.getFlatList();
        subscription.incrementVersion();
        this.setNotificationData(new NotificationData(subscription.getNotifier(), subscription.getVersion(), flatList, Utils.generateTag(), Utils.generateTag()));
        SubscriptionClientControlSbbLocalObject subscriptionClient = this.getSubscriptionClientControlSbb();
        for (EntryType entryType : flatList.getEntries().values()) {
            subscriptionClient.resubscribe(subscription.getSubscriber(), entryType.getUri(), subscription.getKey().getEventPackage(), this.getVirtualSubscriptionId(subscription.getKey(), entryType.getUri()), subscription.getExpires());
        }
    }

    public void unsubscribe(Subscription subscription) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removing backend subscriptions for rls subscription " + subscription.getKey()));
        }
        this.setSubscriptionKey(null);
        this.unsubscribe(subscription.getSubscriber(), subscription.getKey());
    }

    private void unsubscribe(String subscriber, SubscriptionKey key) {
        SubscriptionClientControlSbbLocalObject subscriptionClient = this.getSubscriptionClientControlSbb();
        for (EntryType entryType : this.getFlatList().getEntries().values()) {
            subscriptionClient.unsubscribe(subscriber, entryType.getUri(), key.getEventPackage(), this.getVirtualSubscriptionId(key, entryType.getUri()));
        }
    }

    private Subscription getSubscription(EventListSubscriberParentSbbLocalObject parentSbb, SubscriptionKey key, String subscriber) {
        Subscription subscription = parentSbb.getSubscription(key);
        if (subscription == null && this.getSubscriptionKey() != null) {
            logger.warn((Object)("Unable to get subscription " + key + " from parent sbb, it does not exists anymore! Removing all virtual subscriptions"));
            this.unsubscribe(subscriber, key);
        }
        return subscription;
    }

    private NotificationData createPartialStateNotificationData(EventListSubscriberParentSbbLocalObject parentSbb, SubscriptionKey subscriptionKey, String subscriber, String notifier) {
        Subscription subscription = this.getSubscription(parentSbb, subscriptionKey, subscriber);
        if (subscription != null) {
            subscription.incrementVersion();
            EntityManager entityManager = subscription.getEntityManager();
            try {
                entityManager.flush();
                entityManager.close();
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"failed to update rls subscription", (Throwable)e);
                }
                return null;
            }
            return new NotificationData(subscription.getNotifier(), subscription.getVersion(), (EntryType)this.getFlatList().getEntries().get(notifier), Utils.generateTag(), Utils.generateTag());
        }
        return null;
    }

    public void notifyEvent(String subscriber, String notifier, String eventPackage, String subscriptionId, Subscription.Event terminationReason, Subscription.Status status, String content, String contentType, String contentSubtype) {
        SubscriptionKey subscriptionKey = this.getSubscriptionKey();
        if (subscriptionKey != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("notification for rls subscription " + subscriptionKey + " from " + notifier));
            }
            EventListSubscriberParentSbbLocalObject parentSbb = this.getParentSbbCMP();
            NotificationData notificationData = this.getNotificationData();
            if (notificationData == null && (notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier)) == null) {
                return;
            }
            String id = notifier;
            String cid = content != null ? id : null;
            MultiPart multiPart = null;
            try {
                multiPart = notificationData.addNotificationData(notifier, cid, id, content, contentType, contentSubtype, status.toString(), terminationReason == null ? null : terminationReason.toString());
            }
            catch (IllegalStateException e) {
                notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier);
                if (notificationData == null) {
                    return;
                }
                multiPart = notificationData.addNotificationData(notifier, cid, id, content, contentType, contentSubtype, status.toString(), terminationReason == null ? null : terminationReason.toString());
            }
            if (multiPart != null) {
                this.setNotificationData(null);
                parentSbb.notifyEventListSubscriber(subscriptionKey, multiPart);
            }
        }
    }

    public void resubscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("resubscribeError: sid=" + subscriptionId + ", error=" + error));
        }
        EventListSubscriberParentSbbLocalObject parentSbb = this.getParentSbbCMP();
        SubscriptionKey key = this.getSubscriptionKey();
        switch (error) {
            case 412: {
                Subscription subscription = this.getSubscription(parentSbb, key, subscriber);
                subscription.getEntityManager().close();
                if (subscription == null) break;
                this.getSubscriptionClientControlSbb().subscribe(subscriber, subscription.getSubscriberDisplayName(), notifier, eventPackage, subscriptionId, subscription.getExpires(), null, null, null);
                break;
            }
        }
    }

    public void resubscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("resubscribeOk: sid=" + subscriptionId));
        }
    }

    public void subscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("subscribeError: sid=" + subscriptionId + ", error=" + error));
        }
        EventListSubscriberParentSbbLocalObject parentSbb = this.getParentSbbCMP();
        SubscriptionKey subscriptionKey = this.getSubscriptionKey();
        NotificationData notificationData = this.getNotificationData();
        if (notificationData == null) {
            notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier);
        }
        String cid = notifier;
        MultiPart multiPart = null;
        switch (error) {
            case 403: {
                try {
                    multiPart = notificationData.addNotificationData(notifier, null, cid, null, null, null, "terminated", "rejected");
                }
                catch (IllegalStateException e) {
                    notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier);
                    multiPart = notificationData.addNotificationData(notifier, null, cid, null, null, null, "terminated", "rejected");
                }
                break;
            }
            default: {
                try {
                    multiPart = notificationData.notificationDataNotNeeded(notifier);
                    break;
                }
                catch (IllegalStateException e) {
                    notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier);
                    multiPart = notificationData.notificationDataNotNeeded(notifier);
                }
            }
        }
        if (multiPart != null) {
            this.setNotificationData(null);
            parentSbb.notifyEventListSubscriber(subscriptionKey, multiPart);
        }
    }

    public void subscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires, int responseCode) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("subscribeOk: sid=" + subscriptionId));
        }
    }

    public void unsubscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("unsubscribeError: sid=" + subscriptionId + ", error=" + error));
        }
    }

    public void unsubscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("unsubscribeOk: sid=" + subscriptionId));
        }
    }

    public abstract ChildRelation getSubscriptionClientControlChildRelation();

    public abstract SubscriptionClientControlSbbLocalObject getSubscriptionClientControlChildSbbCMP();

    public abstract void setSubscriptionClientControlChildSbbCMP(SubscriptionClientControlSbbLocalObject var1);

    public SubscriptionClientControlSbbLocalObject getSubscriptionClientControlSbb() {
        SubscriptionClientControlSbbLocalObject childSbb = this.getSubscriptionClientControlChildSbbCMP();
        if (childSbb == null) {
            try {
                childSbb = (SubscriptionClientControlSbbLocalObject)this.getSubscriptionClientControlChildRelation().create();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create child sbb", (Throwable)e);
                return null;
            }
            this.setSubscriptionClientControlChildSbbCMP(childSbb);
            childSbb.setParentSbb((SubscriptionClientControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        return childSbb;
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }
}

