/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.sip;

import javax.persistence.EntityManager;
import javax.sip.Dialog;
import javax.sip.RequestEvent;
import javax.sip.header.Header;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;

public class RefreshSipSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private SipSubscriptionHandler sipSubscriptionHandler;

    public RefreshSipSubscriptionHandler(SipSubscriptionHandler sipSubscriptionHandler) {
        this.sipSubscriptionHandler = sipSubscriptionHandler;
    }

    public void refreshSipSubscription(RequestEvent event, ActivityContextInterface aci, int expires, Subscription subscription, EntityManager entityManager, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        this.sipSubscriptionHandler.sbb.getTimerFacility().cancelTimer(subscription.getTimerID());
        subscription.refresh(expires);
        try {
            Response response = this.sipSubscriptionHandler.sbb.getMessageFactory().createResponse(200, event.getRequest());
            response = this.sipSubscriptionHandler.addContactHeader(response);
            response.addHeader((Header)this.sipSubscriptionHandler.sbb.getHeaderFactory().createExpiresHeader(expires));
            event.getServerTransaction().sendResponse(response);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Response sent:\n" + response.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't send RESPONSE", (Throwable)e);
        }
        if (!subscription.getResourceList().booleanValue()) {
            try {
                this.sipSubscriptionHandler.getSipSubscriberNotificationHandler().createAndSendNotify(entityManager, subscription, (Dialog)aci.getActivity(), childSbb);
            }
            catch (Exception e) {
                logger.error((Object)"failed to notify subscriber", (Throwable)e);
            }
        }
        this.sipSubscriptionHandler.sbb.setSubscriptionTimerAndPersistSubscription(entityManager, subscription, expires + 1, aci);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Refreshed " + subscription + " for " + expires + " seconds"));
        }
        if (subscription.getResourceList().booleanValue()) {
            this.sipSubscriptionHandler.sbb.getEventListControlChildSbb().refreshSubscription(subscription);
        }
    }
}

