/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.eventlist;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.FlatListMakerParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.FlatListMakerSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.eventlist.FlatList;
import org.mobicents.slee.xdm.server.ServerConfiguration;
import org.mobicents.slee.xdm.server.XDMClientControlParentSbbLocalObject;
import org.mobicents.slee.xdm.server.XDMClientControlSbbLocalObject;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.EntryRefType;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.EntryType;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.ExternalType;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.ListType;
import org.openxdm.xcap.client.appusage.rlsservices.jaxb.ServiceType;
import org.openxdm.xcap.common.key.XcapUriKey;
import org.openxdm.xcap.common.uri.DocumentSelector;
import org.openxdm.xcap.common.uri.Parser;
import org.openxdm.xcap.common.uri.ResourceSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlatListMakerSbb
implements Sbb,
FlatListMakerSbbLocalObject {
    private static final Logger logger = Logger.getLogger(FlatListMakerSbb.class);
    private static final JAXBContext jaxbContext = FlatListMakerSbb.initJAXBContext();
    private SbbContext sbbContext;

    public abstract void setParentSbbCMP(FlatListMakerParentSbbLocalObject var1);

    public abstract FlatListMakerParentSbbLocalObject getParentSbbCMP();

    public void setParentSbb(FlatListMakerParentSbbLocalObject sbbLocalObject) {
        this.setParentSbbCMP(sbbLocalObject);
    }

    public abstract void setFlatList(FlatList var1);

    public abstract FlatList getFlatList();

    public abstract void setLists(ArrayList var1);

    public abstract ArrayList getLists();

    public abstract void setCurrentListType(ListType var1);

    public abstract ListType getCurrentListType();

    private ArrayList<ListType> addNestedLists(ArrayList<ListType> lists, ListType list) {
        Iterator i = list.getListOrExternalOrEntry().iterator();
        while (i.hasNext()) {
            JAXBElement element = (JAXBElement)i.next();
            if (!(element.getValue() instanceof ListType)) continue;
            this.addNestedLists(lists, (ListType)element.getValue());
            i.remove();
        }
        lists.add(list);
        return lists;
    }

    private void processList(FlatList flatList, ArrayList<ListType> lists, ListType currentListType) {
        Iterator i = currentListType.getListOrExternalOrEntry().iterator();
        while (i.hasNext()) {
            String resourceList;
            JAXBElement element = (JAXBElement)i.next();
            i.remove();
            if (element.getValue() instanceof EntryType) {
                flatList.putEntry((EntryType)element.getValue());
                continue;
            }
            if (element.getValue() instanceof EntryRefType) {
                this.setCurrentListType(currentListType);
                this.setFlatList(flatList);
                this.setLists(lists);
                EntryRefType entryRefType = (EntryRefType)element.getValue();
                resourceList = entryRefType.getRef();
                if (this.dereferenceResourceList(resourceList, flatList, false)) continue;
                return;
            }
            if (!(element.getValue() instanceof ExternalType)) continue;
            ExternalType externalType = (ExternalType)element.getValue();
            resourceList = externalType.getAnchor();
            this.setCurrentListType(currentListType);
            this.setFlatList(flatList);
            this.setLists(lists);
            if (this.dereferenceResourceList(resourceList, flatList, true)) continue;
            return;
        }
        if (!lists.isEmpty()) {
            ListType nextListType = lists.remove(lists.size() - 1);
            this.processList(flatList, lists, nextListType);
        } else {
            this.returnFlatListToParent(flatList);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dereferenceResourceList(String resourceList, FlatList flatList, boolean absoluteURI) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dereferencing resource list " + resourceList));
        }
        XcapUriKey key = null;
        DocumentSelector documentSelector = null;
        try {
            block8: {
                if (absoluteURI) {
                    String shemeAndAuthorityURI = this.getSchemeAndAuthorityURI();
                    if (resourceList.startsWith(shemeAndAuthorityURI)) {
                        resourceList = resourceList.substring(shemeAndAuthorityURI.length());
                        break block8;
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("The resource list (to dereference) uri " + resourceList + " does not starts with server scheme and authority uri " + shemeAndAuthorityURI));
                        }
                        return true;
                    }
                }
                resourceList = "/" + resourceList;
            }
            ResourceSelector resourceSelector = null;
            int queryComponentSeparator = resourceList.indexOf(63);
            resourceSelector = queryComponentSeparator > 0 ? Parser.parseResourceSelector((String)this.getLocalXcapRoot(), (String)resourceList.substring(0, queryComponentSeparator), (String)resourceList.substring(queryComponentSeparator + 1)) : Parser.parseResourceSelector((String)this.getLocalXcapRoot(), (String)resourceList, null);
            documentSelector = Parser.parseDocumentSelector((String)resourceSelector.getDocumentSelector());
            if (!documentSelector.getAUID().equals("resource-lists")) {
                logger.error((Object)("Unable to make flat list, invalid or not supported resource list uri: " + resourceList));
                flatList.setStatus(502);
                this.returnFlatListToParent(flatList);
                return false;
            }
            flatList.getResourceLists().add(documentSelector);
            this.setFlatList(flatList);
            key = new XcapUriKey(resourceSelector);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to parse resource list (to dereference) " + resourceList), (Throwable)e);
            flatList.setStatus(502);
            this.returnFlatListToParent(flatList);
            return false;
        }
        XDMClientControlSbbLocalObject xdmClientSbb = this.getXDMClientControlSbb();
        xdmClientSbb.get(key, null);
        return false;
    }

    private void makeFlatList(FlatList flatList, ListType listType) {
        ArrayList<ListType> lists = this.addNestedLists(new ArrayList<ListType>(), listType);
        ListType currentListType = lists.remove(lists.size() - 1);
        this.processList(flatList, lists, currentListType);
    }

    public void makeFlatList(ServiceType serviceType) {
        FlatList flatList = new FlatList(serviceType);
        ListType listType = serviceType.getList();
        if (listType != null) {
            this.makeFlatList(flatList, listType);
        } else {
            String resourceList = serviceType.getResourceList().trim();
            this.setFlatList(flatList);
            this.dereferenceResourceList(resourceList, flatList, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResponse(XcapUriKey key, int responseCode, String mimetype, String content, String tag) {
        FlatList flatList = this.getFlatList();
        ArrayList lists = this.getLists();
        ListType currentListType = this.getCurrentListType();
        if (responseCode == 200) {
            Object o = null;
            StringReader stringReader = new StringReader(content);
            try {
                o = jaxbContext.createUnmarshaller().unmarshal((Reader)stringReader);
            }
            catch (JAXBException e) {
                logger.error((Object)("failed to unmarshall content for key " + key), (Throwable)e);
                flatList.setStatus(502);
                if (currentListType != null) {
                    this.processList(flatList, lists, currentListType);
                } else {
                    this.returnFlatListToParent(flatList);
                }
                return;
            }
            finally {
                stringReader.close();
            }
            if (o instanceof ListType) {
                if (lists == null) {
                    this.makeFlatList(flatList, (ListType)o);
                } else {
                    this.processList(flatList, lists, (ListType)o);
                }
            } else if (o instanceof EntryType) {
                flatList.putEntry((EntryType)o);
                this.processList(flatList, lists, currentListType);
            }
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("xdm get request didn't returned sucess code. key: " + key));
            }
            flatList.setStatus(502);
            if (this.getCurrentListType() != null) {
                this.processList(flatList, lists, currentListType);
            } else {
                this.returnFlatListToParent(flatList);
            }
        }
    }

    private void returnFlatListToParent(FlatList flatList) {
        this.getParentSbbCMP().flatListMade(flatList);
        this.sbbContext.getSbbLocalObject().remove();
    }

    public String getLocalXcapRoot() {
        return ServerConfiguration.XCAP_ROOT;
    }

    public String getSchemeAndAuthorityURI() {
        return ServerConfiguration.SCHEME_AND_AUTHORITY_URI;
    }

    public abstract ChildRelation getXDMClientControlChildRelation();

    public abstract XDMClientControlSbbLocalObject getXDMClientControlChildSbbCMP();

    public abstract void setXDMClientControlChildSbbCMP(XDMClientControlSbbLocalObject var1);

    public XDMClientControlSbbLocalObject getXDMClientControlSbb() {
        XDMClientControlSbbLocalObject childSbb = this.getXDMClientControlChildSbbCMP();
        if (childSbb == null) {
            try {
                childSbb = (XDMClientControlSbbLocalObject)this.getXDMClientControlChildRelation().create();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create child sbb", (Throwable)e);
                return null;
            }
            this.setXDMClientControlChildSbbCMP(childSbb);
            childSbb.setParentSbb((XDMClientControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        return childSbb;
    }

    private static JAXBContext initJAXBContext() {
        try {
            return JAXBContext.newInstance((String)"org.openxdm.xcap.client.appusage.rlsservices.jaxb:org.openxdm.xcap.client.appusage.resourcelists.jaxb");
        }
        catch (JAXBException e) {
            logger.error((Object)"failed to create jaxb context");
            return null;
        }
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }
}

