/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.eventlist;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mobicents.slee.sipevent.server.subscription.eventlist.FlatList;
import org.mobicents.slee.sipevent.server.subscription.eventlist.FlatListUpdatedEvent;
import org.mobicents.slee.xdm.server.XDMClientControlSbbLocalObject;
import org.openxdm.xcap.common.uri.DocumentSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RlsServicesCache {
    private ConcurrentHashMap<String, FlatList> cache = new ConcurrentHashMap();
    private Map<DocumentSelector, Set<FlatList>> resourceLists = new HashMap<DocumentSelector, Set<FlatList>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlatListUpdatedEvent putFlatList(FlatList flatList, XDMClientControlSbbLocalObject xdmClientSbb) {
        Map<DocumentSelector, Set<FlatList>> map;
        FlatListUpdatedEvent result = null;
        FlatList oldFlatList = this.cache.put(flatList.getServiceType().getUri(), flatList);
        if (oldFlatList != null) {
            oldFlatList.getResourceLists().removeAll(flatList.getResourceLists());
            for (DocumentSelector documentSelector : oldFlatList.getResourceLists()) {
                map = this.resourceLists;
                synchronized (map) {
                    Set<FlatList> flatListsLinked = this.resourceLists.get(documentSelector);
                    if (flatListsLinked != null) {
                        flatListsLinked.remove(oldFlatList);
                        if (flatListsLinked.isEmpty()) {
                            this.resourceLists.remove(documentSelector);
                            xdmClientSbb.unsubscribeDocument(documentSelector);
                        }
                    }
                }
            }
            HashSet<String> oldEntries = new HashSet<String>();
            HashSet<String> newEntries = new HashSet<String>();
            HashSet removedEntries = new HashSet();
            boolean updated = false;
            for (String entry : flatList.getEntries().keySet()) {
                if (oldFlatList.getEntries().remove(entry) == null) {
                    newEntries.add(entry);
                    updated = true;
                    continue;
                }
                oldEntries.add(entry);
            }
            removedEntries.addAll(oldFlatList.getEntries().keySet());
            if (!updated && !removedEntries.isEmpty()) {
                updated = true;
            }
            if (updated) {
                result = new FlatListUpdatedEvent(flatList, newEntries, oldEntries, removedEntries);
            }
        }
        for (DocumentSelector documentSelector : flatList.getResourceLists()) {
            map = this.resourceLists;
            synchronized (map) {
                Set<FlatList> flatListsLinked = this.resourceLists.get(documentSelector);
                if (flatListsLinked == null) {
                    flatListsLinked = new HashSet<FlatList>();
                    this.resourceLists.put(documentSelector, flatListsLinked);
                    xdmClientSbb.subscribeDocument(documentSelector);
                }
                flatListsLinked.add(flatList);
            }
        }
        return result;
    }

    public FlatList getFlatList(String uri) {
        return this.cache.get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlatList removeFlatList(String uri, XDMClientControlSbbLocalObject xdmClientSbb) {
        FlatList flatList = this.cache.remove(uri);
        if (flatList != null) {
            for (DocumentSelector documentSelector : flatList.getResourceLists()) {
                Map<DocumentSelector, Set<FlatList>> map = this.resourceLists;
                synchronized (map) {
                    Set<FlatList> flatListsLinked = this.resourceLists.get(documentSelector);
                    if (flatListsLinked != null) {
                        flatListsLinked.remove(flatList);
                        if (flatListsLinked.isEmpty()) {
                            this.resourceLists.remove(documentSelector);
                            xdmClientSbb.unsubscribeDocument(documentSelector);
                        }
                    }
                }
            }
        }
        return flatList;
    }

    public Set<String> getFlatListServiceURIs() {
        return this.cache.keySet();
    }

    public Set<FlatList> getFlatListsLinkedToResourceList(DocumentSelector documentSelector) {
        return this.resourceLists.get(documentSelector);
    }
}

