/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.jmx;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.sipevent.server.subscription.jmx.SubscriptionControlManagementMBean;

public class SubscriptionControlManagement
implements SubscriptionControlManagementMBean {
    private Logger logger = Logger.getLogger(SubscriptionControlManagement.class);
    private int defaultExpires;
    private int maxExpires = this.defaultExpires = 3600;
    private int minExpires = 60;
    private int defaultWaitingExpires = 86400;
    private int maxForwards = 70;
    private String contactAddressDisplayName = "Mobicents SIP Event Server";
    private boolean eventListSupportOn = true;
    private String pChargingVectorHeaderTerminatingIOI = "mobicents.org";

    public void startService() throws Exception {
        MBeanServer mbs = SleeContainer.lookupFromJndi().getMBeanServer();
        ObjectName on = null;
        try {
            on = new ObjectName("slee:sippresence=SipEventSubscriptionControl");
        }
        catch (MalformedObjectNameException e) {
            this.logger.error((Object)e);
        }
        try {
            if (mbs.getObjectInstance(on) != null) {
                mbs.unregisterMBean(on);
            }
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        try {
            mbs.registerMBean(this, on);
        }
        catch (InstanceAlreadyExistsException e) {
            this.logger.error((Object)e);
        }
        this.logger.info((Object)"SIP Event Subscription Control Management MBean started.");
    }

    public void stopService() {
        try {
            SleeContainer.lookupFromJndi().getMBeanServer().unregisterMBean(new ObjectName("slee:sippresence=SipEventSubscriptionControl"));
            this.logger.info((Object)"SIP Event Subscription Control Management MBean stopped.");
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to stop SIP Event Subscription Control Management MBean.", (Throwable)e);
        }
    }

    public int getDefaultExpires() {
        return this.defaultExpires;
    }

    public void setDefaultExpires(int defaultExpires) {
        this.defaultExpires = defaultExpires;
    }

    public int getMaxExpires() {
        return this.maxExpires;
    }

    public void setMaxExpires(int maxExpires) {
        this.maxExpires = maxExpires;
    }

    public int getMinExpires() {
        return this.minExpires;
    }

    public void setMinExpires(int minExpires) {
        this.minExpires = minExpires;
    }

    public int getDefaultWaitingExpires() {
        return this.defaultWaitingExpires;
    }

    public void setDefaultWaitingExpires(int defaultWaitingExpires) {
        this.defaultWaitingExpires = defaultWaitingExpires;
    }

    public int getMaxForwards() {
        return this.maxForwards;
    }

    public void setMaxForwards(int maxForwards) {
        this.maxForwards = maxForwards;
    }

    public String getContactAddressDisplayName() {
        return this.contactAddressDisplayName;
    }

    public void setContactAddressDisplayName(String contactAddressDisplayName) {
        this.contactAddressDisplayName = contactAddressDisplayName;
    }

    public boolean getEventListSupportOn() {
        return this.eventListSupportOn;
    }

    public void setEventListSupportOn(boolean eventListSupportOn) {
        this.eventListSupportOn = eventListSupportOn;
    }

    public String getPChargingVectorHeaderTerminatingIOI() {
        return this.pChargingVectorHeaderTerminatingIOI;
    }

    public void setPChargingVectorHeaderTerminatingIOI(String chargingVectorHeaderTerminatingIOI) {
        this.pChargingVectorHeaderTerminatingIOI = chargingVectorHeaderTerminatingIOI;
    }
}

