/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.winfo;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.sip.Dialog;
import javax.sip.header.ContentTypeHeader;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.winfo.pojo.Watcher;
import org.mobicents.slee.sipevent.server.subscription.winfo.pojo.WatcherList;
import org.mobicents.slee.sipevent.server.subscription.winfo.pojo.Watcherinfo;

public class WInfoSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private SubscriptionControlSbb sbb;
    private static final JAXBContext winfoJAXBContext = WInfoSubscriptionHandler.initWInfoJAXBContext();

    public WInfoSubscriptionHandler(SubscriptionControlSbb sbb) {
        this.sbb = sbb;
    }

    public void notifyWinfoSubscriptions(EntityManager entityManager, Subscription subscription, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        if (!subscription.getKey().getEventPackage().endsWith(".winfo")) {
            List winfoSubscriptions = entityManager.createNamedQuery("MSPS_NQUERY_selectSubscriptionsFromNotifierAndEventPackage").setParameter("notifier", (Object)subscription.getNotifier()).setParameter("eventPackage", (Object)(subscription.getKey().getEventPackage() + ".winfo")).getResultList();
            if (!winfoSubscriptions.isEmpty()) {
                for (Subscription winfoSubscription : winfoSubscriptions) {
                    if (!winfoSubscription.getStatus().equals((Object)Subscription.Status.active)) continue;
                    try {
                        ActivityContextInterface winfoAci = this.sbb.getActivityContextNamingfacility().lookup(winfoSubscription.getKey().toString());
                        if (winfoAci != null) {
                            winfoSubscription.incrementVersion();
                            String partialWInfoContent = this.getPartialWatcherInfoContent(winfoSubscription, subscription);
                            ContentTypeHeader winfoContentHeader = this.getWatcherInfoContentHeader();
                            if (winfoSubscription.getKey().isInternalSubscription()) {
                                this.sbb.getInternalSubscriptionHandler().getInternalSubscriberNotificationHandler().notifyInternalSubscriber(entityManager, subscription, partialWInfoContent, winfoContentHeader, winfoAci);
                            } else {
                                Dialog winfoDialog = (Dialog)winfoAci.getActivity();
                                Request notify = this.sbb.getSipSubscribeHandler().getSipSubscriberNotificationHandler().createNotify(winfoDialog, winfoSubscription);
                                notify.setContent((Object)partialWInfoContent, winfoContentHeader);
                                winfoDialog.sendRequest(this.sbb.getSipProvider().getNewClientTransaction(notify));
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Request sent:\n" + notify.toString()));
                                }
                            }
                            entityManager.persist((Object)winfoSubscription);
                            continue;
                        }
                        logger.warn((Object)("Unable to find subscription aci to notify subscription " + winfoSubscription.getKey() + ". Removing subscription data"));
                        this.sbb.removeSubscriptionData(entityManager, winfoSubscription, null, null, childSbb);
                    }
                    catch (Exception e) {
                        logger.error((Object)"failed to notify winfo subscriber", (Throwable)e);
                    }
                }
            }
            entityManager.flush();
        }
    }

    private static JAXBContext initWInfoJAXBContext() {
        try {
            return JAXBContext.newInstance((String)"org.mobicents.slee.sipevent.server.subscription.winfo.pojo");
        }
        catch (JAXBException e) {
            logger.error((Object)"failed to create winfo jaxb context");
            return null;
        }
    }

    private Marshaller getWInfoMarshaller() {
        try {
            return winfoJAXBContext.createMarshaller();
        }
        catch (JAXBException e) {
            logger.error((Object)"failed to create winfo unmarshaller", (Throwable)e);
            return null;
        }
    }

    private Watcher createWInfoWatcher(Subscription subscription) {
        Watcher watcher = new Watcher();
        watcher.setId(String.valueOf(subscription.hashCode()));
        watcher.setStatus(subscription.getStatus().toString());
        watcher.setDurationSubscribed(BigInteger.valueOf(subscription.getSubscriptionDuration()));
        if (subscription.getLastEvent() != null) {
            watcher.setEvent(subscription.getLastEvent().toString());
        }
        if (subscription.getSubscriberDisplayName() != null) {
            watcher.setDisplayName(subscription.getSubscriberDisplayName());
        }
        if (!subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
            watcher.setExpiration(BigInteger.valueOf(subscription.getRemainingExpires()));
        }
        watcher.setValue(subscription.getSubscriber());
        return watcher;
    }

    private String marshallWInfo(Watcherinfo watcherinfo) {
        String result = null;
        StringWriter stringWriter = new StringWriter();
        try {
            Marshaller marshaller = this.getWInfoMarshaller();
            marshaller.marshal((Object)watcherinfo, (Writer)stringWriter);
            result = stringWriter.toString();
            stringWriter.close();
        }
        catch (Exception e) {
            logger.error((Object)"failed to marshall winfo", (Throwable)e);
            try {
                stringWriter.close();
            }
            catch (Exception f) {
                logger.error((Object)"failed to close winfo string writer", (Throwable)f);
            }
        }
        return result;
    }

    private String getPartialWatcherInfoContent(Subscription winfoSubscription, Subscription subscription) {
        Watcherinfo watcherinfo = new Watcherinfo();
        watcherinfo.setVersion(BigInteger.valueOf(winfoSubscription.getVersion()));
        watcherinfo.setState("partial");
        WatcherList watcherList = new WatcherList();
        watcherList.setResource(winfoSubscription.getNotifier());
        watcherList.setPackage(subscription.getKey().getEventPackage());
        watcherList.getWatcher().add(this.createWInfoWatcher(subscription));
        watcherinfo.getWatcherList().add(watcherList);
        return this.marshallWInfo(watcherinfo);
    }

    public String getFullWatcherInfoContent(EntityManager entityManager, Subscription winfoSubscription) {
        Watcherinfo watcherinfo = new Watcherinfo();
        watcherinfo.setVersion(BigInteger.valueOf(winfoSubscription.getVersion()));
        watcherinfo.setState("full");
        WatcherList watcherList = new WatcherList();
        watcherList.setResource(winfoSubscription.getNotifier());
        String winfoEventPackage = winfoSubscription.getKey().getEventPackage();
        String eventPackage = winfoEventPackage.substring(0, winfoEventPackage.indexOf(".winfo"));
        watcherList.setPackage(eventPackage);
        List resultList = entityManager.createNamedQuery("MSPS_NQUERY_selectSubscriptionsFromNotifierAndEventPackage").setParameter("eventPackage", (Object)eventPackage).setParameter("notifier", (Object)winfoSubscription.getNotifier()).getResultList();
        List watchers = watcherList.getWatcher();
        for (Subscription subscription : resultList) {
            watchers.add(this.createWInfoWatcher(subscription));
        }
        watcherinfo.getWatcherList().add(watcherList);
        return this.marshallWInfo(watcherinfo);
    }

    public ContentTypeHeader getWatcherInfoContentHeader() throws ParseException {
        return this.sbb.getHeaderFactory().createContentTypeHeader("application", "watcherinfo+xml");
    }
}

