/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import javax.sip.header.ContentTypeHeader;
import javax.slee.ActivityContextInterface;
import javax.slee.nullactivity.NullActivity;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.internal.InternalSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;

public class InternalSubscriberNotificationHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private InternalSubscriptionHandler internalSubscriptionHandler;

    public InternalSubscriberNotificationHandler(InternalSubscriptionHandler sbb) {
        this.internalSubscriptionHandler = sbb;
    }

    public void notifyInternalSubscriber(Subscription subscription, ActivityContextInterface aci, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        NotifyContent notifyContent = null;
        if (subscription.getStatus().equals((Object)Subscription.Status.active)) {
            notifyContent = childSbb.getNotifyContent(subscription);
        }
        if (notifyContent != null) {
            this.notifyInternalSubscriber(subscription, notifyContent.getContent(), notifyContent.getContentTypeHeader(), aci, childSbb);
        } else {
            this.notifyInternalSubscriber(subscription, null, null, aci, childSbb);
        }
    }

    public void notifyInternalSubscriber(Subscription subscription, String content, ContentTypeHeader contentTypeHeader, ActivityContextInterface aci) {
        SubscriptionClientControlParentSbbLocalObject parent;
        Subscription.Status status;
        String contentType = null;
        String contentSubtype = null;
        if (contentTypeHeader != null) {
            contentType = contentTypeHeader.getContentType();
            contentSubtype = contentTypeHeader.getContentSubType();
        }
        if ((status = subscription.getStatus()) == Subscription.Status.waiting) {
            status = Subscription.Status.terminated;
        }
        Subscription.Event lastEvent = null;
        if (status == Subscription.Status.terminated) {
            lastEvent = subscription.getLastEvent();
            ((NullActivity)aci.getActivity()).endActivity();
        }
        if ((parent = this.internalSubscriptionHandler.sbb.getParentSbbCMP()) != null) {
            parent.notifyEvent(subscription.getSubscriber(), subscription.getNotifier().getUriWithParam(), subscription.getKey().getEventPackage(), subscription.getKey().getEventId(), lastEvent, status, content, contentType, contentSubtype);
        }
    }

    public void notifyInternalSubscriber(Subscription subscription, Object content, ContentTypeHeader contentTypeHeader, ActivityContextInterface aci, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        try {
            if (!subscription.getResourceList()) {
                this.notifyInternalSubscriber(subscription, content != null ? this.getFilteredNotifyContent(subscription, content, childSbb) : null, contentTypeHeader, aci);
            } else {
                this.notifyInternalSubscriber(subscription, content != null ? (String)content : null, contentTypeHeader, aci);
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to notify internal subscriber", (Throwable)e);
        }
    }

    private String getFilteredNotifyContent(Subscription subscription, Object content, ImplementedSubscriptionControlSbbLocalObject childSbb) throws JAXBException, ParseException, IOException {
        Object filteredContent = childSbb.filterContentPerSubscriber(subscription.getSubscriber(), subscription.getNotifier(), subscription.getKey().getEventPackage(), content);
        StringWriter stringWriter = new StringWriter();
        childSbb.getMarshaller().marshal(filteredContent, (Writer)stringWriter);
        String result = stringWriter.toString();
        stringWriter.close();
        return result;
    }
}

