/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.internal;

import javax.slee.ActivityContextInterface;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.internal.InternalSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;

public class RefreshInternalSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private InternalSubscriptionHandler internalSubscriptionHandler;

    public RefreshInternalSubscriptionHandler(InternalSubscriptionHandler sipSubscriptionHandler) {
        this.internalSubscriptionHandler = sipSubscriptionHandler;
    }

    public void refreshInternalSubscription(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        SubscriptionControlSbb sbb = this.internalSubscriptionHandler.sbb;
        SubscriptionKey subscriptionKey = new SubscriptionKey("_", eventPackage, subscriptionId);
        Subscription subscription = dataSource.get(subscriptionKey);
        if (subscription == null) {
            sbb.getParentSbbCMP().resubscribeError(subscriber, notifier, eventPackage, subscriptionId, 412);
            return;
        }
        if (expires >= sbb.getConfiguration().getMinExpires()) {
            if (expires > sbb.getConfiguration().getMaxExpires()) {
                expires = sbb.getConfiguration().getMaxExpires();
            }
        } else {
            sbb.getParentSbbCMP().resubscribeError(subscriber, notifier, eventPackage, subscriptionId, 423);
            return;
        }
        ActivityContextInterface aci = sbb.getActivityContextNamingfacility().lookup(subscriptionKey.toString());
        if (aci == null) {
            logger.error((Object)("Failed to retrieve aci for internal subscription with key " + subscriptionKey));
            sbb.getParentSbbCMP().resubscribeError(subscriber, notifier, eventPackage, subscriptionId, 500);
            return;
        }
        this.internalSubscriptionHandler.sbb.getTimerFacility().cancelTimer(subscription.getTimerID());
        subscription.refresh(expires);
        this.internalSubscriptionHandler.sbb.getParentSbbCMP().resubscribeOk(subscriber, notifier, eventPackage, subscriptionId, expires);
        if (!subscription.getResourceList()) {
            this.internalSubscriptionHandler.getInternalSubscriberNotificationHandler().notifyInternalSubscriber(subscription, aci, childSbb);
        }
        this.internalSubscriptionHandler.sbb.setSubscriptionTimerAndPersistSubscription(subscription, expires + 1, aci);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Refreshed " + subscription + " for " + expires + " seconds"));
        }
        if (subscription.getResourceList()) {
            this.internalSubscriptionHandler.sbb.getEventListSubscriptionHandler().refreshSubscription(subscription);
        }
    }
}

