/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.internal;

import javax.slee.ActivityContextInterface;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.internal.InternalSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;

public class RemoveInternalSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private InternalSubscriptionHandler internalSubscriptionHandler;

    public RemoveInternalSubscriptionHandler(InternalSubscriptionHandler sipSubscriptionHandler) {
        this.internalSubscriptionHandler = sipSubscriptionHandler;
    }

    public void removeInternalSubscription(String subscriber, String notifier, String eventPackage, String subscriptionId, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        SubscriptionControlSbb sbb = this.internalSubscriptionHandler.sbb;
        SubscriptionKey subscriptionKey = new SubscriptionKey("_", eventPackage, subscriptionId);
        Subscription subscription = dataSource.get(subscriptionKey);
        if (subscription == null) {
            sbb.getParentSbbCMP().unsubscribeError(subscriber, notifier, eventPackage, subscriptionId, 412);
            return;
        }
        ActivityContextInterface aci = sbb.getActivityContextNamingfacility().lookup(subscriptionKey.toString());
        if (aci == null) {
            logger.error((Object)("Failed to retrieve aci for internal subscription with key " + subscriptionKey));
            sbb.getParentSbbCMP().unsubscribeError(subscriber, notifier, eventPackage, subscriptionId, 500);
            return;
        }
        sbb.getParentSbbCMP().unsubscribeOk(subscriber, notifier, eventPackage, subscriptionId);
        if (subscription.getResourceList()) {
            this.internalSubscriptionHandler.sbb.getEventListSubscriptionHandler().removeSubscription(subscription);
        }
        this.removeInternalSubscription(aci, subscription, dataSource, childSbb);
    }

    public void removeInternalSubscription(ActivityContextInterface aci, Subscription subscription, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        this.internalSubscriptionHandler.sbb.getTimerFacility().cancelTimer(subscription.getTimerID());
        if (subscription.getStatus() != Subscription.Status.terminated && subscription.getStatus() != Subscription.Status.waiting) {
            subscription.setStatus(Subscription.Status.terminated);
            subscription.setLastEvent(null);
        }
        if (subscription.getStatus() == Subscription.Status.terminated) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Status changed for " + subscription));
            }
            this.internalSubscriptionHandler.sbb.removeSubscriptionData(dataSource, subscription, null, aci, childSbb);
        } else if (subscription.getStatus() == Subscription.Status.waiting) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Status changed for " + subscription));
            }
            int defaultWaitingExpires = this.internalSubscriptionHandler.sbb.getConfiguration().getDefaultWaitingExpires();
            subscription.refresh(defaultWaitingExpires);
            this.internalSubscriptionHandler.sbb.setSubscriptionTimerAndPersistSubscription(subscription, defaultWaitingExpires + 1, aci);
        }
        this.internalSubscriptionHandler.sbb.getWInfoSubscriptionHandler().notifyWinfoSubscriptions(dataSource, subscription, childSbb);
        this.internalSubscriptionHandler.getInternalSubscriberNotificationHandler().notifyInternalSubscriber(subscription, aci, childSbb);
    }
}

