/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.eventlist;

import gov.nist.javax.sip.Utils;
import java.util.Set;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.rlscache.RLSService;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceActivity;
import org.mobicents.slee.sipevent.server.rlscache.events.RLSServicesRemovedEvent;
import org.mobicents.slee.sipevent.server.rlscache.events.RLSServicesUpdatedEvent;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriber;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriberParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;
import org.mobicents.slee.sipevent.server.subscription.eventlist.MultiPart;
import org.mobicents.slee.sipevent.server.subscription.eventlist.NotificationData;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.EntryType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventListSubscriberSbb
implements Sbb,
EventListSubscriber {
    private static final Logger logger = Logger.getLogger(EventListSubscriberSbb.class);
    private SbbContext sbbContext;

    public abstract void setRLSServiceACI(ActivityContextInterface var1);

    public abstract ActivityContextInterface getRLSServiceACI();

    public abstract void setNotificationData(NotificationData var1);

    public abstract NotificationData getNotificationData();

    public abstract void setSubscriptionKey(SubscriptionKey var1);

    @Override
    public abstract SubscriptionKey getSubscriptionKey();

    public abstract void setSubscriber(String var1);

    public abstract String getSubscriber();

    public abstract void setParentSbbCMP(EventListSubscriberParentSbbLocalObject var1);

    public abstract EventListSubscriberParentSbbLocalObject getParentSbbCMP();

    @Override
    public void setParentSbb(EventListSubscriberParentSbbLocalObject parentSbb) {
        this.setParentSbbCMP(parentSbb);
    }

    private String getVirtualSubscriptionId(SubscriptionKey originalSubscriptionKey, String virtualSubscriptionNotifier) {
        return originalSubscriptionKey.toString() + ":list:" + virtualSubscriptionNotifier;
    }

    @Override
    public void subscribe(Subscription subscription, RLSService rlsService, ActivityContextInterface rlsServiceAci) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("creating backend subscriptions for rls subscription " + subscription.getKey()));
        }
        this.setSubscriptionKey(subscription.getKey());
        this.setSubscriber(subscription.getSubscriber());
        this.setRLSServiceACI(rlsServiceAci);
        this.setNotificationData(new NotificationData(subscription.getNotifier().getUriWithParam(), subscription.getVersion(), rlsService, Utils.getInstance().generateTag(), Utils.getInstance().generateTag()));
        SubscriptionClientControlSbbLocalObject subscriptionClient = this.getSubscriptionClientControlSbb();
        for (EntryType entryType : rlsService.getEntries()) {
            subscriptionClient.subscribe(subscription.getSubscriber(), subscription.getSubscriberDisplayName(), entryType.getUri(), subscription.getKey().getEventPackage(), this.getVirtualSubscriptionId(subscription.getKey(), entryType.getUri()), subscription.getExpires(), null, null, null);
        }
    }

    public void onRLSServicesRemovedEvent(RLSServicesRemovedEvent event, ActivityContextInterface aci) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("rls service removed, terminating subscription " + this.getSubscriptionKey()));
        }
        this.unsubscribe(this.getSubscriber(), this.getSubscriptionKey(), this.getRLService());
    }

    public void onRLSServicesUpdatedEvent(RLSServicesUpdatedEvent event, ActivityContextInterface aci) {
        Subscription subscription = this.getParentSbbCMP().getSubscription(this.getSubscriptionKey());
        if (subscription != null) {
            this.resubscribe(subscription, this.getRLService(), event.getNewEntries(), event.getOldEntries(), event.getRemovedEntries());
        }
    }

    @Override
    public void resubscribe(Subscription subscription, RLSService rlsService) {
        this.resubscribe(subscription, rlsService, null, rlsService.getEntries(), null);
    }

    private void resubscribe(Subscription subscription, RLSService rlsService, Set<EntryType> newEntries, Set<EntryType> oldEntries, Set<EntryType> removedEntries) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("refreshing backend subscriptions for rls subscription " + subscription.getKey()));
        }
        subscription.incrementVersion();
        subscription.store();
        this.setNotificationData(new NotificationData(subscription.getNotifier().getUriWithParam(), subscription.getVersion(), rlsService, Utils.getInstance().generateTag(), Utils.getInstance().generateTag()));
        SubscriptionClientControlSbbLocalObject subscriptionClient = this.getSubscriptionClientControlSbb();
        if (removedEntries != null) {
            for (EntryType entryType : removedEntries) {
                subscriptionClient.unsubscribe(subscription.getSubscriber(), entryType.getUri(), subscription.getKey().getEventPackage(), this.getVirtualSubscriptionId(subscription.getKey(), entryType.getUri()));
            }
        }
        if (oldEntries != null) {
            for (EntryType entryType : oldEntries) {
                subscriptionClient.resubscribe(subscription.getSubscriber(), entryType.getUri(), subscription.getKey().getEventPackage(), this.getVirtualSubscriptionId(subscription.getKey(), entryType.getUri()), subscription.getExpires());
            }
        }
        if (newEntries != null) {
            for (EntryType entryType : newEntries) {
                subscriptionClient.subscribe(subscription.getSubscriber(), subscription.getSubscriberDisplayName(), entryType.getUri(), subscription.getKey().getEventPackage(), this.getVirtualSubscriptionId(subscription.getKey(), entryType.getUri()), subscription.getExpires(), null, null, null);
            }
        }
    }

    @Override
    public void unsubscribe(Subscription subscription, RLSService rlsService) {
        this.unsubscribe(subscription.getSubscriber(), subscription.getKey(), rlsService);
    }

    private void unsubscribe(String subscriber, SubscriptionKey key, RLSService rlsService) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removing backend subscriptions for rls subscription " + key));
        }
        for (ActivityContextInterface aci : this.sbbContext.getActivities()) {
            aci.detach(this.sbbContext.getSbbLocalObject());
        }
        this.setSubscriptionKey(null);
        if (rlsService != null) {
            SubscriptionClientControlSbbLocalObject subscriptionClient = this.getSubscriptionClientControlSbb();
            for (EntryType entryType : rlsService.getEntries()) {
                subscriptionClient.unsubscribe(subscriber, entryType.getUri(), key.getEventPackage(), this.getVirtualSubscriptionId(key, entryType.getUri()));
            }
        }
    }

    private RLSService getRLService() {
        ActivityContextInterface aci = this.getRLSServiceACI();
        if (aci == null) {
            return null;
        }
        RLSServiceActivity activity = (RLSServiceActivity)aci.getActivity();
        return activity.getRLSService();
    }

    private Subscription getSubscription(EventListSubscriberParentSbbLocalObject parentSbb, SubscriptionKey key, String subscriber) {
        Subscription subscription = parentSbb.getSubscription(key);
        if (subscription == null && this.getSubscriptionKey() != null) {
            logger.warn((Object)("Unable to get subscription " + key + " from parent sbb, it does not exists anymore! Removing all virtual subscriptions"));
            this.unsubscribe(subscriber, key, this.getRLService());
        }
        return subscription;
    }

    private NotificationData createPartialStateNotificationData(EventListSubscriberParentSbbLocalObject parentSbb, SubscriptionKey subscriptionKey, String subscriber, String notifier) {
        Subscription subscription = this.getSubscription(parentSbb, subscriptionKey, subscriber);
        if (subscription != null) {
            subscription.incrementVersion();
            subscription.store();
            RLSService rlsService = this.getRLService();
            if (rlsService != null) {
                for (EntryType entryType : rlsService.getEntries()) {
                    if (!entryType.getUri().equals(notifier)) continue;
                    return new NotificationData(subscription.getNotifier().getUriWithParam(), subscription.getVersion(), entryType, Utils.getInstance().generateTag(), Utils.getInstance().generateTag());
                }
            }
        }
        return null;
    }

    public void notifyEvent(String subscriber, String notifier, String eventPackage, String subscriptionId, Subscription.Event terminationReason, Subscription.Status status, String content, String contentType, String contentSubtype) {
        SubscriptionKey subscriptionKey = this.getSubscriptionKey();
        if (subscriptionKey != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("notification for rls subscription " + subscriptionKey + " from " + notifier));
            }
            EventListSubscriberParentSbbLocalObject parentSbb = this.getParentSbbCMP();
            NotificationData notificationData = this.getNotificationData();
            if (notificationData == null && (notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier)) == null) {
                return;
            }
            String id = notifier;
            String cid = content != null ? id : null;
            MultiPart multiPart = null;
            try {
                multiPart = notificationData.addNotificationData(notifier, cid, id, content, contentType, contentSubtype, status.toString(), terminationReason == null ? null : terminationReason.toString());
            }
            catch (IllegalStateException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
                if ((notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier)) == null) {
                    return;
                }
                multiPart = notificationData.addNotificationData(notifier, cid, id, content, contentType, contentSubtype, status.toString(), terminationReason == null ? null : terminationReason.toString());
            }
            if (multiPart != null) {
                this.setNotificationData(null);
                parentSbb.notifyEventListSubscriber(subscriptionKey, multiPart);
            }
        }
    }

    public void resubscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("resubscribeError: sid=" + subscriptionId + ", error=" + error));
        }
        EventListSubscriberParentSbbLocalObject parentSbb = this.getParentSbbCMP();
        SubscriptionKey key = this.getSubscriptionKey();
        switch (error) {
            case 412: {
                Subscription subscription = this.getSubscription(parentSbb, key, subscriber);
                if (subscription == null) break;
                this.getSubscriptionClientControlSbb().subscribe(subscriber, subscription.getSubscriberDisplayName(), notifier, eventPackage, subscriptionId, subscription.getExpires(), null, null, null);
                break;
            }
        }
    }

    public void resubscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("resubscribeOk: sid=" + subscriptionId));
        }
    }

    public void subscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("subscribeError: sid=" + subscriptionId + ", error=" + error));
        }
        EventListSubscriberParentSbbLocalObject parentSbb = this.getParentSbbCMP();
        SubscriptionKey subscriptionKey = this.getSubscriptionKey();
        NotificationData notificationData = this.getNotificationData();
        if (notificationData == null) {
            notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier);
        }
        String cid = notifier;
        MultiPart multiPart = null;
        switch (error) {
            case 403: {
                try {
                    multiPart = notificationData.addNotificationData(notifier, null, cid, null, null, null, "terminated", "rejected");
                }
                catch (IllegalStateException e) {
                    notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier);
                    multiPart = notificationData.addNotificationData(notifier, null, cid, null, null, null, "terminated", "rejected");
                }
                break;
            }
            default: {
                try {
                    multiPart = notificationData.notificationDataNotNeeded(notifier);
                    break;
                }
                catch (IllegalStateException e) {
                    notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier);
                    multiPart = notificationData.notificationDataNotNeeded(notifier);
                }
            }
        }
        if (multiPart != null) {
            this.setNotificationData(null);
            parentSbb.notifyEventListSubscriber(subscriptionKey, multiPart);
        }
    }

    public void subscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires, int responseCode) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("subscribeOk: sid=" + subscriptionId));
        }
    }

    public void unsubscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("unsubscribeError: sid=" + subscriptionId + ", error=" + error));
        }
    }

    public void unsubscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("unsubscribeOk: sid=" + subscriptionId));
        }
    }

    public abstract ChildRelation getSubscriptionClientControlChildRelation();

    public abstract SubscriptionClientControlSbbLocalObject getSubscriptionClientControlChildSbbCMP();

    public abstract void setSubscriptionClientControlChildSbbCMP(SubscriptionClientControlSbbLocalObject var1);

    public SubscriptionClientControlSbbLocalObject getSubscriptionClientControlSbb() {
        SubscriptionClientControlSbbLocalObject childSbb = this.getSubscriptionClientControlChildSbbCMP();
        if (childSbb == null) {
            try {
                childSbb = (SubscriptionClientControlSbbLocalObject)this.getSubscriptionClientControlChildRelation().create();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create child sbb", (Throwable)e);
                return null;
            }
            this.setSubscriptionClientControlChildSbbCMP(childSbb);
            childSbb.setParentSbb((SubscriptionClientControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        return childSbb;
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }
}

