/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.eventlist;

import java.util.ListIterator;
import javax.sip.RequestEvent;
import javax.sip.header.AcceptHeader;
import javax.sip.header.SupportedHeader;
import javax.slee.ActivityContextInterface;
import javax.slee.SbbLocalObject;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.rlscache.RLSService;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceActivity;
import org.mobicents.slee.sipevent.server.rlscache.RLSServicesCacheSbbInterface;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriberParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriberSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Notifier;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.eventlist.ServiceTypePackageVerifier;

public class EventListSubscriptionHandler {
    private static final Logger logger = Logger.getLogger(EventListSubscriptionHandler.class);
    private final SubscriptionControlSbb sbb;
    private static final ServiceTypePackageVerifier serviceTypePackageVerifier = new ServiceTypePackageVerifier();

    public EventListSubscriptionHandler(SubscriptionControlSbb sbb) {
        this.sbb = sbb;
    }

    public int validateSubscribeRequest(String subscriber, Notifier notifier, String eventPackage, RequestEvent event) {
        RLSService.Status rlsServiceStatus;
        boolean debugLog = logger.isDebugEnabled();
        RLSService rlsService = this.sbb.getRlsServicesCacheRASbbInterface().getRLSService(notifier.getUriWithParam());
        RLSService.Status status = rlsServiceStatus = rlsService != null ? rlsService.getStatus() : RLSService.Status.DOES_NOT_EXISTS;
        if (debugLog) {
            logger.debug((Object)(notifier.getUriWithParam() + " rlsService status retreived from rls services cache: " + rlsServiceStatus));
        }
        if (rlsServiceStatus != RLSService.Status.DOES_NOT_EXISTS && rlsServiceStatus != RLSService.Status.RESOLVING) {
            if (debugLog) {
                logger.debug((Object)(notifier + " is a resource list."));
            }
            if (event != null) {
                boolean isEventListSupported = false;
                ListIterator lit = event.getRequest().getHeaders("Supported");
                while (lit.hasNext()) {
                    SupportedHeader sh = (SupportedHeader)lit.next();
                    if (!sh.getOptionTag().equals("eventlist")) continue;
                    isEventListSupported = true;
                    break;
                }
                if (!isEventListSupported) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"SIP subscription request for resource list doesn't included Supported: eventlist header");
                    }
                    return 421;
                }
                boolean isMultipartAccepted = false;
                boolean isRlmiAccepted = false;
                ListIterator lit2 = event.getRequest().getHeaders("Accept");
                while (lit2.hasNext()) {
                    AcceptHeader ah = (AcceptHeader)lit2.next();
                    if (ah.allowsAllContentTypes() && ah.allowsAllContentSubTypes()) {
                        isMultipartAccepted = true;
                        isRlmiAccepted = true;
                        break;
                    }
                    if (!isMultipartAccepted && ah.getContentSubType().equals("related") && ah.getContentType().equals("multipart")) {
                        isMultipartAccepted = true;
                    }
                    if (isRlmiAccepted || !ah.getContentSubType().equals("rlmi+xml") || !ah.getContentType().equals("application")) continue;
                    isRlmiAccepted = true;
                }
                if (!isMultipartAccepted || !isRlmiAccepted) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"SIP subscription request for resource list doesn't included proper Accept headers");
                    }
                    return 406;
                }
            }
            if (rlsServiceStatus == RLSService.Status.BAD_GATEWAY) {
                return 502;
            }
            if (!serviceTypePackageVerifier.hasPackage(rlsService.getPackages(), eventPackage)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Resource list " + notifier + " doesn't applies to event package " + eventPackage));
                }
                return 489;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resource list " + notifier + " subscription request validated with sucess."));
            }
            return 200;
        }
        if (debugLog) {
            logger.debug((Object)(notifier + " is not a known resource list."));
        }
        return 404;
    }

    public boolean createSubscription(Subscription subscription) {
        RLSServicesCacheSbbInterface rlsServicesCacheSbbInterface = this.sbb.getRlsServicesCacheRASbbInterface();
        RLSServiceActivity activity = null;
        try {
            activity = rlsServicesCacheSbbInterface.getRLSServiceActivity(subscription.getNotifier().getUriWithParam());
        }
        catch (Throwable e) {
            logger.error((Object)("failed to get rls service activity " + subscription.getNotifier().getUriWithParam()), e);
            return false;
        }
        RLSService rlsService = activity.getRLSService();
        if (rlsService == null || rlsService.getStatus() != RLSService.Status.OK) {
            return false;
        }
        EventListSubscriberSbbLocalObject subscriptionChildSbb = null;
        ActivityContextInterface aci = null;
        try {
            subscriptionChildSbb = (EventListSubscriberSbbLocalObject)this.sbb.getEventListSubscriberChildRelation().create();
            subscriptionChildSbb.setParentSbb((EventListSubscriberParentSbbLocalObject)this.sbb.getSbbContext().getSbbLocalObject());
            aci = this.sbb.getRlsServicesCacheACIF().getActivityContextInterface(activity);
            aci.attach((SbbLocalObject)subscriptionChildSbb);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create child sbb", (Throwable)e);
            return false;
        }
        subscriptionChildSbb.subscribe(subscription, rlsService, aci);
        return true;
    }

    public void refreshSubscription(Subscription subscription) {
        EventListSubscriberSbbLocalObject childSbb = this.sbb.getEventListSubscriberSbb(subscription.getKey());
        if (childSbb != null) {
            childSbb.resubscribe(subscription, this.sbb.getRlsServicesCacheRASbbInterface().getRLSService(subscription.getNotifier().getUriWithParam()));
        } else {
            logger.warn((Object)"trying to refresh a event list subscription but child sbb not found");
        }
    }

    public void removeSubscription(Subscription subscription) {
        EventListSubscriberSbbLocalObject childSbb = this.sbb.getEventListSubscriberSbb(subscription.getKey());
        if (childSbb != null) {
            childSbb.unsubscribe(subscription, this.sbb.getRlsServicesCacheRASbbInterface().getRLSService(subscription.getNotifier().getUriWithParam()));
        } else {
            logger.warn((Object)"trying to unsubscribe a event list subscription but child sbb not found");
        }
    }
}

