/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.eventlist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.rlscache.RLSService;
import org.mobicents.slee.sipevent.server.subscription.eventlist.BodyPart;
import org.mobicents.slee.sipevent.server.subscription.eventlist.MultiPart;
import org.mobicents.slee.sipevent.server.subscription.eventlist.rlmi.List;
import org.mobicents.slee.sipevent.server.subscription.eventlist.rlmi.Name;
import org.mobicents.slee.sipevent.server.subscription.eventlist.rlmi.Resource;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.EntryType;

public class NotificationData
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final JAXBContext rlmiJaxbContext = NotificationData.initJAXBContext();
    private static final Logger logger = Logger.getLogger(NotificationData.class);
    private transient Set<String> urisLeft;
    private final EntryType[] entries;
    private final int version;
    private final String notifier;
    private transient Map<String, BodyPart> bodyParts = new HashMap<String, BodyPart>();
    private transient Map<String, Instance> instances = new HashMap<String, Instance>();
    private final boolean fullState;
    private final String rlmiCid;
    private final String multiPartBoundary;
    private final AtomicBoolean locked = new AtomicBoolean(false);
    private static final EntryType[] EMPTY_ENTRYTYPE_ARRAY = new EntryType[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final BodyPart[] EMPTY_BODYPART_ARRAY = new BodyPart[0];
    private static final Instance[] EMPTY_INSTANCE_ARRAY = new Instance[0];

    private static JAXBContext initJAXBContext() {
        try {
            return JAXBContext.newInstance((String)"org.mobicents.slee.sipevent.server.subscription.eventlist.rlmi");
        }
        catch (JAXBException e) {
            logger.error((Object)"failed to create jaxb context");
            return null;
        }
    }

    public NotificationData(String notifier, int version, RLSService rlsService, String rlmiCid, String multiPartBoundary) {
        this.version = version;
        this.notifier = notifier;
        this.fullState = true;
        this.rlmiCid = rlmiCid;
        this.multiPartBoundary = multiPartBoundary;
        this.entries = rlsService.getEntries().toArray(EMPTY_ENTRYTYPE_ARRAY);
        this.urisLeft = new HashSet<String>(this.entries.length);
        for (EntryType entryType : this.entries) {
            this.urisLeft.add(entryType.getUri());
        }
    }

    public NotificationData(String notifier, int version, EntryType entryType, String rlmiCid, String multiPartBoundary) {
        this.version = version;
        this.notifier = notifier;
        this.fullState = false;
        this.rlmiCid = rlmiCid;
        this.multiPartBoundary = multiPartBoundary;
        this.entries = new EntryType[]{entryType};
        this.urisLeft = new HashSet<String>(1);
        this.urisLeft.add(entryType.getUri());
    }

    public MultiPart addNotificationData(String uri, String cid, String instanceId, String content, String contentType, String contentSubType, String status, String reason) throws IllegalStateException {
        if (cid != null) {
            this.bodyParts.put(uri, new BodyPart(uri, "binary", cid, contentType, contentSubType, "UTF-8", content));
        }
        Instance instance = new Instance();
        instance.uri = uri;
        instance.id = instanceId;
        instance.cid = cid;
        instance.state = status;
        instance.reason = reason;
        this.instances.put(uri, instance);
        return this.notificationDataNotNeeded(uri);
    }

    public MultiPart notificationDataNotNeeded(String uri) throws IllegalStateException {
        if (this.urisLeft.remove(uri) && this.urisLeft.isEmpty()) {
            return this.buildMultipart();
        }
        return null;
    }

    private MultiPart buildMultipart() throws IllegalStateException {
        if (!this.locked.compareAndSet(false, true)) {
            throw new IllegalStateException();
        }
        List rlmiList = new List();
        rlmiList.setFullState(this.fullState);
        rlmiList.setVersion((long)this.version);
        rlmiList.setUri(this.notifier);
        for (EntryType entryType : this.entries) {
            Instance instance;
            Resource resource = new Resource();
            resource.setUri(entryType.getUri());
            EntryType.DisplayName displayName = entryType.getDisplayName();
            if (displayName != null) {
                Name name = new Name();
                name.setLang(displayName.getLang());
                name.setValue(displayName.getValue());
                resource.getName().add(name);
            }
            if ((instance = this.instances.get(entryType.getUri())) != null) {
                org.mobicents.slee.sipevent.server.subscription.eventlist.rlmi.Instance jaxbInstance = new org.mobicents.slee.sipevent.server.subscription.eventlist.rlmi.Instance();
                jaxbInstance.setId(instance.id);
                jaxbInstance.setCid(instance.cid);
                jaxbInstance.setState(instance.state);
                jaxbInstance.setReason(instance.reason);
                resource.getInstance().add(jaxbInstance);
            }
            rlmiList.getResource().add(resource);
        }
        String rlmiString = this.marshallRlmi(rlmiList);
        MultiPart multiPart = new MultiPart(this.multiPartBoundary, "application/rlmi+xml");
        multiPart.getBodyParts().add(new BodyPart(null, "binary", this.rlmiCid, "application", "rlmi+xml", "UTF-8", rlmiString));
        for (BodyPart bodyPart : this.bodyParts.values()) {
            multiPart.getBodyParts().add(bodyPart);
        }
        return multiPart;
    }

    private String marshallRlmi(List rlmiList) {
        StringWriter stringWriter = new StringWriter();
        String result = null;
        try {
            rlmiJaxbContext.createMarshaller().marshal((Object)rlmiList, (Writer)stringWriter);
            result = stringWriter.toString();
        }
        catch (Exception e) {
            logger.error((Object)"failed to marshall rlmi content", (Throwable)e);
        }
        try {
            stringWriter.close();
        }
        catch (Exception e) {
            logger.error((Object)"failed to close stringwriter used to marshall rlmi content", (Throwable)e);
        }
        return result;
    }

    public int hashCode() {
        return this.notifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            return ((NotificationData)obj).notifier.equals(this.notifier);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int arraySize = this.urisLeft.size();
        String[] stringArray = arraySize == 0 ? EMPTY_STRING_ARRAY : this.urisLeft.toArray(new String[arraySize]);
        stream.writeObject(stringArray);
        Collection<BodyPart> bodyPartCollection = this.bodyParts.values();
        arraySize = bodyPartCollection.size();
        BodyPart[] bodyPartArray = arraySize == 0 ? EMPTY_BODYPART_ARRAY : bodyPartCollection.toArray(new BodyPart[arraySize]);
        stream.writeObject(bodyPartArray);
        Collection<Instance> instanceCollection = this.instances.values();
        arraySize = instanceCollection.size();
        Instance[] instanceArray = arraySize == 0 ? EMPTY_INSTANCE_ARRAY : instanceCollection.toArray(new Instance[arraySize]);
        stream.writeObject(instanceArray);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        String[] stringArray = (String[])stream.readObject();
        this.urisLeft = stringArray.length == 0 ? Collections.emptySet() : new HashSet<String>();
        for (String s : stringArray) {
            this.urisLeft.add(s);
        }
        BodyPart[] bodyPartArray = (BodyPart[])stream.readObject();
        this.bodyParts = new HashMap<String, BodyPart>();
        for (BodyPart bodyPart : bodyPartArray) {
            this.bodyParts.put(bodyPart.getUri(), bodyPart);
        }
        Instance[] instanceArray = (Instance[])stream.readObject();
        this.instances = new HashMap<String, Instance>();
        for (Instance instance : instanceArray) {
            this.instances.put(instance.uri, instance);
        }
    }

    private static class Instance
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String uri;
        String id;
        String cid;
        String state;
        String reason;

        private Instance() {
        }
    }
}

