/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.sip;

import gov.nist.javax.sip.message.SIPRequest;
import javax.sip.Dialog;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.SbbLocalObject;
import net.java.slee.resource.sip.DialogActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Notifier;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;

public class NewSipSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private SipSubscriptionHandler sipSubscriptionHandler;

    public NewSipSubscriptionHandler(SipSubscriptionHandler sipSubscriptionHandler) {
        this.sipSubscriptionHandler = sipSubscriptionHandler;
    }

    public void newSipSubscription(RequestEvent event, ActivityContextInterface aci, String eventPackage, String eventId, int expires, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        Dialog dialog;
        Address fromAddress = ((FromHeader)event.getRequest().getHeader("From")).getAddress();
        String subscriber = fromAddress.getURI().toString();
        String subscriberDisplayName = fromAddress.getDisplayName();
        Notifier notifier = new Notifier(event.getRequest().getRequestURI().toString());
        String content = null;
        String contentType = null;
        String contentSubtype = null;
        ContentTypeHeader contentTypeHeader = (ContentTypeHeader)event.getRequest().getHeader("Content-Type");
        if (contentTypeHeader != null) {
            contentType = contentTypeHeader.getContentType();
            contentSubtype = contentTypeHeader.getContentSubType();
            content = new String(event.getRequest().getRawContent());
        }
        if ((dialog = event.getDialog()) == null) {
            try {
                dialog = this.sipSubscriptionHandler.sbb.getSipProvider().getNewDialog((Transaction)event.getServerTransaction());
            }
            catch (Exception e) {
                logger.error((Object)"Can't create dialog", (Throwable)e);
                try {
                    Response response = this.sipSubscriptionHandler.sbb.getMessageFactory().createResponse(500, event.getRequest());
                    response = this.sipSubscriptionHandler.addContactHeader(response);
                    event.getServerTransaction().sendResponse(response);
                }
                catch (Exception f) {
                    logger.error((Object)"Can't send RESPONSE", (Throwable)f);
                }
                return;
            }
        }
        String dialogId = dialog.getDialogId() != null ? dialog.getDialogId() : ((SIPRequest)event.getRequest()).getDialogId(true, dialog.getLocalTag());
        SubscriptionKey key = new SubscriptionKey(dialogId, eventPackage, eventId);
        if (this.sipSubscriptionHandler.sbb.getConfiguration().getEventListSupportOn()) {
            int rlsResponse = this.sipSubscriptionHandler.sbb.getEventListSubscriptionHandler().validateSubscribeRequest(subscriber, notifier, eventPackage, event);
            switch (rlsResponse) {
                case 404: {
                    this.authorizeNewSipSubscription(event, aci, subscriber, subscriberDisplayName, notifier, key, expires, content, contentType, contentSubtype, false, dataSource, childSbb);
                    break;
                }
                case 200: {
                    this.authorizeNewSipSubscription(event, aci, subscriber, subscriberDisplayName, notifier, key, expires, content, contentType, contentSubtype, true, dataSource, childSbb);
                    break;
                }
                default: {
                    try {
                        Response response = this.sipSubscriptionHandler.sbb.getMessageFactory().createResponse(rlsResponse, event.getRequest());
                        response = this.sipSubscriptionHandler.addContactHeader(response);
                        response.addHeader((Header)this.sipSubscriptionHandler.sbb.getHeaderFactory().createRequireHeader("eventlist"));
                        event.getServerTransaction().sendResponse(response);
                    }
                    catch (Exception f) {
                        logger.error((Object)"Can't send RESPONSE", (Throwable)f);
                    }
                    return;
                }
            }
        } else {
            this.authorizeNewSipSubscription(event, aci, subscriber, subscriberDisplayName, notifier, key, expires, content, contentType, contentSubtype, false, dataSource, childSbb);
        }
    }

    public void authorizeNewSipSubscription(RequestEvent event, ActivityContextInterface aci, String subscriber, String subscriberDisplayName, Notifier notifier, SubscriptionKey key, int expires, String content, String contentType, String contentSubtype, boolean eventList, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        if (key.getEventPackage().endsWith(".winfo")) {
            this.newSipSubscriptionAuthorization(event.getServerTransaction(), aci, subscriber, subscriberDisplayName, notifier, key, expires, subscriber.equals(notifier.getUri()) ? 200 : 403, eventList, dataSource, childSbb);
        } else if (notifier.isPresList() && subscriber.equals(notifier.getUri())) {
            this.newSipSubscriptionAuthorization(event.getServerTransaction(), aci, subscriber, subscriberDisplayName, notifier, key, expires, 200, eventList, dataSource, childSbb);
        } else {
            childSbb.isSubscriberAuthorized(subscriber, subscriberDisplayName, notifier, key, expires, content, contentType, contentSubtype, eventList, event.getServerTransaction());
        }
    }

    public void newSipSubscriptionAuthorization(ServerTransaction serverTransaction, ActivityContextInterface serverTransactionACI, String subscriber, String subscriberDisplayName, Notifier notifier, SubscriptionKey key, int expires, int responseCode, boolean eventList, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        DialogActivity dialog = (DialogActivity)serverTransaction.getDialog();
        ActivityContextInterface dialogAci = null;
        try {
            Response response = this.sipSubscriptionHandler.sbb.getMessageFactory().createResponse(responseCode, serverTransaction.getRequest());
            if (responseCode == 202 || responseCode == 200) {
                SbbLocalObject sbbLocalObject = this.sipSubscriptionHandler.sbb.getSbbContext().getSbbLocalObject();
                dialogAci = this.sipSubscriptionHandler.sbb.getSipActivityContextInterfaceFactory().getActivityContextInterface(dialog);
                dialogAci.attach(sbbLocalObject);
                if (serverTransactionACI != null) {
                    serverTransactionACI.detach(sbbLocalObject);
                }
            } else {
                response = this.sipSubscriptionHandler.addContactHeader(response);
                serverTransaction.sendResponse(response);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Subscription: subscriber=" + subscriber + ",notifier=" + notifier + ",eventPackage=" + key.getEventPackage() + " not authorized (" + responseCode + ")"));
                }
                return;
            }
            response = this.sipSubscriptionHandler.addContactHeader(response);
            response.addHeader((Header)this.sipSubscriptionHandler.sbb.getHeaderFactory().createExpiresHeader(expires));
            serverTransaction.sendResponse(response);
        }
        catch (Exception e) {
            logger.error((Object)"Can't send new subscription request's reponse", (Throwable)e);
            try {
                Response response = this.sipSubscriptionHandler.sbb.getMessageFactory().createResponse(500, serverTransaction.getRequest());
                response = this.sipSubscriptionHandler.addContactHeader(response);
                serverTransaction.sendResponse(response);
            }
            catch (Exception f) {
                logger.error((Object)"Can't send RESPONSE", (Throwable)f);
            }
            return;
        }
        Subscription.Status initialStatus = responseCode == 202 ? Subscription.Status.pending : Subscription.Status.active;
        Subscription subscription = new Subscription(key, subscriber, notifier, initialStatus, subscriberDisplayName, expires, eventList, dataSource);
        if (!eventList || responseCode == 202) {
            try {
                this.sipSubscriptionHandler.getSipSubscriberNotificationHandler().createAndSendNotify(dataSource, subscription, dialog, childSbb);
            }
            catch (Exception e) {
                logger.error((Object)"failed to notify subscriber", (Throwable)e);
            }
        }
        this.sipSubscriptionHandler.sbb.getWInfoSubscriptionHandler().notifyWinfoSubscriptions(dataSource, subscription, childSbb);
        try {
            this.sipSubscriptionHandler.sbb.getActivityContextNamingfacility().bind(dialogAci, key.toString());
        }
        catch (Exception e) {
            logger.error((Object)"failed to bind a name to dialog's aci", (Throwable)e);
        }
        this.sipSubscriptionHandler.sbb.setSubscriptionTimerAndPersistSubscription(subscription, expires + 1, dialogAci);
        if (eventList && responseCode == 200 && !this.sipSubscriptionHandler.sbb.getEventListSubscriptionHandler().createSubscription(subscription)) {
            this.sipSubscriptionHandler.getRemoveSipSubscriptionHandler().removeSipSubscription(dialogAci, subscription, dataSource, childSbb);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Created " + subscription));
        }
    }
}

