/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.sip;

import javax.sip.RequestEvent;
import javax.sip.header.Header;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import net.java.slee.resource.sip.DialogActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;

public class RefreshSipSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private SipSubscriptionHandler sipSubscriptionHandler;

    public RefreshSipSubscriptionHandler(SipSubscriptionHandler sipSubscriptionHandler) {
        this.sipSubscriptionHandler = sipSubscriptionHandler;
    }

    public void refreshSipSubscription(RequestEvent event, ActivityContextInterface aci, int expires, Subscription subscription, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        this.sipSubscriptionHandler.sbb.getTimerFacility().cancelTimer(subscription.getTimerID());
        subscription.refresh(expires);
        try {
            Response response = this.sipSubscriptionHandler.sbb.getMessageFactory().createResponse(200, event.getRequest());
            response = this.sipSubscriptionHandler.addContactHeader(response);
            response.addHeader((Header)this.sipSubscriptionHandler.sbb.getHeaderFactory().createExpiresHeader(expires));
            event.getServerTransaction().sendResponse(response);
        }
        catch (Exception e) {
            logger.error((Object)"Can't send RESPONSE", (Throwable)e);
        }
        if (!subscription.getResourceList()) {
            try {
                this.sipSubscriptionHandler.getSipSubscriberNotificationHandler().createAndSendNotify(dataSource, subscription, (DialogActivity)aci.getActivity(), childSbb);
            }
            catch (Exception e) {
                logger.error((Object)"failed to notify subscriber", (Throwable)e);
            }
        }
        this.sipSubscriptionHandler.sbb.setSubscriptionTimerAndPersistSubscription(subscription, expires + 1, aci);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Refreshed " + subscription + " for " + expires + " seconds"));
        }
        if (subscription.getResourceList()) {
            this.sipSubscriptionHandler.sbb.getEventListSubscriptionHandler().refreshSubscription(subscription);
        }
    }
}

