/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.sip;

import javax.sip.Dialog;
import javax.sip.ResponseEvent;
import javax.sip.header.EventHeader;
import javax.slee.ActivityContextInterface;
import net.java.slee.resource.sip.DialogActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;

public class RemoveSipSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private SipSubscriptionHandler sipSubscriptionHandler;

    public RemoveSipSubscriptionHandler(SipSubscriptionHandler sipSubscriptionHandler) {
        this.sipSubscriptionHandler = sipSubscriptionHandler;
    }

    public void removeSipSubscription(ActivityContextInterface aci, Subscription subscription, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        this.sipSubscriptionHandler.sbb.getTimerFacility().cancelTimer(subscription.getTimerID());
        if (subscription.getStatus() != Subscription.Status.terminated && subscription.getStatus() != Subscription.Status.waiting) {
            subscription.setStatus(Subscription.Status.terminated);
            subscription.setLastEvent(null);
        }
        DialogActivity dialog = (DialogActivity)aci.getActivity();
        this.sipSubscriptionHandler.sbb.getWInfoSubscriptionHandler().notifyWinfoSubscriptions(dataSource, subscription, childSbb);
        try {
            this.sipSubscriptionHandler.getSipSubscriberNotificationHandler().createAndSendNotify(dataSource, subscription, dialog, childSbb);
        }
        catch (Exception e) {
            logger.error((Object)"failed to notify subscriber", (Throwable)e);
        }
        if (subscription.getStatus() == Subscription.Status.terminated) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Status changed for " + subscription));
            }
            this.sipSubscriptionHandler.sbb.removeSubscriptionData(dataSource, subscription, (Dialog)dialog, aci, childSbb);
        } else if (subscription.getStatus() == Subscription.Status.waiting) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Status changed for " + subscription));
            }
            int defaultWaitingExpires = this.sipSubscriptionHandler.sbb.getConfiguration().getDefaultWaitingExpires();
            subscription.refresh(defaultWaitingExpires);
            this.sipSubscriptionHandler.sbb.setSubscriptionTimerAndPersistSubscription(subscription, defaultWaitingExpires + 1, aci);
        }
    }

    public void removeSipSubscriptionOnNotifyError(SubscriptionControlDataSource dataSource, ResponseEvent event) {
        Subscription subscription;
        EventHeader eventHeader = (EventHeader)event.getResponse().getHeader("Event");
        Dialog dialog = event.getDialog();
        if (eventHeader != null && dialog != null && (subscription = dataSource.get(new SubscriptionKey(dialog.getDialogId(), eventHeader.getEventType(), eventHeader.getEventId()))) != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Removing " + subscription.getKey() + " data due to error on notify response."));
            }
            if (!subscription.getResourceList()) {
                this.sipSubscriptionHandler.sbb.getEventListSubscriptionHandler().removeSubscription(subscription);
            }
            this.sipSubscriptionHandler.sbb.removeSubscriptionData(dataSource, subscription, dialog, this.sipSubscriptionHandler.sbb.getActivityContextNamingfacility().lookup(subscription.getKey().toString()), this.sipSubscriptionHandler.sbb.getImplementedControlChildSbb());
        }
    }
}

