/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.sip;

import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.HeaderFactoryImpl;
import gov.nist.javax.sip.header.ims.PChargingVectorHeader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import javax.sip.Dialog;
import javax.sip.SipException;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.Header;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import net.java.slee.resource.sip.DialogActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;

public class SipSubscriberNotificationHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private SipSubscriptionHandler sipSubscriptionHandler;

    public SipSubscriberNotificationHandler(SipSubscriptionHandler sipSubscriptionHandler) {
        this.sipSubscriptionHandler = sipSubscriptionHandler;
    }

    public void notifySipSubscriber(Object content, ContentTypeHeader contentTypeHeader, Subscription subscription, ActivityContextInterface dialogACI, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        try {
            DialogActivity dialog = (DialogActivity)dialogACI.getActivity();
            Request notify = this.createNotify((Dialog)dialog, subscription);
            if (content != null) {
                notify = this.setNotifyContent(subscription, notify, content, contentTypeHeader, childSbb);
            }
            notify.addHeader((Header)this.addPChargingVectorHeader());
            dialog.sendRequest(notify);
        }
        catch (Exception e) {
            logger.error((Object)"failed to notify subscriber", (Throwable)e);
        }
    }

    public Request setNotifyContent(Subscription subscription, Request notify, Object content, ContentTypeHeader contentTypeHeader, ImplementedSubscriptionControlSbbLocalObject childSbb) throws JAXBException, ParseException, IOException {
        if (!subscription.getResourceList() && !subscription.getKey().isWInfoSubscription()) {
            Object filteredContent = childSbb.filterContentPerSubscriber(subscription.getSubscriber(), subscription.getNotifier(), subscription.getKey().getEventPackage(), content);
            StringWriter stringWriter = new StringWriter();
            childSbb.getMarshaller().marshal(filteredContent, (Writer)stringWriter);
            notify.setContent((Object)stringWriter.toString(), contentTypeHeader);
            stringWriter.close();
        } else if (content instanceof JAXBElement) {
            StringWriter stringWriter = new StringWriter();
            childSbb.getMarshaller().marshal(content, (Writer)stringWriter);
            notify.setContent((Object)stringWriter.toString(), contentTypeHeader);
            stringWriter.close();
        } else {
            notify.setContent(content, contentTypeHeader);
        }
        return notify;
    }

    public void createAndSendNotify(SubscriptionControlDataSource dataSource, Subscription subscription, DialogActivity dialog, ImplementedSubscriptionControlSbbLocalObject childSbb) throws TransactionDoesNotExistException, SipException, ParseException {
        Request notify = this.createNotify((Dialog)dialog, subscription);
        if (subscription.getStatus().equals((Object)Subscription.Status.active)) {
            if (subscription.getKey().getEventPackage().endsWith(".winfo")) {
                subscription.incrementVersion();
                subscription.store();
                notify.setContent((Object)this.sipSubscriptionHandler.sbb.getWInfoSubscriptionHandler().getFullWatcherInfoContent(dataSource, subscription), this.sipSubscriptionHandler.sbb.getWInfoSubscriptionHandler().getWatcherInfoContentHeader());
            } else {
                NotifyContent notifyContent = childSbb.getNotifyContent(subscription);
                if (notifyContent != null) {
                    try {
                        notify = this.setNotifyContent(subscription, notify, notifyContent.getContent(), notifyContent.getContentTypeHeader(), childSbb);
                    }
                    catch (Exception e) {
                        logger.error((Object)"failed to set notify content", (Throwable)e);
                    }
                }
            }
        }
        notify.addHeader((Header)this.addPChargingVectorHeader());
        dialog.sendRequest(notify);
    }

    public Request createNotify(Dialog dialog, Subscription subscription) {
        Request notify = null;
        try {
            notify = dialog.createRequest("NOTIFY");
            EventHeader eventHeader = this.sipSubscriptionHandler.sbb.getHeaderFactory().createEventHeader(subscription.getKey().getEventPackage());
            if (subscription.getKey().getEventId() != null) {
                eventHeader.setEventId(subscription.getKey().getEventId());
            }
            notify.setHeader((Header)eventHeader);
            notify.setHeader((Header)this.sipSubscriptionHandler.sbb.getHeaderFactory().createMaxForwardsHeader(this.sipSubscriptionHandler.sbb.getConfiguration().getMaxForwards()));
            SubscriptionStateHeader ssh = null;
            if (subscription.getStatus().equals((Object)Subscription.Status.active) || subscription.getStatus().equals((Object)Subscription.Status.pending)) {
                ssh = this.sipSubscriptionHandler.sbb.getHeaderFactory().createSubscriptionStateHeader(subscription.getStatus().toString());
                ssh.setExpires(subscription.getRemainingExpires());
            } else if (subscription.getStatus().equals((Object)Subscription.Status.waiting) || subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
                ssh = this.sipSubscriptionHandler.sbb.getHeaderFactory().createSubscriptionStateHeader("terminated");
                if (subscription.getLastEvent() != null) {
                    ssh.setReasonCode(subscription.getLastEvent().toString());
                }
            }
            notify.addHeader((Header)ssh);
            if (subscription.getResourceList()) {
                notify.addHeader((Header)this.sipSubscriptionHandler.sbb.getHeaderFactory().createRequireHeader("eventlist"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"unable to fill notify headers", (Throwable)e);
        }
        return notify;
    }

    private PChargingVectorHeader addPChargingVectorHeader() throws ParseException {
        HeaderFactoryImpl extensions = new HeaderFactoryImpl();
        PChargingVectorHeader pcv = extensions.createChargingVectorHeader(Utils.getInstance().generateBranchId() + System.currentTimeMillis());
        pcv.setOriginatingIOI(this.sipSubscriptionHandler.sbb.getConfiguration().getPChargingVectorHeaderTerminatingIOI());
        return pcv;
    }
}

