/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.winfo;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.List;
import javax.sip.header.ContentTypeHeader;
import javax.slee.ActivityContextInterface;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.WInfoNotifyEvent;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;
import org.mobicents.slee.sipevent.server.subscription.winfo.pojo.Watcher;
import org.mobicents.slee.sipevent.server.subscription.winfo.pojo.WatcherList;
import org.mobicents.slee.sipevent.server.subscription.winfo.pojo.Watcherinfo;

public class WInfoSubscriptionHandler {
    private static Logger logger = Logger.getLogger(SubscriptionControlSbb.class);
    private SubscriptionControlSbb sbb;
    private static final JAXBContext winfoJAXBContext = WInfoSubscriptionHandler.initWInfoJAXBContext();

    public WInfoSubscriptionHandler(SubscriptionControlSbb sbb) {
        this.sbb = sbb;
    }

    public void notifyWinfoSubscriptions(SubscriptionControlDataSource dataSource, Subscription subscription, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        if (!subscription.getKey().isWInfoSubscription()) {
            for (Subscription winfoSubscription : dataSource.getSubscriptionsByNotifierAndEventPackage(subscription.getNotifier().getUri(), subscription.getKey().getEventPackage() + ".winfo")) {
                if (winfoSubscription.getStatus() != Subscription.Status.active) continue;
                try {
                    ActivityContextInterface winfoAci = this.sbb.getActivityContextNamingfacility().lookup(winfoSubscription.getKey().toString());
                    if (winfoAci != null) {
                        this.sbb.fireWInfoNotifyEvent(new WInfoNotifyEvent(winfoSubscription.getKey(), subscription.getKey(), this.createWInfoWatcher(subscription)), winfoAci, null);
                        continue;
                    }
                    logger.warn((Object)("Unable to find subscription aci to notify subscription " + winfoSubscription.getKey() + ". Removing subscription data"));
                    this.sbb.removeSubscriptionData(dataSource, winfoSubscription, null, null, childSbb);
                }
                catch (Exception e) {
                    logger.error((Object)"failed to notify winfo subscriber", (Throwable)e);
                }
            }
        }
    }

    private static JAXBContext initWInfoJAXBContext() {
        try {
            return JAXBContext.newInstance((String)"org.mobicents.slee.sipevent.server.subscription.winfo.pojo");
        }
        catch (JAXBException e) {
            logger.error((Object)"failed to create winfo jaxb context");
            return null;
        }
    }

    private Marshaller getWInfoMarshaller() {
        try {
            return winfoJAXBContext.createMarshaller();
        }
        catch (JAXBException e) {
            logger.error((Object)"failed to create winfo unmarshaller", (Throwable)e);
            return null;
        }
    }

    private Watcher createWInfoWatcher(Subscription subscription) {
        Watcher watcher = new Watcher();
        watcher.setId(String.valueOf(subscription.hashCode()));
        watcher.setStatus(subscription.getStatus().toString());
        watcher.setDurationSubscribed(BigInteger.valueOf(subscription.getSubscriptionDuration()));
        if (subscription.getLastEvent() != null) {
            watcher.setEvent(subscription.getLastEvent().toString());
        }
        if (subscription.getSubscriberDisplayName() != null) {
            watcher.setDisplayName(subscription.getSubscriberDisplayName());
        }
        if (!subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
            watcher.setExpiration(BigInteger.valueOf(subscription.getRemainingExpires()));
        }
        watcher.setValue(subscription.getSubscriber());
        return watcher;
    }

    private String marshallWInfo(Watcherinfo watcherinfo) {
        String result = null;
        StringWriter stringWriter = new StringWriter();
        try {
            Marshaller marshaller = this.getWInfoMarshaller();
            marshaller.marshal((Object)watcherinfo, (Writer)stringWriter);
            result = stringWriter.toString();
            stringWriter.close();
        }
        catch (Exception e) {
            logger.error((Object)"failed to marshall winfo", (Throwable)e);
            try {
                stringWriter.close();
            }
            catch (Exception f) {
                logger.error((Object)"failed to close winfo string writer", (Throwable)f);
            }
        }
        return result;
    }

    public String getPartialWatcherInfoContent(Subscription winfoSubscription, SubscriptionKey watcherSubscriptionKey, Watcher watcher) {
        Watcherinfo watcherinfo = new Watcherinfo();
        watcherinfo.setVersion(BigInteger.valueOf(winfoSubscription.getVersion()));
        watcherinfo.setState("partial");
        WatcherList watcherList = new WatcherList();
        watcherList.setResource(winfoSubscription.getNotifier().getUri());
        watcherList.setPackage(watcherSubscriptionKey.getEventPackage());
        watcherList.getWatcher().add(watcher);
        watcherinfo.getWatcherList().add(watcherList);
        return this.marshallWInfo(watcherinfo);
    }

    public String getFullWatcherInfoContent(SubscriptionControlDataSource dataSource, Subscription winfoSubscription) {
        Watcherinfo watcherinfo = new Watcherinfo();
        watcherinfo.setVersion(BigInteger.valueOf(winfoSubscription.getVersion()));
        watcherinfo.setState("full");
        WatcherList watcherList = new WatcherList();
        watcherList.setResource(winfoSubscription.getNotifier().getUri());
        String winfoEventPackage = winfoSubscription.getKey().getEventPackage();
        String eventPackage = winfoEventPackage.substring(0, winfoEventPackage.indexOf(".winfo"));
        watcherList.setPackage(eventPackage);
        List watchers = watcherList.getWatcher();
        for (Subscription subscription : dataSource.getSubscriptionsByNotifierAndEventPackage(winfoSubscription.getNotifier().getUri(), eventPackage)) {
            watchers.add(this.createWInfoWatcher(subscription));
        }
        watcherinfo.getWatcherList().add(watcherList);
        return this.marshallWInfo(watcherinfo);
    }

    public ContentTypeHeader getWatcherInfoContentHeader() {
        try {
            return this.sbb.getHeaderFactory().createContentTypeHeader("application", "watcherinfo+xml");
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

