/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.internal;

import java.io.IOException;
import javax.sip.header.ContentTypeHeader;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivity;
import javax.xml.transform.TransformerException;
import org.mobicents.slee.sipevent.server.internal.InternalSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.openxdm.xcap.common.xml.TextWriter;
import org.w3c.dom.Node;

public class InternalSubscriberNotificationHandler {
    private static Tracer tracer;
    private InternalSubscriptionHandler internalSubscriptionHandler;

    public InternalSubscriberNotificationHandler(InternalSubscriptionHandler sbb) {
        this.internalSubscriptionHandler = sbb;
        if (tracer == null) {
            tracer = this.internalSubscriptionHandler.sbb.getSbbContext().getTracer(this.getClass().getSimpleName());
        }
    }

    public void notifyInternalSubscriber(Subscription subscription, ActivityContextInterface aci, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        NotifyContent notifyContent = null;
        if (subscription.getStatus().equals((Object)Subscription.Status.active)) {
            notifyContent = childSbb.getNotifyContent(subscription);
        }
        this.notifyInternalSubscriber(subscription, notifyContent, aci, childSbb, false, false);
    }

    private void notifyInternalSubscriber(Subscription subscription, String content, ContentTypeHeader contentTypeHeader, ActivityContextInterface aci) throws IOException {
        SubscriptionClientControlParentSbbLocalObject parent;
        Subscription.Status status;
        String contentType = null;
        String contentSubtype = null;
        if (contentTypeHeader != null) {
            contentType = contentTypeHeader.getContentType();
            contentSubtype = contentTypeHeader.getContentSubType();
        }
        if ((status = subscription.getStatus()) == Subscription.Status.waiting) {
            status = Subscription.Status.terminated;
        }
        Subscription.Event lastEvent = null;
        if (status == Subscription.Status.terminated) {
            lastEvent = subscription.getLastEvent();
            ((NullActivity)aci.getActivity()).endActivity();
        }
        if ((parent = this.internalSubscriptionHandler.sbb.getParentSbb()) != null) {
            parent.notifyEvent(subscription.getSubscriber(), subscription.getNotifier().getUriWithParam(), subscription.getKey().getEventPackage(), subscription.getKey().getEventId(), lastEvent, status, content, contentType, contentSubtype);
        }
    }

    public void notifyInternalSubscriber(Subscription subscription, NotifyContent notifyContent, ActivityContextInterface aci, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        boolean doNotifierFiltering = !subscription.isResourceList() && !subscription.isWInfoSubscription();
        this.notifyInternalSubscriber(subscription, notifyContent, aci, childSbb, doNotifierFiltering, true);
    }

    private void notifyInternalSubscriber(Subscription subscription, NotifyContent notifyContent, ActivityContextInterface aci, ImplementedSubscriptionControlSbbLocalObject childSbb, boolean doNotifierFiltering, boolean isStateChange) {
        try {
            Object content = null;
            ContentTypeHeader contentTypeHeader = null;
            if (notifyContent != null) {
                content = notifyContent.getContent();
                contentTypeHeader = notifyContent.getContentTypeHeader();
            }
            String newState = null;
            if (doNotifierFiltering) {
                content = childSbb.filterContentPerSubscriber(subscription, content);
            }
            if (content instanceof Node) {
                try {
                    newState = TextWriter.toString((Node)((Node)content));
                }
                catch (TransformerException e) {
                    throw new IOException("failed to marshall DOM content", e);
                }
            } else {
                newState = (String)content;
            }
            if (newState == null && isStateChange) {
                return;
            }
            this.notifyInternalSubscriber(subscription, newState, contentTypeHeader, aci);
        }
        catch (Exception e) {
            tracer.severe("failed to notify internal subscriber", (Throwable)e);
        }
    }
}

