/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.internal;

import javax.slee.ActivityContextInterface;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivity;
import org.mobicents.slee.sipevent.server.internal.InternalSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Notifier;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;

public class NewInternalSubscriptionHandler {
    private static Tracer tracer;
    private InternalSubscriptionHandler internalSubscriptionHandler;

    public NewInternalSubscriptionHandler(InternalSubscriptionHandler internalSubscriptionHandler) {
        this.internalSubscriptionHandler = internalSubscriptionHandler;
        if (tracer == null) {
            tracer = internalSubscriptionHandler.sbb.getSbbContext().getTracer(this.getClass().getSimpleName());
        }
    }

    public void newInternalSubscription(String subscriber, String subscriberDisplayName, Notifier notifier, String eventPackage, String subscriptionId, int expires, String content, String contentType, String contentSubtype, boolean eventList, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        SubscriptionControlSbb sbb;
        if (tracer.isFineEnabled()) {
            tracer.fine("newInternalSubscription()");
        }
        if (expires >= (sbb = this.internalSubscriptionHandler.sbb).getConfiguration().getMinExpires()) {
            if (expires > sbb.getConfiguration().getMaxExpires()) {
                expires = sbb.getConfiguration().getMaxExpires();
            }
        } else {
            sbb.getParentSbb().subscribeError(subscriber, notifier.getUri(), eventPackage, subscriptionId, 423);
            return;
        }
        SubscriptionKey key = new SubscriptionKey("_", eventPackage, subscriptionId);
        Subscription subscription = dataSource.get(key);
        if (subscription != null) {
            sbb.getParentSbb().subscribeError(subscriber, notifier.getUri(), eventPackage, subscriptionId, 412);
        } else {
            this.authorizeNewInternalSubscription(subscriber, subscriberDisplayName, notifier, key, expires, content, contentType, contentSubtype, eventList, dataSource, childSbb);
        }
    }

    private void authorizeNewInternalSubscription(String subscriber, String subscriberDisplayName, Notifier notifier, SubscriptionKey key, int expires, String content, String contentType, String contentSubtype, boolean eventList, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        if (key.getEventPackage().endsWith(".winfo")) {
            this.newInternalSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, subscriber.equals(notifier.getUri()) ? 200 : 403, eventList, dataSource, childSbb);
        } else if (notifier.isPresList() && subscriber.equals(notifier.getUri())) {
            this.newInternalSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, 200, eventList, dataSource, childSbb);
        } else {
            childSbb.isSubscriberAuthorized(subscriber, subscriberDisplayName, notifier, key, expires, content, contentType, contentSubtype, eventList, null);
        }
    }

    public void newInternalSubscriptionAuthorization(String subscriber, String subscriberDisplayName, Notifier notifier, SubscriptionKey subscriptionKey, int expires, int responseCode, boolean eventList, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        if (tracer.isFineEnabled()) {
            tracer.fine("newInternalSubscriptionAuthorization()");
        }
        SubscriptionControlSbb sbb = this.internalSubscriptionHandler.sbb;
        ActivityContextInterface aci = null;
        if (responseCode == 202 || responseCode == 200) {
            NullActivity nullActivity = sbb.getNullActivityFactory().createNullActivity();
            try {
                aci = sbb.getNullACIFactory().getActivityContextInterface(nullActivity);
                sbb.getActivityContextNamingfacility().bind(aci, subscriptionKey.toString());
            }
            catch (Exception e) {
                tracer.severe("Failed to create internal subscription aci", (Throwable)e);
                sbb.getParentSbb().subscribeError(subscriber, notifier.getUri(), subscriptionKey.getEventPackage(), subscriptionKey.getEventId(), 500);
                return;
            }
        } else {
            sbb.getParentSbb().subscribeError(subscriber, notifier.getUri(), subscriptionKey.getEventPackage(), subscriptionKey.getEventId(), responseCode);
            if (tracer.isInfoEnabled()) {
                tracer.info("Subscription: subscriber=" + subscriber + ",notifier=" + notifier + ",eventPackage=" + subscriptionKey.getEventPackage() + " not authorized (" + responseCode + ")");
            }
            return;
        }
        aci.attach(sbb.getSbbContext().getSbbLocalObject());
        sbb.getParentSbb().subscribeOk(subscriber, notifier.getUri(), subscriptionKey.getEventPackage(), subscriptionKey.getEventId(), expires, responseCode);
        Subscription.Status initialStatus = responseCode == 202 ? Subscription.Status.pending : Subscription.Status.active;
        Subscription subscription = new Subscription(subscriptionKey, subscriber, notifier, initialStatus, subscriberDisplayName, expires, eventList, dataSource);
        if (!eventList || responseCode == 202) {
            this.internalSubscriptionHandler.getInternalSubscriberNotificationHandler().notifyInternalSubscriber(subscription, aci, childSbb);
        }
        sbb.getWInfoSubscriptionHandler().notifyWinfoSubscriptions(dataSource, subscription, childSbb);
        sbb.setSubscriptionTimerAndPersistSubscription(subscription, expires + 1, aci);
        if (eventList && responseCode == 200 && !this.internalSubscriptionHandler.sbb.getEventListSubscriptionHandler().createSubscription(subscription)) {
            this.internalSubscriptionHandler.getRemoveInternalSubscriptionHandler().removeInternalSubscription(aci, subscription, dataSource, childSbb);
        }
        if (tracer.isInfoEnabled()) {
            tracer.info("Created " + subscription);
        }
    }
}

