/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.internal;

import javax.slee.ActivityContextInterface;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.sipevent.server.internal.InternalSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;

public class RefreshInternalSubscriptionHandler {
    private static Tracer tracer;
    private InternalSubscriptionHandler internalSubscriptionHandler;

    public RefreshInternalSubscriptionHandler(InternalSubscriptionHandler sipSubscriptionHandler) {
        this.internalSubscriptionHandler = sipSubscriptionHandler;
        if (tracer == null) {
            tracer = this.internalSubscriptionHandler.sbb.getSbbContext().getTracer(this.getClass().getSimpleName());
        }
    }

    public void refreshInternalSubscription(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        SubscriptionControlSbb sbb = this.internalSubscriptionHandler.sbb;
        SubscriptionKey subscriptionKey = new SubscriptionKey("_", eventPackage, subscriptionId);
        Subscription subscription = dataSource.get(subscriptionKey);
        if (subscription == null) {
            sbb.getParentSbb().resubscribeError(subscriber, notifier, eventPackage, subscriptionId, 412);
            return;
        }
        if (expires >= sbb.getConfiguration().getMinExpires()) {
            if (expires > sbb.getConfiguration().getMaxExpires()) {
                expires = sbb.getConfiguration().getMaxExpires();
            }
        } else {
            sbb.getParentSbb().resubscribeError(subscriber, notifier, eventPackage, subscriptionId, 423);
            return;
        }
        ActivityContextInterface aci = sbb.getActivityContextNamingfacility().lookup(subscriptionKey.toString());
        if (aci == null) {
            tracer.severe("Failed to retrieve aci for internal subscription with key " + subscriptionKey);
            sbb.getParentSbb().resubscribeError(subscriber, notifier, eventPackage, subscriptionId, 500);
            return;
        }
        this.internalSubscriptionHandler.sbb.getTimerFacility().cancelTimer(subscription.getTimerID());
        subscription.refresh(expires);
        this.internalSubscriptionHandler.sbb.getParentSbb().resubscribeOk(subscriber, notifier, eventPackage, subscriptionId, expires);
        if (!subscription.isResourceList()) {
            this.internalSubscriptionHandler.getInternalSubscriberNotificationHandler().notifyInternalSubscriber(subscription, aci, childSbb);
        }
        this.internalSubscriptionHandler.sbb.setSubscriptionTimerAndPersistSubscription(subscription, expires + 1, aci);
        if (tracer.isInfoEnabled()) {
            tracer.info("Refreshed " + subscription + " for " + expires + " seconds");
        }
        if (subscription.isResourceList()) {
            this.internalSubscriptionHandler.sbb.getEventListSubscriptionHandler().refreshSubscription(subscription);
        }
    }
}

