/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription;

import java.io.Serializable;
import java.text.ParseException;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sip.Dialog;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.address.AddressFactory;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.slee.ChildRelationExt;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.slee.sipevent.server.internal.InternalSubscriptionHandler;
import org.mobicents.slee.sipevent.server.rlscache.RLSServicesCacheActivityContextInterfaceFactory;
import org.mobicents.slee.sipevent.server.rlscache.RLSServicesCacheSbbInterface;
import org.mobicents.slee.sipevent.server.rlscache.events.RLSServicesAddedEvent;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sipevent.server.subscription.NotifyEvent;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControl;
import org.mobicents.slee.sipevent.server.subscription.TerminateSubscriptionEvent;
import org.mobicents.slee.sipevent.server.subscription.WInfoNotifyEvent;
import org.mobicents.slee.sipevent.server.subscription.data.Notifier;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;
import org.mobicents.slee.sipevent.server.subscription.eventlist.EventListSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.eventlist.MultiPart;
import org.mobicents.slee.sipevent.server.subscription.jmx.SubscriptionControlManagement;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.winfo.WInfoSubscriptionHandler;
import org.w3c.dom.Document;

public abstract class SubscriptionControlSbb
implements Sbb,
SubscriptionControl {
    private InternalSubscriptionHandler internalSubscriptionHandler;
    private SipSubscriptionHandler sipSubscriptionHandler;
    private WInfoSubscriptionHandler wInfoSubscriptionHandler;
    private EventListSubscriptionHandler eventListSubscriptionHandler;
    private RLSServicesCacheSbbInterface rlsServicesCacheRASbbInterface;
    private RLSServicesCacheActivityContextInterfaceFactory rlsServicesCacheACIF;
    private SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory;
    private SleeSipProvider sipProvider;
    private AddressFactory addressFactory;
    private MessageFactory messageFactory;
    private HeaderFactory headerFactory;
    private TimerFacility timerFacility;
    private ActivityContextNamingFacility activityContextNamingfacility;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private NullActivityFactory nullActivityFactory;
    private SbbContextExt sbbContext;
    private static Tracer tracer;

    public EventListSubscriptionHandler getEventListSubscriptionHandler() {
        return this.eventListSubscriptionHandler;
    }

    public SipSubscriptionHandler getSipSubscribeHandler() {
        return this.sipSubscriptionHandler;
    }

    public WInfoSubscriptionHandler getWInfoSubscriptionHandler() {
        return this.wInfoSubscriptionHandler;
    }

    public InternalSubscriptionHandler getInternalSubscriptionHandler() {
        return this.internalSubscriptionHandler;
    }

    public ActivityContextNamingFacility getActivityContextNamingfacility() {
        return this.activityContextNamingfacility;
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    public HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public NullActivityContextInterfaceFactory getNullACIFactory() {
        return this.nullACIFactory;
    }

    public NullActivityFactory getNullActivityFactory() {
        return this.nullActivityFactory;
    }

    public SbbContext getSbbContext() {
        return this.sbbContext;
    }

    public SipActivityContextInterfaceFactory getSipActivityContextInterfaceFactory() {
        return this.sipActivityContextInterfaceFactory;
    }

    public SleeSipProvider getSipProvider() {
        return this.sipProvider;
    }

    public TimerFacility getTimerFacility() {
        return this.timerFacility;
    }

    public RLSServicesCacheSbbInterface getRlsServicesCacheRASbbInterface() {
        return this.rlsServicesCacheRASbbInterface;
    }

    public RLSServicesCacheActivityContextInterfaceFactory getRlsServicesCacheACIF() {
        return this.rlsServicesCacheACIF;
    }

    public SubscriptionControlManagement getConfiguration() {
        return SubscriptionControlManagement.getInstance();
    }

    public SubscriptionClientControlParentSbbLocalObject getParentSbb() {
        return (SubscriptionClientControlParentSbbLocalObject)this.sbbContext.getSbbLocalObject().getParent();
    }

    public abstract ChildRelationExt getImplementedControlChildRelation();

    public ImplementedSubscriptionControlSbbLocalObject getImplementedControlChildSbb() {
        ChildRelationExt childRelation = this.getImplementedControlChildRelation();
        ImplementedSubscriptionControlSbbLocalObject child = (ImplementedSubscriptionControlSbbLocalObject)childRelation.get("0");
        if (child == null) {
            try {
                child = (ImplementedSubscriptionControlSbbLocalObject)childRelation.create("0");
            }
            catch (Throwable e) {
                tracer.severe("failed to create child sbb", e);
            }
        }
        return child;
    }

    public abstract ChildRelationExt getEventListSubscriberChildRelation();

    public void onRLSServicesAddedEvent(RLSServicesAddedEvent event, ActivityContextInterface aci) {
        aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
        String notifier = event.getUri();
        if (this.getConfiguration().getEventListSupportOn() && this.getImplementedControlChildSbb().acceptsEventList()) {
            if (tracer.isFineEnabled()) {
                tracer.fine("terminating rls service " + notifier + " subscriptions defined as single entities");
            }
            SubscriptionControlDataSource dataSource = this.getConfiguration().getDataSource();
            int index = notifier.indexOf(59);
            String notifierWithoutParams = null;
            notifierWithoutParams = index > 0 ? notifier.substring(0, index) : notifier;
            for (Subscription subscription : dataSource.getSubscriptionsByNotifier(notifierWithoutParams)) {
                ActivityContextInterface subscriptionAci;
                if (subscription.isResourceList() || (subscriptionAci = this.getActivityContextNamingfacility().lookup(subscription.getKey().toString())) == null) continue;
                this.fireTerminateSubscriptionEvent(new TerminateSubscriptionEvent(subscription.getKey()), subscriptionAci, null);
            }
        }
    }

    public void onTerminateSubscriptionEvent(TerminateSubscriptionEvent event, ActivityContextInterface aci) {
        SubscriptionControlDataSource dataSource;
        Subscription subscription;
        if (tracer.isFineEnabled()) {
            tracer.fine("terminating invalid rls service subscription " + event.getSubscriptionKey());
        }
        if ((subscription = (dataSource = this.getConfiguration().getDataSource()).get(event.getSubscriptionKey())) != null && subscription.getStatus() == Subscription.Status.active) {
            subscription.changeStatus(Subscription.Event.deactivated);
            try {
                if (subscription.getKey().isInternalSubscription()) {
                    this.internalSubscriptionHandler.getRemoveInternalSubscriptionHandler().removeInternalSubscription(aci, subscription, dataSource, this.getImplementedControlChildSbb());
                } else {
                    this.sipSubscriptionHandler.getRemoveSipSubscriptionHandler().removeSipSubscription(aci, subscription, dataSource, this.getImplementedControlChildSbb());
                }
            }
            catch (Exception e) {
                tracer.severe("failed to notify internal subscriber", (Throwable)e);
            }
        }
    }

    public void onSubscribeOutOfDialog(RequestEvent event, ActivityContextInterface aci) {
        this.sipSubscriptionHandler.processRequest(event, aci);
    }

    public void onSubscribeInDialog(RequestEvent event, ActivityContextInterface aci) {
        this.sipSubscriptionHandler.processRequest(event, aci);
    }

    public void onResponseClientErrorEvent(ResponseEvent event, ActivityContextInterface aci) {
        this.sipSubscriptionHandler.getRemoveSipSubscriptionHandler().removeSipSubscriptionOnNotifyError(this.getConfiguration().getDataSource(), event);
    }

    public void onResponseServerErrorEvent(ResponseEvent event, ActivityContextInterface aci) {
        this.sipSubscriptionHandler.getRemoveSipSubscriptionHandler().removeSipSubscriptionOnNotifyError(this.getConfiguration().getDataSource(), event);
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        Subscription subscription;
        Object activity = aci.getActivity();
        Dialog dialog = null;
        if (activity instanceof Dialog) {
            dialog = (Dialog)activity;
        }
        if ((subscription = this.getConfiguration().getDataSource().getFromTimerID((Serializable)event.getTimerID())) == null) {
            if (tracer.isInfoEnabled()) {
                tracer.info("Subscription for timer " + event.getTimerID() + " not found, ignoring event.");
            }
            return;
        }
        if (tracer.isInfoEnabled()) {
            tracer.info("Timer expired for " + subscription);
        }
        ImplementedSubscriptionControlSbbLocalObject childSbb = this.getImplementedControlChildSbb();
        SubscriptionControlDataSource dataSource = this.getConfiguration().getDataSource();
        if (subscription.getStatus().equals((Object)Subscription.Status.waiting)) {
            subscription.changeStatus(Subscription.Event.giveup);
            if (tracer.isInfoEnabled()) {
                tracer.info("Status changed for " + subscription);
            }
            this.getWInfoSubscriptionHandler().notifyWinfoSubscriptions(dataSource, subscription, childSbb);
            this.removeSubscriptionData(dataSource, subscription, dialog, aci, childSbb);
        } else {
            subscription.changeStatus(Subscription.Event.timeout);
            if (subscription.isResourceList()) {
                this.eventListSubscriptionHandler.removeSubscription(subscription);
            }
            if (dialog != null) {
                this.sipSubscriptionHandler.getRemoveSipSubscriptionHandler().removeSipSubscription(aci, subscription, dataSource, childSbb);
            } else {
                this.internalSubscriptionHandler.getRemoveInternalSubscriptionHandler().removeInternalSubscription(aci, subscription, dataSource, childSbb);
            }
        }
    }

    public void onNotifyEvent(NotifyEvent event, ActivityContextInterface aci) {
        SubscriptionControlDataSource dataSource = this.getConfiguration().getDataSource();
        Subscription subscription = dataSource.get(event.getSubscriptionKey());
        if (subscription == null) {
            if (tracer.isFineEnabled()) {
                tracer.fine("Unable to notify state change for " + event.getSubscriptionKey() + ", subscription not found");
            }
            return;
        }
        if (subscription.getStatus() != Subscription.Status.active) {
            if (tracer.isFineEnabled()) {
                tracer.fine("Unable to notify state change for " + event.getSubscriptionKey() + ", subscription not active");
            }
            return;
        }
        this.notifySubscriber(subscription, event.getNotifyContent(), aci);
    }

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        tracer.info("Mobicents SIP Event Subscription Control service activated.");
        this.getImplementedControlChildSbb();
        aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
    }

    private void notifySubscriber(Subscription subscription, NotifyContent notifyContent, ActivityContextInterface aci) {
        if (subscription.getKey().isInternalSubscription()) {
            this.internalSubscriptionHandler.getInternalSubscriberNotificationHandler().notifyInternalSubscriber(subscription, notifyContent, aci, this.getImplementedControlChildSbb());
        } else {
            this.sipSubscriptionHandler.getSipSubscriberNotificationHandler().notifySipSubscriber(notifyContent, subscription, aci, this.getImplementedControlChildSbb());
        }
    }

    public void onWInfoNotifyEvent(WInfoNotifyEvent event, ActivityContextInterface aci) {
        SubscriptionControlDataSource dataSource = this.getConfiguration().getDataSource();
        Subscription subscription = dataSource.get(event.getSubscriptionKey());
        if (subscription == null) {
            if (tracer.isFineEnabled()) {
                tracer.fine("Unable to notify state change for " + event.getSubscriptionKey() + ", subscription not found");
            }
            return;
        }
        if (subscription.getStatus() != Subscription.Status.active) {
            if (tracer.isFineEnabled()) {
                tracer.fine("Unable to notify state change for " + event.getSubscriptionKey() + ", subscription not active");
            }
            return;
        }
        Document content = this.wInfoSubscriptionHandler.getPartialWatcherInfoContent(subscription, event.getWatcherSubscriptionKey(), event.getWatcher());
        ContentTypeHeader contentTypeHeader = this.wInfoSubscriptionHandler.getWatcherInfoContentHeader();
        this.notifySubscriber(subscription, new NotifyContent((Object)content, contentTypeHeader, null), aci);
    }

    public void newSubscriptionAuthorization(String subscriber, String subscriberDisplayName, Notifier notifier, SubscriptionKey key, int expires, int responseCode, boolean eventList, ServerTransaction serverTransaction) {
        SubscriptionControlDataSource dataSource = this.getConfiguration().getDataSource();
        try {
            if (!key.isInternalSubscription()) {
                ActivityContextInterface serverTransactionACI = null;
                for (ActivityContextInterface aci : this.getSbbContext().getActivities()) {
                    Object activity = aci.getActivity();
                    if (!(activity instanceof ServerTransaction)) continue;
                    serverTransactionACI = aci;
                    break;
                }
                this.sipSubscriptionHandler.getNewSipSubscriptionHandler().newSipSubscriptionAuthorization(serverTransaction, serverTransactionACI, subscriber, subscriberDisplayName, notifier, key, expires, responseCode, eventList, dataSource, this.getImplementedControlChildSbb());
            } else {
                this.internalSubscriptionHandler.getNewInternalSubscriptionHandler().newInternalSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, responseCode, eventList, dataSource, this.getImplementedControlChildSbb());
            }
        }
        catch (Exception e) {
            tracer.severe("Error processing new subscription authorization", (Throwable)e);
            if (!key.isInternalSubscription()) {
                if (serverTransaction != null) {
                    try {
                        Response response = this.sipSubscriptionHandler.addContactHeader(this.messageFactory.createResponse(500, serverTransaction.getRequest()));
                        serverTransaction.sendResponse(response);
                        if (tracer.isFineEnabled()) {
                            tracer.fine("Response sent:\n" + response.toString());
                        }
                    }
                    catch (Exception f) {
                        tracer.severe("Can't send RESPONSE", (Throwable)f);
                    }
                }
            } else {
                this.getParentSbb().subscribeError(subscriber, notifier.getUriWithParam(), key.getEventPackage(), key.getEventId(), 500);
            }
            return;
        }
    }

    public void notifySubscribers(String notifier, String eventPackage, NotifyContent notifyContent) {
        SubscriptionControlDataSource dataSource = this.getConfiguration().getDataSource();
        ActivityContextInterface aci = null;
        for (Subscription subscription : dataSource.getSubscriptionsByNotifierAndEventPackage(notifier, eventPackage)) {
            if (!subscription.getStatus().equals((Object)Subscription.Status.active)) continue;
            aci = this.activityContextNamingfacility.lookup(subscription.getKey().toString());
            if (aci != null) {
                this.fireNotifyEvent(new NotifyEvent(subscription.getKey(), notifyContent), aci, null);
                continue;
            }
            if (!tracer.isFineEnabled()) continue;
            tracer.fine("Subscription aci not found, unable to fire notify event for " + subscription);
        }
    }

    public void notifySubscriber(SubscriptionKey key, NotifyContent notifyContent) {
        ActivityContextInterface aci = this.activityContextNamingfacility.lookup(key.toString());
        if (aci != null) {
            this.fireNotifyEvent(new NotifyEvent(key, notifyContent), aci, null);
        } else if (tracer.isFineEnabled()) {
            tracer.fine("Unable to notify subscriber, the aci was not found for " + key);
        }
    }

    public void authorizationChanged(String subscriber, Notifier notifier, String eventPackage, String eventId, int authorizationCode) {
        String dialogId;
        Subscription subscription;
        SubscriptionControlDataSource dataSource = this.getConfiguration().getDataSource();
        DialogActivity dialog = null;
        ActivityContextInterface subscriptionAci = null;
        for (ActivityContextInterface aci : this.sbbContext.getActivities()) {
            Object activity = aci.getActivity();
            if (activity instanceof DialogActivity) {
                subscriptionAci = aci;
                dialog = (DialogActivity)activity;
                break;
            }
            if (!(activity instanceof NullActivity)) continue;
            subscriptionAci = aci;
            break;
        }
        if ((subscription = dataSource.get(new SubscriptionKey(dialogId = dialog == null ? "_" : dialog.getDialogId(), eventPackage, eventId))) != null) {
            Subscription.Status oldStatus = subscription.getStatus();
            switch (authorizationCode) {
                case 403: {
                    subscription.changeStatus(Subscription.Event.rejected);
                    break;
                }
                case 202: {
                    if (!subscription.getStatus().equals((Object)Subscription.Status.active)) break;
                    subscription.setStatus(Subscription.Status.pending);
                    subscription.setLastEvent(null);
                    break;
                }
                case 200: {
                    subscription.changeStatus(Subscription.Event.approved);
                    break;
                }
                default: {
                    tracer.warning("Received authorization update with unknown auth code " + authorizationCode);
                    return;
                }
            }
            if (!oldStatus.equals((Object)subscription.getStatus())) {
                if (tracer.isInfoEnabled()) {
                    tracer.info("Status changed for " + subscription);
                }
                ImplementedSubscriptionControlSbbLocalObject childSbb = this.getImplementedControlChildSbb();
                if (subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
                    if (subscription.isResourceList()) {
                        this.eventListSubscriptionHandler.removeSubscription(subscription);
                    }
                    if (dialog == null) {
                        this.internalSubscriptionHandler.getRemoveInternalSubscriptionHandler().removeInternalSubscription(subscriptionAci, subscription, dataSource, childSbb);
                    } else {
                        this.sipSubscriptionHandler.getRemoveSipSubscriptionHandler().removeSipSubscription(subscriptionAci, subscription, dataSource, childSbb);
                    }
                } else {
                    boolean notifySubscriber = true;
                    if (subscription.isResourceList() && subscription.getStatus().equals((Object)Subscription.Status.active)) {
                        notifySubscriber = false;
                        if (!this.eventListSubscriptionHandler.createSubscription(subscription)) {
                            if (dialog == null) {
                                this.internalSubscriptionHandler.getRemoveInternalSubscriptionHandler().removeInternalSubscription(subscriptionAci, subscription, dataSource, childSbb);
                            } else {
                                this.sipSubscriptionHandler.getRemoveSipSubscriptionHandler().removeSipSubscription(subscriptionAci, subscription, dataSource, childSbb);
                            }
                        }
                    }
                    if (notifySubscriber) {
                        if (dialog == null) {
                            this.internalSubscriptionHandler.getInternalSubscriberNotificationHandler().notifyInternalSubscriber(subscription, subscriptionAci, childSbb);
                        } else {
                            try {
                                this.sipSubscriptionHandler.getSipSubscriberNotificationHandler().createAndSendNotify(dataSource, subscription, dialog, childSbb);
                            }
                            catch (Exception e) {
                                tracer.severe("failed to notify subscriber", (Throwable)e);
                            }
                        }
                        subscription.store();
                    }
                    this.wInfoSubscriptionHandler.notifyWinfoSubscriptions(dataSource, subscription, childSbb);
                    if (subscription.getStatus().equals((Object)Subscription.Status.waiting)) {
                        int defaultWaitingExpires = this.getConfiguration().getDefaultWaitingExpires();
                        subscription.refresh(defaultWaitingExpires);
                        this.setSubscriptionTimerAndPersistSubscription(subscription, defaultWaitingExpires + 1, subscriptionAci);
                    }
                }
            }
        }
    }

    public void notifyEventListSubscriber(SubscriptionKey key, MultiPart multiPart) {
        try {
            ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("multipart", "related");
            contentTypeHeader.setParameter("type", multiPart.getType());
            contentTypeHeader.setParameter("boundary", multiPart.getBoundary());
            this.notifySubscriber(key, new NotifyContent((Object)multiPart.toString(), contentTypeHeader, null));
        }
        catch (ParseException e) {
            tracer.severe("failed to create content type header for event list notification", (Throwable)e);
        }
    }

    public Subscription getSubscription(SubscriptionKey key) {
        return this.getConfiguration().getDataSource().get(key);
    }

    private void subscribe(String subscriber, String subscriberDisplayName, Notifier notifier, String eventPackage, String subscriptionId, int expires, String content, String contentType, String contentSubtype, boolean eventList) {
        this.getInternalSubscriptionHandler().getNewInternalSubscriptionHandler().newInternalSubscription(subscriber, subscriberDisplayName, notifier, eventPackage, subscriptionId, expires, content, contentType, contentSubtype, eventList, this.getConfiguration().getDataSource(), this.getImplementedControlChildSbb());
    }

    public void subscribe(String subscriber, String subscriberDisplayName, String notifierString, String eventPackage, String subscriptionId, int expires, String content, String contentType, String contentSubtype) {
        Notifier notifier = new Notifier(notifierString);
        if (this.getConfiguration().getEventListSupportOn() && this.getImplementedControlChildSbb().acceptsEventList()) {
            int rlsResponse = this.eventListSubscriptionHandler.validateSubscribeRequest(subscriber, notifier, eventPackage, null);
            switch (rlsResponse) {
                case 404: {
                    this.subscribe(subscriber, subscriberDisplayName, notifier, eventPackage, subscriptionId, expires, content, contentType, contentSubtype, false);
                    break;
                }
                case 200: {
                    this.subscribe(subscriber, subscriberDisplayName, notifier, eventPackage, subscriptionId, expires, content, contentType, contentSubtype, true);
                    break;
                }
                default: {
                    this.getParentSbb().subscribeError(subscriber, notifierString, eventPackage, subscriptionId, rlsResponse);
                    break;
                }
            }
        } else {
            this.subscribe(subscriber, subscriberDisplayName, notifier, eventPackage, subscriptionId, expires, content, contentType, contentSubtype, false);
        }
    }

    public void resubscribe(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires) {
        SubscriptionControlDataSource dataSource = this.getConfiguration().getDataSource();
        this.getInternalSubscriptionHandler().getRefreshInternalSubscriptionHandler().refreshInternalSubscription(subscriber, notifier, eventPackage, subscriptionId, expires, dataSource, this.getImplementedControlChildSbb());
    }

    public void unsubscribe(String subscriber, String notifier, String eventPackage, String subscriptionId) {
        this.getInternalSubscriptionHandler().getRemoveInternalSubscriptionHandler().removeInternalSubscription(subscriber, notifier, eventPackage, subscriptionId, this.getConfiguration().getDataSource(), this.getImplementedControlChildSbb());
    }

    public void setSubscriptionTimerAndPersistSubscription(Subscription subscription, long delay, ActivityContextInterface aci) {
        TimerOptions options = new TimerOptions();
        options.setPreserveMissed(TimerPreserveMissed.ALL);
        TimerID timerId = this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + delay * 1000L, 1L, 1, options);
        subscription.setTimerID(timerId);
        subscription.store();
    }

    public void removeSubscriptionData(SubscriptionControlDataSource dataSource, Subscription subscription, Dialog dialog, ActivityContextInterface aci, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        List subscriptionsInDialog;
        childSbb.removingSubscription(subscription);
        subscription.remove();
        try {
            this.getActivityContextNamingfacility().unbind(subscription.getKey().toString());
        }
        catch (Exception e) {
            tracer.severe("failed to unbind subscription aci name");
        }
        if (dialog != null && (subscriptionsInDialog = dataSource.getSubscriptionsByDialog(dialog.getDialogId())).size() == 0) {
            if (tracer.isInfoEnabled()) {
                tracer.info("No more subscriptions on dialog, deleting...");
            }
            aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
            dialog.delete();
        }
        if (tracer.isInfoEnabled()) {
            tracer.info("Removed data for " + subscription);
        }
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        if (tracer == null) {
            tracer = sbbContext.getTracer(this.getClass().getSimpleName());
        }
        try {
            Context context = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)context.lookup("slee/facilities/timer");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)context.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)context.lookup("slee/nullactivity/factory");
            this.sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory)context.lookup("slee/resources/jainsip/1.2/acifactory");
            this.sipProvider = (SleeSipProvider)context.lookup("slee/resources/jainsip/1.2/provider");
            this.addressFactory = this.sipProvider.getAddressFactory();
            this.headerFactory = this.sipProvider.getHeaderFactory();
            this.messageFactory = this.sipProvider.getMessageFactory();
            this.activityContextNamingfacility = (ActivityContextNamingFacility)context.lookup("slee/facilities/activitycontextnaming");
            this.rlsServicesCacheRASbbInterface = (RLSServicesCacheSbbInterface)context.lookup("slee/resources/sipevent/rlscache/1.0/sbbinterface");
            this.rlsServicesCacheACIF = (RLSServicesCacheActivityContextInterfaceFactory)context.lookup("slee/resources/sipevent/rlscache/1.0/acif");
        }
        catch (Exception e) {
            tracer.severe("Unable to retrieve factories, facilities & providers", (Throwable)e);
        }
        this.internalSubscriptionHandler = new InternalSubscriptionHandler(this);
        this.sipSubscriptionHandler = new SipSubscriptionHandler(this);
        this.wInfoSubscriptionHandler = new WInfoSubscriptionHandler(this);
        this.eventListSubscriptionHandler = new EventListSubscriptionHandler(this);
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
        this.internalSubscriptionHandler = null;
        this.sipSubscriptionHandler = null;
        this.wInfoSubscriptionHandler = null;
        this.eventListSubscriptionHandler = null;
    }

    public abstract void fireNotifyEvent(NotifyEvent var1, ActivityContextInterface var2, Address var3);

    public abstract void fireWInfoNotifyEvent(WInfoNotifyEvent var1, ActivityContextInterface var2, Address var3);

    public abstract void fireTerminateSubscriptionEvent(TerminateSubscriptionEvent var1, ActivityContextInterface var2, Address var3);
}

