/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.eventlist;

import gov.nist.javax.sip.Utils;
import java.util.Set;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.ChildRelationExt;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.slee.sipevent.server.rlscache.RLSService;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceActivity;
import org.mobicents.slee.sipevent.server.rlscache.events.RLSServicesRemovedEvent;
import org.mobicents.slee.sipevent.server.rlscache.events.RLSServicesUpdatedEvent;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriber;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriberParentSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionClientControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;
import org.mobicents.slee.sipevent.server.subscription.eventlist.MultiPart;
import org.mobicents.slee.sipevent.server.subscription.eventlist.NotificationData;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.EntryType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventListSubscriberSbb
implements Sbb,
EventListSubscriber {
    private static Tracer tracer;
    private SbbContextExt sbbContext;

    public abstract void setRLSServiceACI(ActivityContextInterface var1);

    public abstract ActivityContextInterface getRLSServiceACI();

    public abstract void setNotificationData(NotificationData var1);

    public abstract NotificationData getNotificationData();

    public abstract void setSubscriptionKey(SubscriptionKey var1);

    @Override
    public abstract SubscriptionKey getSubscriptionKey();

    public abstract void setSubscriber(String var1);

    public abstract String getSubscriber();

    private String getVirtualSubscriptionId(SubscriptionKey originalSubscriptionKey, String virtualSubscriptionNotifier) {
        return originalSubscriptionKey.toString() + ":list:" + virtualSubscriptionNotifier;
    }

    private EventListSubscriberParentSbbLocalObject getParentSbb() {
        return (EventListSubscriberParentSbbLocalObject)this.sbbContext.getSbbLocalObject().getParent();
    }

    @Override
    public void subscribe(Subscription subscription, RLSService rlsService, ActivityContextInterface rlsServiceAci) {
        if (tracer.isFineEnabled()) {
            tracer.fine("creating backend subscriptions for rls subscription " + subscription.getKey());
        }
        this.setSubscriptionKey(subscription.getKey());
        this.setSubscriber(subscription.getSubscriber());
        this.setRLSServiceACI(rlsServiceAci);
        this.setNotificationData(new NotificationData(subscription.getNotifier().getUriWithParam(), subscription.getVersion(), rlsService, Utils.getInstance().generateTag(), Utils.getInstance().generateTag()));
        SubscriptionClientControlSbbLocalObject subscriptionClient = null;
        try {
            subscriptionClient = (SubscriptionClientControlSbbLocalObject)this.getSubscriptionClientControlChildRelation().create("0");
        }
        catch (Exception e) {
            tracer.severe("failed to create child", (Throwable)e);
            return;
        }
        for (EntryType entryType : rlsService.getEntries()) {
            subscriptionClient.subscribe(subscription.getSubscriber(), subscription.getSubscriberDisplayName(), entryType.getUri(), subscription.getKey().getEventPackage(), this.getVirtualSubscriptionId(subscription.getKey(), entryType.getUri()), subscription.getExpires(), null, null, null);
        }
    }

    public void onRLSServicesRemovedEvent(RLSServicesRemovedEvent event, ActivityContextInterface aci) {
        if (tracer.isFineEnabled()) {
            tracer.fine("rls service removed, terminating subscription " + this.getSubscriptionKey());
        }
        this.unsubscribe(this.getSubscriber(), this.getSubscriptionKey(), this.getRLService());
    }

    public void onRLSServicesUpdatedEvent(RLSServicesUpdatedEvent event, ActivityContextInterface aci) {
        Subscription subscription = this.getParentSbb().getSubscription(this.getSubscriptionKey());
        if (subscription != null) {
            this.resubscribe(subscription, this.getRLService(), event.getNewEntries(), event.getOldEntries(), event.getRemovedEntries());
        }
    }

    @Override
    public void resubscribe(Subscription subscription, RLSService rlsService) {
        this.resubscribe(subscription, rlsService, null, rlsService.getEntries(), null);
    }

    private void resubscribe(Subscription subscription, RLSService rlsService, Set<EntryType> newEntries, Set<EntryType> oldEntries, Set<EntryType> removedEntries) {
        if (tracer.isFineEnabled()) {
            tracer.fine("refreshing backend subscriptions for rls subscription " + subscription.getKey());
        }
        subscription.incrementVersion();
        subscription.store();
        this.setNotificationData(new NotificationData(subscription.getNotifier().getUriWithParam(), subscription.getVersion(), rlsService, Utils.getInstance().generateTag(), Utils.getInstance().generateTag()));
        SubscriptionClientControlSbbLocalObject subscriptionClient = (SubscriptionClientControlSbbLocalObject)this.getSubscriptionClientControlChildRelation().get("0");
        if (removedEntries != null) {
            for (EntryType entryType : removedEntries) {
                subscriptionClient.unsubscribe(subscription.getSubscriber(), entryType.getUri(), subscription.getKey().getEventPackage(), this.getVirtualSubscriptionId(subscription.getKey(), entryType.getUri()));
            }
        }
        if (oldEntries != null) {
            for (EntryType entryType : oldEntries) {
                subscriptionClient.resubscribe(subscription.getSubscriber(), entryType.getUri(), subscription.getKey().getEventPackage(), this.getVirtualSubscriptionId(subscription.getKey(), entryType.getUri()), subscription.getExpires());
            }
        }
        if (newEntries != null) {
            for (EntryType entryType : newEntries) {
                subscriptionClient.subscribe(subscription.getSubscriber(), subscription.getSubscriberDisplayName(), entryType.getUri(), subscription.getKey().getEventPackage(), this.getVirtualSubscriptionId(subscription.getKey(), entryType.getUri()), subscription.getExpires(), null, null, null);
            }
        }
    }

    @Override
    public void unsubscribe(Subscription subscription, RLSService rlsService) {
        this.unsubscribe(subscription.getSubscriber(), subscription.getKey(), rlsService);
    }

    private void unsubscribe(String subscriber, SubscriptionKey key, RLSService rlsService) {
        if (tracer.isFineEnabled()) {
            tracer.fine("removing backend subscriptions for rls subscription " + key);
        }
        for (ActivityContextInterface aci : this.sbbContext.getActivities()) {
            aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
        }
        this.setSubscriptionKey(null);
        if (rlsService != null) {
            SubscriptionClientControlSbbLocalObject subscriptionClient = (SubscriptionClientControlSbbLocalObject)this.getSubscriptionClientControlChildRelation().get("0");
            for (EntryType entryType : rlsService.getEntries()) {
                subscriptionClient.unsubscribe(subscriber, entryType.getUri(), key.getEventPackage(), this.getVirtualSubscriptionId(key, entryType.getUri()));
            }
        }
    }

    private RLSService getRLService() {
        ActivityContextInterface aci = this.getRLSServiceACI();
        if (aci == null) {
            return null;
        }
        RLSServiceActivity activity = (RLSServiceActivity)aci.getActivity();
        return activity.getRLSService();
    }

    private Subscription getSubscription(EventListSubscriberParentSbbLocalObject parentSbb, SubscriptionKey key, String subscriber) {
        Subscription subscription = parentSbb.getSubscription(key);
        if (subscription == null && this.getSubscriptionKey() != null) {
            tracer.warning("Unable to get subscription " + key + " from parent sbb, it does not exists anymore! Removing all virtual subscriptions");
            this.unsubscribe(subscriber, key, this.getRLService());
        }
        return subscription;
    }

    private NotificationData createPartialStateNotificationData(EventListSubscriberParentSbbLocalObject parentSbb, SubscriptionKey subscriptionKey, String subscriber, String notifier) {
        Subscription subscription = this.getSubscription(parentSbb, subscriptionKey, subscriber);
        if (subscription != null) {
            subscription.incrementVersion();
            subscription.store();
            RLSService rlsService = this.getRLService();
            if (rlsService != null) {
                for (EntryType entryType : rlsService.getEntries()) {
                    if (!entryType.getUri().equals(notifier)) continue;
                    return new NotificationData(subscription.getNotifier().getUriWithParam(), subscription.getVersion(), entryType, Utils.getInstance().generateTag(), Utils.getInstance().generateTag());
                }
            }
        }
        return null;
    }

    public void notifyEvent(String subscriber, String notifier, String eventPackage, String subscriptionId, Subscription.Event terminationReason, Subscription.Status status, String content, String contentType, String contentSubtype) {
        SubscriptionKey subscriptionKey = this.getSubscriptionKey();
        if (subscriptionKey != null) {
            if (tracer.isFineEnabled()) {
                tracer.fine("notification for rls subscription " + subscriptionKey + " from " + notifier);
            }
            EventListSubscriberParentSbbLocalObject parentSbb = this.getParentSbb();
            NotificationData notificationData = this.getNotificationData();
            if (notificationData == null && (notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier)) == null) {
                return;
            }
            String id = notifier;
            String cid = content != null ? id : null;
            MultiPart multiPart = null;
            try {
                multiPart = notificationData.addNotificationData(notifier, cid, id, content, contentType, contentSubtype, status.toString(), terminationReason == null ? null : terminationReason.toString());
            }
            catch (IllegalStateException e) {
                if (tracer.isFineEnabled()) {
                    tracer.fine(e.getMessage(), (Throwable)e);
                }
                if ((notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier)) == null) {
                    return;
                }
                multiPart = notificationData.addNotificationData(notifier, cid, id, content, contentType, contentSubtype, status.toString(), terminationReason == null ? null : terminationReason.toString());
            }
            if (multiPart != null) {
                this.setNotificationData(null);
                parentSbb.notifyEventListSubscriber(subscriptionKey, multiPart);
            }
        }
    }

    public void resubscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        if (tracer.isFineEnabled()) {
            tracer.fine("resubscribeError: sid=" + subscriptionId + ", error=" + error);
        }
        EventListSubscriberParentSbbLocalObject parentSbb = this.getParentSbb();
        SubscriptionKey key = this.getSubscriptionKey();
        switch (error) {
            case 412: {
                Subscription subscription = this.getSubscription(parentSbb, key, subscriber);
                if (subscription == null) break;
                ((SubscriptionClientControlSbbLocalObject)this.getSubscriptionClientControlChildRelation().get("0")).subscribe(subscriber, subscription.getSubscriberDisplayName(), notifier, eventPackage, subscriptionId, subscription.getExpires(), null, null, null);
                break;
            }
        }
    }

    public void resubscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires) {
        if (tracer.isFineEnabled()) {
            tracer.fine("resubscribeOk: sid=" + subscriptionId);
        }
    }

    public void subscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        if (tracer.isFineEnabled()) {
            tracer.fine("subscribeError: sid=" + subscriptionId + ", error=" + error);
        }
        EventListSubscriberParentSbbLocalObject parentSbb = this.getParentSbb();
        SubscriptionKey subscriptionKey = this.getSubscriptionKey();
        NotificationData notificationData = this.getNotificationData();
        if (notificationData == null) {
            notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier);
        }
        String cid = notifier;
        MultiPart multiPart = null;
        switch (error) {
            case 403: {
                try {
                    multiPart = notificationData.addNotificationData(notifier, null, cid, null, null, null, "terminated", "rejected");
                }
                catch (IllegalStateException e) {
                    notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier);
                    multiPart = notificationData.addNotificationData(notifier, null, cid, null, null, null, "terminated", "rejected");
                }
                break;
            }
            default: {
                try {
                    multiPart = notificationData.notificationDataNotNeeded(notifier);
                    break;
                }
                catch (IllegalStateException e) {
                    notificationData = this.createPartialStateNotificationData(parentSbb, subscriptionKey, subscriber, notifier);
                    multiPart = notificationData.notificationDataNotNeeded(notifier);
                }
            }
        }
        if (multiPart != null) {
            this.setNotificationData(null);
            parentSbb.notifyEventListSubscriber(subscriptionKey, multiPart);
        }
    }

    public void subscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId, int expires, int responseCode) {
        if (tracer.isFineEnabled()) {
            tracer.fine("subscribeOk: sid=" + subscriptionId);
        }
    }

    public void unsubscribeError(String subscriber, String notifier, String eventPackage, String subscriptionId, int error) {
        if (tracer.isFineEnabled()) {
            tracer.fine("unsubscribeError: sid=" + subscriptionId + ", error=" + error);
        }
    }

    public void unsubscribeOk(String subscriber, String notifier, String eventPackage, String subscriptionId) {
        if (tracer.isFineEnabled()) {
            tracer.fine("unsubscribeOk: sid=" + subscriptionId);
        }
    }

    public abstract ChildRelationExt getSubscriptionClientControlChildRelation();

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        if (tracer == null) {
            tracer = sbbContext.getTracer(this.getClass().getSimpleName());
        }
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }
}

