/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.eventlist;

import java.util.ListIterator;
import javax.sip.RequestEvent;
import javax.sip.header.AcceptHeader;
import javax.sip.header.SupportedHeader;
import javax.slee.ActivityContextInterface;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.ChildRelationExt;
import org.mobicents.slee.sipevent.server.rlscache.RLSService;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceActivity;
import org.mobicents.slee.sipevent.server.rlscache.RLSServicesCacheSbbInterface;
import org.mobicents.slee.sipevent.server.subscription.EventListSubscriberSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Notifier;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.eventlist.ServiceTypePackageVerifier;

public class EventListSubscriptionHandler {
    private static Tracer tracer;
    private final SubscriptionControlSbb sbb;
    private static final ServiceTypePackageVerifier serviceTypePackageVerifier;

    public EventListSubscriptionHandler(SubscriptionControlSbb sbb) {
        this.sbb = sbb;
        if (tracer == null) {
            tracer = sbb.getSbbContext().getTracer(this.getClass().getSimpleName());
        }
    }

    public int validateSubscribeRequest(String subscriber, Notifier notifier, String eventPackage, RequestEvent event) {
        RLSService.Status rlsServiceStatus;
        boolean fineLog = tracer.isFineEnabled();
        RLSService rlsService = this.sbb.getRlsServicesCacheRASbbInterface().getRLSService(notifier.getUriWithParam());
        RLSService.Status status = rlsServiceStatus = rlsService != null ? rlsService.getStatus() : RLSService.Status.DOES_NOT_EXISTS;
        if (fineLog) {
            tracer.fine(notifier.getUriWithParam() + " rlsService status retreived from rls services cache: " + rlsServiceStatus);
        }
        if (rlsServiceStatus != RLSService.Status.DOES_NOT_EXISTS && rlsServiceStatus != RLSService.Status.RESOLVING) {
            if (fineLog) {
                tracer.fine(notifier + " is a resource list.");
            }
            if (event != null) {
                boolean isEventListSupported = false;
                ListIterator lit = event.getRequest().getHeaders("Supported");
                while (lit.hasNext()) {
                    SupportedHeader sh = (SupportedHeader)lit.next();
                    if (!sh.getOptionTag().equals("eventlist")) continue;
                    isEventListSupported = true;
                    break;
                }
                if (!isEventListSupported) {
                    if (tracer.isInfoEnabled()) {
                        tracer.info("SIP subscription request for resource list doesn't included Supported: eventlist header");
                    }
                    return 421;
                }
                boolean isMultipartAccepted = false;
                boolean isRlmiAccepted = false;
                ListIterator lit2 = event.getRequest().getHeaders("Accept");
                while (lit2.hasNext()) {
                    AcceptHeader ah = (AcceptHeader)lit2.next();
                    if (ah.allowsAllContentTypes() && ah.allowsAllContentSubTypes()) {
                        isMultipartAccepted = true;
                        isRlmiAccepted = true;
                        break;
                    }
                    if (!isMultipartAccepted && ah.getContentSubType().equals("related") && ah.getContentType().equals("multipart")) {
                        isMultipartAccepted = true;
                    }
                    if (isRlmiAccepted || !ah.getContentSubType().equals("rlmi+xml") || !ah.getContentType().equals("application")) continue;
                    isRlmiAccepted = true;
                }
                if (!isMultipartAccepted || !isRlmiAccepted) {
                    if (tracer.isInfoEnabled()) {
                        tracer.info("SIP subscription request for resource list doesn't included proper Accept headers");
                    }
                    return 406;
                }
            }
            if (rlsServiceStatus == RLSService.Status.BAD_GATEWAY) {
                return 502;
            }
            if (!serviceTypePackageVerifier.hasPackage(rlsService.getPackages(), eventPackage)) {
                if (tracer.isInfoEnabled()) {
                    tracer.info("Resource list " + notifier + " doesn't applies to event package " + eventPackage);
                }
                return 489;
            }
            if (tracer.isFineEnabled()) {
                tracer.fine("Resource list " + notifier + " subscription request validated with sucess.");
            }
            return 200;
        }
        if (fineLog) {
            tracer.fine(notifier + " is not a known resource list.");
        }
        return 404;
    }

    public boolean createSubscription(Subscription subscription) {
        RLSServicesCacheSbbInterface rlsServicesCacheSbbInterface = this.sbb.getRlsServicesCacheRASbbInterface();
        RLSServiceActivity activity = null;
        ActivityContextInterface aci = null;
        try {
            activity = rlsServicesCacheSbbInterface.getRLSServiceActivity(subscription.getNotifier().getUriWithParam());
            aci = this.sbb.getRlsServicesCacheACIF().getActivityContextInterface(activity);
        }
        catch (Throwable e) {
            tracer.severe("failed to get rls service activity " + subscription.getNotifier().getUriWithParam(), e);
            return false;
        }
        RLSService rlsService = activity.getRLSService();
        if (rlsService == null || rlsService.getStatus() != RLSService.Status.OK) {
            return false;
        }
        ChildRelationExt childRelationExt = this.sbb.getEventListSubscriberChildRelation();
        EventListSubscriberSbbLocalObject subscriptionChildSbb = null;
        try {
            subscriptionChildSbb = (EventListSubscriberSbbLocalObject)childRelationExt.create(subscription.getKey().toString());
        }
        catch (Exception e) {
            tracer.severe("failed to create event list subscriber", (Throwable)e);
            return false;
        }
        aci.attach((SbbLocalObject)subscriptionChildSbb);
        subscriptionChildSbb.subscribe(subscription, rlsService, aci);
        return true;
    }

    public void refreshSubscription(Subscription subscription) {
        EventListSubscriberSbbLocalObject childSbb = (EventListSubscriberSbbLocalObject)this.sbb.getEventListSubscriberChildRelation().get(subscription.getKey().toString());
        if (childSbb != null) {
            childSbb.resubscribe(subscription, this.sbb.getRlsServicesCacheRASbbInterface().getRLSService(subscription.getNotifier().getUriWithParam()));
        } else {
            tracer.warning("trying to refresh a event list subscription but child sbb not found");
        }
    }

    public void removeSubscription(Subscription subscription) {
        EventListSubscriberSbbLocalObject childSbb = (EventListSubscriberSbbLocalObject)this.sbb.getEventListSubscriberChildRelation().get(subscription.getKey().toString());
        if (childSbb != null) {
            childSbb.unsubscribe(subscription, this.sbb.getRlsServicesCacheRASbbInterface().getRLSService(subscription.getNotifier().getUriWithParam()));
        } else {
            tracer.warning("trying to unsubscribe a event list subscription but child sbb not found");
        }
    }

    static {
        serviceTypePackageVerifier = new ServiceTypePackageVerifier();
    }
}

