/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.sip;

import javax.sip.RequestEvent;
import javax.sip.header.Header;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.sip.DialogActivity;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;

public class RefreshSipSubscriptionHandler {
    private static Tracer tracer;
    private SipSubscriptionHandler sipSubscriptionHandler;

    public RefreshSipSubscriptionHandler(SipSubscriptionHandler sipSubscriptionHandler) {
        this.sipSubscriptionHandler = sipSubscriptionHandler;
        if (tracer == null) {
            tracer = sipSubscriptionHandler.sbb.getSbbContext().getTracer(this.getClass().getSimpleName());
        }
    }

    public void refreshSipSubscription(RequestEvent event, ActivityContextInterface aci, int expires, Subscription subscription, SubscriptionControlDataSource dataSource, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        this.sipSubscriptionHandler.sbb.getTimerFacility().cancelTimer(subscription.getTimerID());
        subscription.refresh(expires);
        try {
            Response response = this.sipSubscriptionHandler.sbb.getMessageFactory().createResponse(200, event.getRequest());
            response = this.sipSubscriptionHandler.addContactHeader(response);
            response.addHeader((Header)this.sipSubscriptionHandler.sbb.getHeaderFactory().createExpiresHeader(expires));
            event.getServerTransaction().sendResponse(response);
        }
        catch (Exception e) {
            tracer.severe("Can't send RESPONSE", (Throwable)e);
        }
        if (!subscription.isResourceList()) {
            try {
                this.sipSubscriptionHandler.getSipSubscriberNotificationHandler().createAndSendNotify(dataSource, subscription, (DialogActivity)aci.getActivity(), childSbb);
            }
            catch (Exception e) {
                tracer.severe("failed to notify subscriber", (Throwable)e);
            }
        }
        this.sipSubscriptionHandler.sbb.setSubscriptionTimerAndPersistSubscription(subscription, expires + 1, aci);
        if (tracer.isInfoEnabled()) {
            tracer.info("Refreshed " + subscription + " for " + expires + " seconds");
        }
        if (subscription.isResourceList()) {
            this.sipSubscriptionHandler.sbb.getEventListSubscriptionHandler().refreshSubscription(subscription);
        }
    }
}

