/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.sip;

import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.HeaderFactoryImpl;
import gov.nist.javax.sip.header.ims.PChargingVectorHeader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import javax.sip.Dialog;
import javax.sip.SipException;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.Header;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.Tracer;
import javax.xml.transform.TransformerException;
import net.java.slee.resource.sip.DialogActivity;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriptionHandler;
import org.openxdm.xcap.common.xml.TextWriter;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipSubscriberNotificationHandler {
    private static Tracer tracer;
    private SipSubscriptionHandler sipSubscriptionHandler;

    public SipSubscriberNotificationHandler(SipSubscriptionHandler sipSubscriptionHandler) {
        this.sipSubscriptionHandler = sipSubscriptionHandler;
        if (tracer == null) {
            tracer = sipSubscriptionHandler.sbb.getSbbContext().getTracer(this.getClass().getSimpleName());
        }
    }

    public void notifySipSubscriber(NotifyContent notifyContent, Subscription subscription, ActivityContextInterface dialogACI, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        try {
            DialogActivity dialog = (DialogActivity)dialogACI.getActivity();
            Request notify = this.createNotify((Dialog)dialog, subscription, notifyContent.getEventHeaderParams());
            if (notifyContent != null && notifyContent.getContent() != null) {
                boolean doSubscriberFiltering = !subscription.isResourceList() && !subscription.isWInfoSubscription();
                if ((notify = this.setNotifyContent(subscription, notify, notifyContent.getContent(), notifyContent.getContentTypeHeader(), childSbb, doSubscriberFiltering, true)) == null) {
                    if (tracer.isFineEnabled()) {
                        tracer.fine("notification aborted for " + subscription);
                    }
                    return;
                }
            }
            notify.addHeader((Header)this.addPChargingVectorHeader());
            dialog.sendRequest(notify);
        }
        catch (Exception e) {
            tracer.severe("failed to notify subscriber", (Throwable)e);
        }
    }

    private Request setNotifyContent(Subscription subscription, Request notify, Object content, ContentTypeHeader contentTypeHeader, ImplementedSubscriptionControlSbbLocalObject childSbb, boolean doNotifierFiltering, boolean isStateChange) throws ParseException, IOException {
        String notifyContent = null;
        if (doNotifierFiltering) {
            content = childSbb.filterContentPerSubscriber(subscription, content);
        }
        if (content instanceof Node) {
            try {
                notifyContent = TextWriter.toString((Node)((Node)content));
            }
            catch (TransformerException e) {
                throw new IOException("failed to marshall DOM content", e);
            }
        } else {
            notifyContent = (String)content;
        }
        if (notifyContent == null) {
            if (isStateChange) {
                return null;
            }
            return notify;
        }
        notify.setContent((Object)notifyContent, contentTypeHeader);
        return notify;
    }

    public void createAndSendNotify(SubscriptionControlDataSource dataSource, Subscription subscription, DialogActivity dialog, ImplementedSubscriptionControlSbbLocalObject childSbb) throws TransactionDoesNotExistException, SipException, ParseException {
        Request notify = null;
        if (subscription.getStatus() == Subscription.Status.active) {
            if (subscription.isWInfoSubscription()) {
                notify = this.createNotify((Dialog)dialog, subscription, null);
                try {
                    notify = this.setNotifyContent(subscription, notify, this.sipSubscriptionHandler.sbb.getWInfoSubscriptionHandler().getFullWatcherInfoContent(dataSource, subscription), this.sipSubscriptionHandler.sbb.getWInfoSubscriptionHandler().getWatcherInfoContentHeader(), childSbb, false, false);
                }
                catch (Exception e) {
                    tracer.severe("failed to set notify content", (Throwable)e);
                }
            } else {
                NotifyContent notifyContent = childSbb.getNotifyContent(subscription);
                if (notifyContent == null) {
                    notify = this.createNotify((Dialog)dialog, subscription, null);
                } else {
                    notify = this.createNotify((Dialog)dialog, subscription, notifyContent.getEventHeaderParams());
                    if (notifyContent.getContent() != null) {
                        try {
                            notify = this.setNotifyContent(subscription, notify, notifyContent.getContent(), notifyContent.getContentTypeHeader(), childSbb, false, false);
                        }
                        catch (Exception e) {
                            tracer.severe("failed to set notify content", (Throwable)e);
                        }
                    }
                }
            }
        } else {
            notify = this.createNotify((Dialog)dialog, subscription, null);
        }
        notify.addHeader((Header)this.addPChargingVectorHeader());
        dialog.sendRequest(notify);
    }

    private Request createNotify(Dialog dialog, Subscription subscription, Map<String, String> eventHeaderParams) {
        Request notify = null;
        try {
            notify = dialog.createRequest("NOTIFY");
            EventHeader eventHeader = this.sipSubscriptionHandler.sbb.getHeaderFactory().createEventHeader(subscription.getKey().getEventPackage());
            if (subscription.getKey().getEventId() != null) {
                eventHeader.setEventId(subscription.getKey().getEventId());
            }
            if (eventHeaderParams != null) {
                for (Map.Entry<String, String> entry : eventHeaderParams.entrySet()) {
                    eventHeader.setParameter(entry.getKey(), entry.getValue());
                }
            }
            notify.setHeader((Header)eventHeader);
            notify.setHeader((Header)this.sipSubscriptionHandler.sbb.getHeaderFactory().createMaxForwardsHeader(this.sipSubscriptionHandler.sbb.getConfiguration().getMaxForwards()));
            SubscriptionStateHeader ssh = null;
            if (subscription.getStatus().equals((Object)Subscription.Status.active) || subscription.getStatus().equals((Object)Subscription.Status.pending)) {
                ssh = this.sipSubscriptionHandler.sbb.getHeaderFactory().createSubscriptionStateHeader(subscription.getStatus().toString());
                ssh.setExpires(subscription.getRemainingExpires());
            } else if (subscription.getStatus().equals((Object)Subscription.Status.waiting) || subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
                ssh = this.sipSubscriptionHandler.sbb.getHeaderFactory().createSubscriptionStateHeader("terminated");
                if (subscription.getLastEvent() != null) {
                    ssh.setReasonCode(subscription.getLastEvent().toString());
                }
            }
            notify.addHeader((Header)ssh);
            if (subscription.isResourceList()) {
                notify.addHeader((Header)this.sipSubscriptionHandler.sbb.getHeaderFactory().createRequireHeader("eventlist"));
            }
        }
        catch (Exception e) {
            tracer.severe("unable to fill notify headers", (Throwable)e);
        }
        return notify;
    }

    private PChargingVectorHeader addPChargingVectorHeader() throws ParseException {
        HeaderFactoryImpl extensions = new HeaderFactoryImpl();
        PChargingVectorHeader pcv = extensions.createChargingVectorHeader(Utils.getInstance().generateBranchId() + System.currentTimeMillis());
        pcv.setOriginatingIOI(this.sipSubscriptionHandler.sbb.getConfiguration().getPChargingVectorHeaderTerminatingIOI());
        return pcv;
    }
}

