/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.sip;

import gov.nist.javax.sip.header.ims.PChargingFunctionAddressesHeader;
import gov.nist.javax.sip.header.ims.PChargingVectorHeader;
import java.text.ParseException;
import javax.sip.Dialog;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;
import org.mobicents.slee.sipevent.server.subscription.sip.NewSipSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.sip.RefreshSipSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.sip.RemoveSipSubscriptionHandler;
import org.mobicents.slee.sipevent.server.subscription.sip.SipSubscriberNotificationHandler;

public class SipSubscriptionHandler {
    private static Tracer tracer;
    protected SubscriptionControlSbb sbb;
    private NewSipSubscriptionHandler newSipSubscriptionHandler;
    private RefreshSipSubscriptionHandler refreshSipSubscriptionHandler;
    private RemoveSipSubscriptionHandler removeSipSubscriptionHandler;
    private SipSubscriberNotificationHandler sipSubscriberNotificationHandler;

    public SipSubscriptionHandler(SubscriptionControlSbb sbb) {
        this.sbb = sbb;
        if (tracer == null) {
            tracer = sbb.getSbbContext().getTracer(this.getClass().getSimpleName());
        }
        this.newSipSubscriptionHandler = new NewSipSubscriptionHandler(this);
        this.refreshSipSubscriptionHandler = new RefreshSipSubscriptionHandler(this);
        this.removeSipSubscriptionHandler = new RemoveSipSubscriptionHandler(this);
        this.sipSubscriberNotificationHandler = new SipSubscriberNotificationHandler(this);
    }

    public NewSipSubscriptionHandler getNewSipSubscriptionHandler() {
        return this.newSipSubscriptionHandler;
    }

    public RefreshSipSubscriptionHandler getRefreshSipSubscriptionHandler() {
        return this.refreshSipSubscriptionHandler;
    }

    public RemoveSipSubscriptionHandler getRemoveSipSubscriptionHandler() {
        return this.removeSipSubscriptionHandler;
    }

    public SipSubscriberNotificationHandler getSipSubscriberNotificationHandler() {
        return this.sipSubscriberNotificationHandler;
    }

    public void processRequest(RequestEvent event, ActivityContextInterface aci) {
        EventHeader eventHeader;
        ImplementedSubscriptionControlSbbLocalObject childSbb = this.sbb.getImplementedControlChildSbb();
        if (childSbb == null) {
            try {
                Response response = this.sbb.getMessageFactory().createResponse(500, event.getRequest());
                event.getServerTransaction().sendResponse(response);
            }
            catch (Exception f) {
                tracer.severe("Can't send error response!", (Throwable)f);
            }
            return;
        }
        SubscriptionControlDataSource dataSource = this.sbb.getConfiguration().getDataSource();
        if (tracer.isFineEnabled()) {
            tracer.fine("Processing SUBSCRIBE request...");
        }
        if ((eventHeader = (EventHeader)event.getRequest().getHeader("Event")) != null) {
            String eventPackage = eventHeader.getEventType();
            if (this.acceptsEventPackage(eventPackage, childSbb)) {
                ExpiresHeader expiresHeader = event.getRequest().getExpires();
                int expires = expiresHeader == null ? this.sbb.getConfiguration().getDefaultExpires() : expiresHeader.getExpires();
                if (expires > 0) {
                    if (expires >= this.sbb.getConfiguration().getMinExpires()) {
                        Dialog dialog;
                        if (expires > this.sbb.getConfiguration().getMaxExpires()) {
                            expires = this.sbb.getConfiguration().getMaxExpires();
                        }
                        if ((dialog = event.getDialog()) == null) {
                            this.newSipSubscriptionHandler.newSipSubscription(event, aci, eventPackage, eventHeader.getEventId(), expires, dataSource, childSbb);
                        } else {
                            String eventId = eventHeader.getEventId();
                            Subscription subscription = dataSource.get(new SubscriptionKey(dialog.getDialogId(), eventPackage, eventId));
                            if (subscription != null) {
                                if (subscription.getStatus().equals((Object)Subscription.Status.active) || subscription.getStatus().equals((Object)Subscription.Status.pending)) {
                                    this.refreshSipSubscriptionHandler.refreshSipSubscription(event, aci, expires, subscription, dataSource, childSbb);
                                } else {
                                    this.sendResponse(412, event.getRequest(), event.getServerTransaction(), childSbb);
                                }
                            } else {
                                this.newSipSubscriptionHandler.newSipSubscription(event, aci, eventPackage, eventHeader.getEventId(), expires, dataSource, childSbb);
                            }
                        }
                    } else {
                        this.sendResponse(423, event.getRequest(), event.getServerTransaction(), childSbb);
                    }
                } else if (expires == 0) {
                    Dialog dialog = event.getDialog();
                    if (dialog != null) {
                        String eventId = eventHeader.getEventId();
                        Subscription subscription = dataSource.get(new SubscriptionKey(dialog.getDialogId(), eventPackage, eventId));
                        if (subscription != null) {
                            if (subscription.getStatus().equals((Object)Subscription.Status.active) || subscription.getStatus().equals((Object)Subscription.Status.pending)) {
                                try {
                                    Response response = this.sbb.getMessageFactory().createResponse(200, event.getRequest());
                                    response = this.addContactHeader(response);
                                    response.addHeader((Header)this.sbb.getHeaderFactory().createExpiresHeader(expires));
                                    event.getServerTransaction().sendResponse(response);
                                }
                                catch (Exception e) {
                                    tracer.severe("Can't send RESPONSE", (Throwable)e);
                                }
                                if (subscription.isResourceList()) {
                                    this.sbb.getEventListSubscriptionHandler().removeSubscription(subscription);
                                }
                                this.removeSipSubscriptionHandler.removeSipSubscription(aci, subscription, dataSource, childSbb);
                            } else {
                                this.sendResponse(412, event.getRequest(), event.getServerTransaction(), childSbb);
                            }
                        } else {
                            this.sendResponse(412, event.getRequest(), event.getServerTransaction(), childSbb);
                        }
                    } else {
                        this.sendResponse(412, event.getRequest(), event.getServerTransaction(), childSbb);
                    }
                } else {
                    this.sendResponse(400, event.getRequest(), event.getServerTransaction(), childSbb);
                }
            } else {
                this.sendResponse(489, event.getRequest(), event.getServerTransaction(), childSbb);
            }
        } else {
            this.sendResponse(400, event.getRequest(), event.getServerTransaction(), childSbb);
        }
    }

    public void sendResponse(int responseCode, Request request, ServerTransaction serverTransaction, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        try {
            PChargingFunctionAddressesHeader pcfa;
            Response response = this.sbb.getMessageFactory().createResponse(responseCode, request);
            if (responseCode == 489) {
                String allowEventsHeader = "";
                boolean first = true;
                for (String acceptedEventPackage : childSbb.getEventPackages()) {
                    if (first) {
                        allowEventsHeader = allowEventsHeader + acceptedEventPackage + "," + acceptedEventPackage + ".winfo";
                        first = false;
                        continue;
                    }
                    allowEventsHeader = allowEventsHeader + "," + acceptedEventPackage + "," + acceptedEventPackage + ".winfo";
                }
                response.addHeader((Header)this.sbb.getHeaderFactory().createAllowEventsHeader(allowEventsHeader));
            } else if (responseCode == 423) {
                response.addHeader((Header)this.sbb.getHeaderFactory().createMinExpiresHeader(this.sbb.getConfiguration().getMinExpires()));
            }
            response = this.addContactHeader(response);
            PChargingVectorHeader pcv = (PChargingVectorHeader)request.getHeader("P-Charging-Vector");
            if (pcv != null) {
                pcv.setTerminatingIOI(this.sbb.getConfiguration().getPChargingVectorHeaderTerminatingIOI());
                response.addHeader((Header)pcv);
            }
            if ((pcfa = (PChargingFunctionAddressesHeader)request.getHeader("P-Charging-Function-Addresses")) != null) {
                response.addHeader((Header)pcfa);
            }
            serverTransaction.sendResponse(response);
        }
        catch (Exception e) {
            tracer.severe("Can't send response!", (Throwable)e);
        }
    }

    public Response addContactHeader(Response response) throws ParseException {
        if (response.getHeader("Contact") != null) {
            response.removeHeader("Contact");
        }
        ListeningPoint listeningPoint = this.sbb.getSipProvider().getListeningPoint("udp");
        Address address = this.sbb.getAddressFactory().createAddress(this.sbb.getConfiguration().getContactAddressDisplayName() + " <sip:" + listeningPoint.getIPAddress() + ">");
        ((SipURI)address.getURI()).setPort(listeningPoint.getPort());
        response.addHeader((Header)this.sbb.getHeaderFactory().createContactHeader(address));
        return response;
    }

    public boolean acceptsEventPackage(String eventPackage, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        if (eventPackage != null) {
            for (String acceptedEventPackage : childSbb.getEventPackages()) {
                if (!eventPackage.equalsIgnoreCase(acceptedEventPackage) && !eventPackage.equalsIgnoreCase(acceptedEventPackage + ".winfo")) continue;
                return true;
            }
        }
        return false;
    }
}

