/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.winfo;

import java.text.ParseException;
import javax.sip.header.ContentTypeHeader;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.Tracer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.mobicents.slee.sipevent.server.subscription.ImplementedSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sipevent.server.subscription.SubscriptionControlSbb;
import org.mobicents.slee.sipevent.server.subscription.WInfoNotifyEvent;
import org.mobicents.slee.sipevent.server.subscription.data.Subscription;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionControlDataSource;
import org.mobicents.slee.sipevent.server.subscription.data.SubscriptionKey;
import org.mobicents.xdm.common.util.dom.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WInfoSubscriptionHandler {
    private static Tracer tracer;
    private SubscriptionControlSbb sbb;

    public WInfoSubscriptionHandler(SubscriptionControlSbb sbb) {
        this.sbb = sbb;
        if (tracer == null) {
            tracer = sbb.getSbbContext().getTracer(this.getClass().getSimpleName());
        }
    }

    public void notifyWinfoSubscriptions(SubscriptionControlDataSource dataSource, Subscription subscription, ImplementedSubscriptionControlSbbLocalObject childSbb) {
        if (!subscription.getKey().isWInfoSubscription()) {
            for (Subscription winfoSubscription : dataSource.getSubscriptionsByNotifierAndEventPackage(subscription.getNotifier().getUri(), subscription.getKey().getEventPackage() + ".winfo")) {
                if (winfoSubscription.getStatus() != Subscription.Status.active) continue;
                try {
                    ActivityContextInterface winfoAci = this.sbb.getActivityContextNamingfacility().lookup(winfoSubscription.getKey().toString());
                    if (winfoAci != null) {
                        this.sbb.fireWInfoNotifyEvent(new WInfoNotifyEvent(winfoSubscription.getKey(), subscription.getKey(), this.createWInfoWatcher(subscription)), winfoAci, null);
                        continue;
                    }
                    tracer.warning("Unable to find subscription aci to notify subscription " + winfoSubscription.getKey() + ". Removing subscription data");
                    this.sbb.removeSubscriptionData(dataSource, winfoSubscription, null, null, childSbb);
                }
                catch (Exception e) {
                    tracer.severe("failed to notify winfo subscriber", (Throwable)e);
                }
            }
        }
    }

    private WInfoNotifyEvent.Watcher createWInfoWatcher(Subscription subscription) {
        WInfoNotifyEvent.Watcher watcher = new WInfoNotifyEvent.Watcher();
        watcher.setId(String.valueOf(subscription.hashCode()));
        watcher.setStatus(subscription.getStatus().toString());
        watcher.setDurationSubscribed(Integer.valueOf(subscription.getSubscriptionDuration()));
        if (subscription.getLastEvent() != null) {
            watcher.setEvent(subscription.getLastEvent().toString());
        }
        if (subscription.getSubscriberDisplayName() != null) {
            watcher.setDisplayName(subscription.getSubscriberDisplayName());
        }
        if (!subscription.getStatus().equals((Object)Subscription.Status.terminated)) {
            watcher.setExpiration(Integer.valueOf(subscription.getRemainingExpires()));
        }
        watcher.setValue(subscription.getSubscriber());
        return watcher;
    }

    public Document getPartialWatcherInfoContent(Subscription winfoSubscription, SubscriptionKey watcherSubscriptionKey, WInfoNotifyEvent.Watcher watcher) {
        Document document = this.createWatcherInfoDocument(winfoSubscription, "partial");
        Element watcherList = this.addWatcherInfoDocumentWatcherList(winfoSubscription, document.getDocumentElement());
        this.addWatcherInfoDocumentWatcher(watcherList, watcher);
        return document;
    }

    public Document getFullWatcherInfoContent(SubscriptionControlDataSource dataSource, Subscription winfoSubscription) {
        Document document = this.createWatcherInfoDocument(winfoSubscription, "full");
        Element watcherList = this.addWatcherInfoDocumentWatcherList(winfoSubscription, document.getDocumentElement());
        WInfoNotifyEvent.Watcher watcher = null;
        for (Subscription subscription : dataSource.getSubscriptionsByNotifierAndEventPackage(winfoSubscription.getNotifier().getUri(), watcherList.getAttribute("package"))) {
            watcher = this.createWInfoWatcher(subscription);
            this.addWatcherInfoDocumentWatcher(watcherList, watcher);
        }
        return document;
    }

    private Document createWatcherInfoDocument(Subscription winfoSubscription, String state) {
        DocumentBuilder builder = null;
        try {
            builder = DomUtils.DOCUMENT_BUILDER_NS_AWARE_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            tracer.severe("failed to create dom doc builder", (Throwable)e);
            return null;
        }
        Document document = builder.newDocument();
        Element watcherInfo = document.createElementNS("urn:ietf:params:xml:ns:watcherinfo", "watcherinfo");
        winfoSubscription.incrementVersion();
        winfoSubscription.store();
        watcherInfo.setAttribute("version", Integer.toString(winfoSubscription.getVersion()));
        watcherInfo.setAttribute("state", state);
        document.appendChild(watcherInfo);
        return document;
    }

    private void addWatcherInfoDocumentWatcher(Element watcherList, WInfoNotifyEvent.Watcher watcher) {
        Element watcherElement = watcherList.getOwnerDocument().createElement("watcher");
        if (watcher.getDisplayName() != null) {
            watcherElement.setAttribute("display-name", watcher.getDisplayName());
        }
        if (watcher.getDurationSubscribed() != null) {
            watcherElement.setAttribute("duration-subscribed", watcher.getDurationSubscribed().toString());
        }
        watcherElement.setAttribute("event", watcher.getEvent());
        if (watcher.getExpiration() != null) {
            watcherElement.setAttribute("expiration", watcher.getExpiration().toString());
        }
        watcherElement.setAttribute("id", watcher.getId());
        if (watcher.getLang() != null) {
            watcherElement.setAttribute("lang", watcher.getLang());
        }
        watcherElement.setAttribute("status", watcher.getStatus());
        watcherElement.setTextContent(watcher.getValue());
        watcherList.appendChild(watcherElement);
    }

    private Element addWatcherInfoDocumentWatcherList(Subscription winfoSubscription, Element watcherInfo) {
        Element watcherList = watcherInfo.getOwnerDocument().createElement("watcherinfo");
        watcherList.setAttribute("resource", winfoSubscription.getNotifier().getUri());
        String winfoEventPackage = winfoSubscription.getKey().getEventPackage();
        String eventPackage = winfoEventPackage.substring(0, winfoEventPackage.indexOf(".winfo"));
        watcherList.setAttribute("package", eventPackage);
        watcherInfo.appendChild(watcherList);
        return watcherList;
    }

    public ContentTypeHeader getWatcherInfoContentHeader() {
        try {
            return this.sbb.getHeaderFactory().createContentTypeHeader("application", "watcherinfo+xml");
        }
        catch (ParseException e) {
            tracer.severe("failure creating content type header", (Throwable)e);
            return null;
        }
    }
}

