/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sippresence.server.presrulescache;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.sippresence.server.jmx.SipPresenceServerManagement;
import org.mobicents.slee.sippresence.server.presrulescache.GetAndSubscribePresRulesAppUsageEvent;
import org.mobicents.slee.sippresence.server.presrulescache.PresRulesSbbInterface;
import org.mobicents.slee.sippresence.server.presrulescache.UnsubscribePresRulesAppUsageEvent;
import org.openxdm.xcap.common.datasource.Document;
import org.openxdm.xcap.common.error.InternalServerErrorException;
import org.openxdm.xcap.common.uri.DocumentSelector;
import org.openxdm.xcap.server.slee.resource.datasource.AttributeUpdatedEvent;
import org.openxdm.xcap.server.slee.resource.datasource.CollectionActivity;
import org.openxdm.xcap.server.slee.resource.datasource.DataSourceActivityContextInterfaceFactory;
import org.openxdm.xcap.server.slee.resource.datasource.DataSourceSbbInterface;
import org.openxdm.xcap.server.slee.resource.datasource.DocumentUpdatedEvent;
import org.openxdm.xcap.server.slee.resource.datasource.ElementUpdatedEvent;

public abstract class PresRulesCacheSbb
implements Sbb {
    private SbbContext context;
    private Tracer tracer;
    private DataSourceSbbInterface dataSourceSbbInterface;
    private DataSourceActivityContextInterfaceFactory dataSourceActivityContextInterfaceFactory;
    private PresRulesSbbInterface presRulesSbbInterface;

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext context) {
        this.context = context;
        this.tracer = context.getTracer(this.getClass().getSimpleName());
        try {
            Context ic = (Context)new InitialContext().lookup("java:comp/env");
            this.dataSourceSbbInterface = (DataSourceSbbInterface)ic.lookup("slee/resources/xdm/datasource/1.0/sbbinterface");
            this.dataSourceActivityContextInterfaceFactory = (DataSourceActivityContextInterfaceFactory)ic.lookup("slee/resources/xdm/datasource/1.0/acif");
            this.presRulesSbbInterface = (PresRulesSbbInterface)ic.lookup("slee/resources/presence/presrulescache/1.0/sbbinterface");
        }
        catch (NamingException e) {
            this.tracer.severe("Failed to set sbb context", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        this.context = null;
        this.tracer = null;
        this.dataSourceSbbInterface = null;
        this.dataSourceActivityContextInterfaceFactory = null;
        this.presRulesSbbInterface = null;
    }

    public abstract ActivityContextInterface getPresRulesAppUsageACI();

    public abstract void setPresRulesAppUsageACI(ActivityContextInterface var1);

    public void onGetAndSubscribePresRulesAppUsageEvent(GetAndSubscribePresRulesAppUsageEvent event, ActivityContextInterface aci) {
        long start = System.currentTimeMillis();
        String presRulesAUID = SipPresenceServerManagement.getInstance().getPresRulesAUID();
        CollectionActivity appUsageActivity = this.dataSourceSbbInterface.createCollectionActivity(presRulesAUID);
        ActivityContextInterface appUsageActivityContextInterface = this.dataSourceActivityContextInterfaceFactory.getActivityContextInterface(appUsageActivity);
        appUsageActivityContextInterface.attach(this.context.getSbbLocalObject());
        this.setPresRulesAppUsageACI(appUsageActivityContextInterface);
        DocumentSelector documentSelector = null;
        try {
            Document[] documents;
            for (Document document : documents = this.dataSourceSbbInterface.getDocuments(presRulesAUID + "/users", true)) {
                documentSelector = new DocumentSelector(document.getCollection(), document.getDocumentName());
                if (this.tracer.isFineEnabled()) {
                    this.tracer.fine("Retrieving document " + documentSelector);
                }
                this.presRulesSbbInterface.rulesetUpdated(documentSelector, null, document.getETag(), document.getAsString());
            }
        }
        catch (InternalServerErrorException e) {
            this.tracer.severe("unable to fetch current pres rules docs", (Throwable)e);
        }
        this.tracer.info("Total time to init pres rules cache: " + (System.currentTimeMillis() - start) + "ms");
    }

    public void onUnsubscribePresRulesAppUsageEvent(UnsubscribePresRulesAppUsageEvent event, ActivityContextInterface aci) {
        SbbLocalObject sbbLocalObject = this.context.getSbbLocalObject();
        ActivityContextInterface appUsageActivityContextInterface = this.getPresRulesAppUsageACI();
        if (appUsageActivityContextInterface != null) {
            appUsageActivityContextInterface.detach(sbbLocalObject);
        }
        aci.detach(sbbLocalObject);
    }

    private String getDocumentETag(Document document) {
        return document == null ? null : document.getETag();
    }

    public void onAttributeUpdatedEvent(AttributeUpdatedEvent event, ActivityContextInterface aci) {
        this.presRulesSbbInterface.rulesetUpdated(event.getDocumentSelector(), this.getDocumentETag(event.getOldDocument()), event.getNewETag(), event.getNewDocumentString());
    }

    public void onDocumentUpdatedEvent(DocumentUpdatedEvent event, ActivityContextInterface aci) {
        this.presRulesSbbInterface.rulesetUpdated(event.getDocumentSelector(), this.getDocumentETag(event.getOldDocument()), event.getNewETag(), event.getNewDocumentString());
    }

    public void onElementUpdatedEvent(ElementUpdatedEvent event, ActivityContextInterface aci) {
        this.presRulesSbbInterface.rulesetUpdated(event.getDocumentSelector(), this.getDocumentETag(event.getOldDocument()), event.getNewETag(), event.getNewDocumentString());
    }
}

