/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.xcap.client.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.auth.Credentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.mobicents.xcap.client.XcapClient;
import org.mobicents.xcap.client.XcapResponse;
import org.mobicents.xcap.client.impl.XcapResponseHandler;
import org.mobicents.xcap.client.impl.auth.SingleCredentialsProvider;

public class XcapClientImpl
implements XcapClient {
    private static final Log log = LogFactory.getLog(XcapClientImpl.class);
    private final DefaultHttpClient client;
    private final XcapResponseHandler responseHandler = new XcapResponseHandler();
    private final SingleCredentialsProvider credentialsProvider = new SingleCredentialsProvider();
    private static final HttpContext NULL_HTTP_CONTEXT = null;

    public XcapClientImpl() {
        this.client = new DefaultHttpClient();
        this.client.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
        this.client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        this.client.setCredentialsProvider((CredentialsProvider)this.credentialsProvider);
    }

    public void setAuthenticationCredentials(Credentials credentials) {
        this.credentialsProvider.setCredentials(credentials);
    }

    public void unsetAuthenticationCredentials() {
        this.credentialsProvider.setCredentials(null);
    }

    public void shutdown() {
        log.info((Object)"shutdown()");
        if (this.client != null) {
            this.client.getConnectionManager().shutdown();
        }
    }

    private XcapResponse execute(HttpUriRequest request, Header[] additionalRequestHeaders, Credentials credentials) throws ClientProtocolException, IOException {
        if (additionalRequestHeaders != null) {
            for (Header header : additionalRequestHeaders) {
                request.addHeader(header);
            }
        }
        HttpContext httpContext = NULL_HTTP_CONTEXT;
        if (credentials != null) {
            httpContext = new BasicHttpContext();
            httpContext.setAttribute("http.auth.credentials-provider", (Object)new SingleCredentialsProvider(credentials));
        }
        XcapResponse response = (XcapResponse)this.client.execute(request, (ResponseHandler)this.responseHandler, httpContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received:\n--BEGIN--\n" + response.toString() + "\n--END--"));
        }
        return response;
    }

    private void setRequestEntity(HttpPut request, String content, String mimetype) throws UnsupportedEncodingException {
        request.setHeader("Content-Type", mimetype);
        request.setEntity((HttpEntity)new StringEntity(content, "UTF-8"));
    }

    private void setRequestEntity(HttpPut request, byte[] content, String mimetype) throws UnsupportedEncodingException {
        request.setHeader("Content-Type", mimetype);
        request.setEntity((HttpEntity)new ByteArrayEntity(content));
    }

    public XcapResponse get(URI uri, Header[] additionalRequestHeaders, Credentials credentials) throws ClientProtocolException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get(uri=" + uri + " , additionalRequestHeaders = ( " + additionalRequestHeaders + " ) )"));
        }
        return this.execute((HttpUriRequest)new HttpGet(uri), additionalRequestHeaders, credentials);
    }

    public XcapResponse put(URI uri, String mimetype, String content, Header[] additionalRequestHeaders, Credentials credentials) throws ClientProtocolException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("put(uri=" + uri + ", mimetype=" + mimetype + ", content=" + content + " , additionalRequestHeaders = ( " + additionalRequestHeaders + " ) )"));
        }
        HttpPut request = new HttpPut(uri);
        this.setRequestEntity(request, content, mimetype);
        return this.execute((HttpUriRequest)request, additionalRequestHeaders, credentials);
    }

    public XcapResponse putIfMatch(URI uri, String eTag, String mimetype, String content, Header[] additionalRequestHeaders, Credentials credentials) throws ClientProtocolException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("putIfMatch(uri=" + uri + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + " , additionalRequestHeaders = ( " + additionalRequestHeaders + " ) )"));
        }
        HttpPut request = new HttpPut(uri);
        this.setRequestEntity(request, content, mimetype);
        request.setHeader("If-Match", eTag);
        return this.execute((HttpUriRequest)request, additionalRequestHeaders, credentials);
    }

    public XcapResponse putIfNoneMatch(URI uri, String eTag, String mimetype, String content, Header[] additionalRequestHeaders, Credentials credentials) throws ClientProtocolException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("putIfNoneMatch(uri=" + uri + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + " , additionalRequestHeaders = ( " + additionalRequestHeaders + " ) )"));
        }
        HttpPut request = new HttpPut(uri);
        this.setRequestEntity(request, content, mimetype);
        request.setHeader("If-None-Match", eTag);
        return this.execute((HttpUriRequest)request, additionalRequestHeaders, credentials);
    }

    public XcapResponse put(URI uri, String mimetype, byte[] content, Header[] additionalRequestHeaders, Credentials credentials) throws ClientProtocolException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("put(uri=" + uri + ", mimetype=" + mimetype + ", content=" + content + " , additionalRequestHeaders = ( " + additionalRequestHeaders + " ) )"));
        }
        HttpPut request = new HttpPut(uri);
        this.setRequestEntity(request, content, mimetype);
        return this.execute((HttpUriRequest)request, additionalRequestHeaders, credentials);
    }

    public XcapResponse putIfMatch(URI uri, String eTag, String mimetype, byte[] content, Header[] additionalRequestHeaders, Credentials credentials) throws ClientProtocolException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("putIfMatch(uri=" + uri + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + " , additionalRequestHeaders = ( " + additionalRequestHeaders + " ) )"));
        }
        HttpPut request = new HttpPut(uri);
        this.setRequestEntity(request, content, mimetype);
        request.setHeader("If-Match", eTag);
        return this.execute((HttpUriRequest)request, additionalRequestHeaders, credentials);
    }

    public XcapResponse putIfNoneMatch(URI uri, String eTag, String mimetype, byte[] content, Header[] additionalRequestHeaders, Credentials credentials) throws ClientProtocolException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("putIfNoneMatch(uri=" + uri + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + " , additionalRequestHeaders = ( " + additionalRequestHeaders + " ) )"));
        }
        HttpPut request = new HttpPut(uri);
        this.setRequestEntity(request, content, mimetype);
        request.setHeader("If-None-Match", eTag);
        return this.execute((HttpUriRequest)request, additionalRequestHeaders, credentials);
    }

    public XcapResponse delete(URI uri, Header[] additionalRequestHeaders, Credentials credentials) throws ClientProtocolException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("delete(uri=" + uri + " , additionalRequestHeaders = ( " + additionalRequestHeaders + " ) )"));
        }
        return this.execute((HttpUriRequest)new HttpDelete(uri), additionalRequestHeaders, credentials);
    }

    public XcapResponse deleteIfMatch(URI uri, String eTag, Header[] additionalRequestHeaders, Credentials credentials) throws ClientProtocolException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteIfMatch(uri=" + uri + ", eTag=" + eTag + " , additionalRequestHeaders = ( " + additionalRequestHeaders + " ) )"));
        }
        HttpDelete request = new HttpDelete(uri);
        request.setHeader("If-Match", eTag);
        return this.execute((HttpUriRequest)request, additionalRequestHeaders, credentials);
    }

    public XcapResponse deleteIfNoneMatch(URI uri, String eTag, Header[] additionalRequestHeaders, Credentials credentials) throws ClientProtocolException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteIfNoneMatch( uri = " + uri + " , eTag = " + eTag + " , additionalRequestHeaders = ( " + additionalRequestHeaders + " ) )"));
        }
        HttpDelete request = new HttpDelete(uri);
        request.setHeader("If-None-Match", eTag);
        return this.execute((HttpUriRequest)request, additionalRequestHeaders, credentials);
    }
}

