/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.xcap.client.impl;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.mobicents.xcap.client.XcapEntity;
import org.mobicents.xcap.client.uri.enconding.UriComponentEncoder;

public class XcapEntityImpl
implements XcapEntity {
    private final HttpEntity httpEntity;
    private final byte[] rawContent;
    private String contentAsString;

    public XcapEntityImpl(HttpEntity httpEntity) throws IOException {
        this.httpEntity = httpEntity;
        this.rawContent = EntityUtils.toByteArray((HttpEntity)httpEntity);
        httpEntity.consumeContent();
    }

    public String getContentAsString() {
        if (this.contentAsString == null) {
            this.contentAsString = new String(this.rawContent, UriComponentEncoder.UTF8_CHARSET);
        }
        return this.contentAsString;
    }

    public Header getContentEncoding() {
        return this.httpEntity.getContentEncoding();
    }

    public long getContentLength() {
        return this.httpEntity.getContentLength();
    }

    public Header getContentType() {
        return this.httpEntity.getContentType();
    }

    public byte[] getRawContent() {
        return this.rawContent;
    }

    public boolean isChunked() {
        return this.httpEntity.isChunked();
    }

    public String toString() {
        return this.getContentAsString();
    }
}

