/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.xcap.client.impl;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.mobicents.xcap.client.XcapResponse;
import org.mobicents.xcap.client.header.Header;
import org.mobicents.xcap.client.impl.XcapEntityImpl;
import org.mobicents.xcap.client.impl.XcapResponseImpl;
import org.mobicents.xcap.client.impl.header.HeaderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcapResponseHandler
implements ResponseHandler<XcapResponse> {
    public XcapResponse handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        org.apache.http.Header eTagHeader;
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        String eTag = null;
        if ((statusCode == 200 || statusCode == 201) && (eTagHeader = httpResponse.getFirstHeader("ETag")) != null) {
            eTag = eTagHeader.getValue();
        }
        org.apache.http.Header[] apacheHeaders = httpResponse.getAllHeaders();
        Header[] headers = new Header[apacheHeaders.length];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = new HeaderImpl(apacheHeaders[i]);
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        XcapEntityImpl xcapEntity = httpEntity != null ? new XcapEntityImpl(httpEntity) : null;
        return new XcapResponseImpl(statusCode, eTag, headers, xcapEntity);
    }
}

