/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.mvel2.MVEL;
import org.mvel2.tests.core.AbstractTest;

public class RegularExpressionTests
extends AbstractTest {
    public void testRegExpOK() throws Exception {
        RegularExpressionTests.assertEquals((Object)Boolean.TRUE, (Object)MVEL.eval((String)"'Hello'.toUpperCase() ~= '[A-Z]{0,5}'"));
        RegularExpressionTests.assertEquals((Object)Boolean.TRUE, (Object)MVEL.eval((String)"1 == 0 || ('Hello'.toUpperCase() ~= '[A-Z]{0,5}')"));
        RegularExpressionTests.assertEquals((Object)Boolean.TRUE, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"'Hello' ~= '[a-zA-Z]{0,5}'")));
    }

    public void testRegExpPreCompiledBug() throws Exception {
        Serializable ser = MVEL.compileExpression((String)"'Hello'.toUpperCase() ~= '[a-zA-Z]{0,5}'");
        RegularExpressionTests.assertEquals((Object)Boolean.TRUE, (Object)MVEL.executeExpression((Object)ser));
    }

    public void testRegExpOrBug() throws Exception {
        RegularExpressionTests.assertEquals((Object)Boolean.TRUE, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"1 == 0 || ('Hello'.toUpperCase() ~= '[A-Z]{0,5}')")));
    }

    public void testRegExpAndBug() throws Exception {
        RegularExpressionTests.assertEquals((Object)Boolean.TRUE, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"1 == 1 && ('Hello'.toUpperCase() ~= '[A-Z]{0,5}')")));
    }

    public void testRegExSurroundedByBrackets() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("x", "foobie");
        RegularExpressionTests.assertEquals((Object)Boolean.TRUE, (Object)MVEL.eval((String)"x ~= ('f.*')", map));
    }

    public void testMVEL231() {
        System.out.println(MVEL.eval((String)"Q8152405_A35423077=\"1\"; Q8152405_A35423077!=null && (Q8152405_A35423077~=\"^[0-9]$\");", new HashMap()));
    }

    public void testParsingStability4() {
        RegularExpressionTests.assertEquals((Object)true, (Object)this.test("vv=\"Edson\"; !(vv ~= \"Mark\")"));
    }

    public void testRegExOR() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("os", "windows");
        RegularExpressionTests.assertTrue((boolean)((Boolean)MVEL.eval((String)"os ~= 'windows|unix'", map)));
    }

    public void testRegExOR2() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("os", "windows");
        RegularExpressionTests.assertTrue((boolean)((Boolean)MVEL.eval((String)"'windows' ~= 'windows|unix'", map)));
        RegularExpressionTests.assertFalse((boolean)((Boolean)MVEL.eval((String)"time ~= 'windows|unix'", (Object)new Date())));
    }

    public void testRegExMatch() {
        RegularExpressionTests.assertEquals((Object)true, (Object)MVEL.eval((String)"$test = 'foo'; $ex = 'f.*'; $test ~= $ex", new HashMap()));
    }
}

