/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.mvel2.CompileException;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel2.integration.impl.StaticMethodImportResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.tests.core.AbstractTest;
import org.mvel2.tests.core.CoreConfidenceTests;
import org.mvel2.tests.core.res.Bar;
import org.mvel2.tests.core.res.Base;
import org.mvel2.tests.core.res.Cheese;
import org.mvel2.tests.core.res.Foo;
import org.mvel2.tests.core.res.MyInterface2;
import org.mvel2.tests.core.res.MyInterface3;
import org.mvel2.tests.core.res.SampleBean;
import org.mvel2.util.MethodStub;

public class TypesAndInferenceTests
extends AbstractTest {
    public static final List<String> STRINGS = Arrays.asList("hi", "there");

    public void testGenericInference() {
        String expression = "$result = person.footributes[0].name";
        ParserContext ctx = ParserContext.create().stronglyTyped().withInput("person", AbstractTest.Person.class);
        MVEL.analysisCompile((String)expression, (ParserContext)ctx);
        TypesAndInferenceTests.assertEquals(String.class, (Object)ctx.getVarOrInputTypeOrNull("$result"));
        Serializable s = MVEL.compileExpression((String)expression, (ParserContext)ParserContext.create().stronglyTyped().withInput("person", AbstractTest.Person.class));
        HashMap<String, AbstractTest.Person> vars = new HashMap<String, AbstractTest.Person>();
        AbstractTest.Person p = new AbstractTest.Person();
        p.setFootributes(new ArrayList<Foo>());
        p.getFootributes().add(new Foo());
        vars.put("person", p);
        TypesAndInferenceTests.assertEquals((Object)"dog", (Object)MVEL.executeExpression((Object)s, vars));
    }

    public void testGenericInference2() {
        ParserContext ctx = ParserContext.create().stronglyTyped().withInput("person", AbstractTest.Person.class);
        MVEL.analysisCompile((String)"$result = person.maptributes['fooey'].name", (ParserContext)ctx);
        TypesAndInferenceTests.assertEquals(String.class, (Object)ctx.getVarOrInputTypeOrNull("$result"));
    }

    public void testVarInputs() {
        ParserContext pCtx = ParserContext.create();
        MVEL.analysisCompile((String)"test != foo && bo.addSomething(trouble) && 1 + 2 / 3 == 1; String bleh = foo; twa = bleh;", (ParserContext)pCtx);
        TypesAndInferenceTests.assertEquals((int)4, (int)pCtx.getInputs().size());
        TypesAndInferenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("test"));
        TypesAndInferenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("foo"));
        TypesAndInferenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("bo"));
        TypesAndInferenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("trouble"));
        TypesAndInferenceTests.assertEquals((int)2, (int)pCtx.getVariables().size());
        TypesAndInferenceTests.assertTrue((boolean)pCtx.getVariables().containsKey("bleh"));
        TypesAndInferenceTests.assertTrue((boolean)pCtx.getVariables().containsKey("twa"));
        TypesAndInferenceTests.assertEquals(String.class, (Object)pCtx.getVarOrInputType("bleh"));
    }

    public void testVarInputs2() {
        ExpressionCompiler compiler = new ExpressionCompiler("test != foo && bo.addSomething(trouble); String bleh = foo; twa = bleh;");
        ParserContext ctx = new ParserContext();
        compiler.compile(ctx);
        System.out.println(ctx.getVarOrInputType("bleh"));
    }

    public void testVarInputs3() {
        ExpressionCompiler compiler = new ExpressionCompiler("addresses['home'].street");
        compiler.compile();
        TypesAndInferenceTests.assertFalse((boolean)compiler.getParserContextState().getInputs().keySet().contains("home"));
    }

    public void testVarInputs4() {
        ExpressionCompiler compiler = new ExpressionCompiler("System.out.println( message );");
        compiler.compile();
        TypesAndInferenceTests.assertTrue((boolean)compiler.getParserContextState().getInputs().keySet().contains("message"));
    }

    public void testVarInputs5() {
        ParserContext pCtx = ParserContext.create().withInput("list", List.class);
        MVEL.analysisCompile((String)"String nodeName = list[0];\nSystem.out.println(nodeName);nodeName = list[1];\nSystem.out.println(nodeName);", (ParserContext)pCtx);
        TypesAndInferenceTests.assertEquals((int)1, (int)pCtx.getInputs().size());
        TypesAndInferenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("list"));
        TypesAndInferenceTests.assertEquals((int)1, (int)pCtx.getVariables().size());
        TypesAndInferenceTests.assertTrue((boolean)pCtx.getVariables().containsKey("nodeName"));
        TypesAndInferenceTests.assertEquals(List.class, (Object)pCtx.getVarOrInputType("list"));
        TypesAndInferenceTests.assertEquals(String.class, (Object)pCtx.getVarOrInputType("nodeName"));
    }

    public void testDetermineRequiredInputsInConstructor() throws Exception {
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(false);
        ctx.setStrongTyping(false);
        ctx.addImport(Foo.class);
        ExpressionCompiler compiler = new ExpressionCompiler("new Foo244( $bar,  $bar.age );");
        CompiledExpression compiled = compiler.compile(ctx);
        Set requiredInputs = compiler.getParserContextState().getInputs().keySet();
        TypesAndInferenceTests.assertEquals((int)1, (int)requiredInputs.size());
        TypesAndInferenceTests.assertTrue((boolean)requiredInputs.contains("$bar"));
    }

    public void testAnalyzer() {
        ParserContext ctx = new ParserContext();
        MVEL.compileExpression((String)"order.id == 10", (ParserContext)ctx);
        for (String input : ctx.getInputs().keySet()) {
            System.out.println("input>" + input);
        }
        TypesAndInferenceTests.assertEquals((int)1, (int)ctx.getInputs().size());
        TypesAndInferenceTests.assertTrue((boolean)ctx.getInputs().containsKey("order"));
    }

    public void testAnalysisCompile() {
        ParserContext pCtx = new ParserContext();
        ExpressionCompiler e = new ExpressionCompiler("foo.aValue = 'bar'");
        e.setVerifyOnly(true);
        e.compile(pCtx);
        TypesAndInferenceTests.assertTrue((boolean)pCtx.getInputs().keySet().contains("foo"));
        TypesAndInferenceTests.assertEquals((int)1, (int)pCtx.getInputs().size());
        TypesAndInferenceTests.assertEquals((int)0, (int)pCtx.getVariables().size());
    }

    public void testMultiVarDeclr() {
        String ex = "var a, b, c";
        ParserContext ctx = new ParserContext();
        ExpressionCompiler compiler = new ExpressionCompiler(ex);
        compiler.setVerifyOnly(true);
        compiler.compile(ctx);
        TypesAndInferenceTests.assertEquals((int)3, (int)ctx.getVariables().size());
    }

    public void testVarDeclr() {
        String ex = "var a";
        ParserContext ctx = new ParserContext();
        ExpressionCompiler compiler = new ExpressionCompiler(ex);
        compiler.setVerifyOnly(true);
        compiler.compile(ctx);
        TypesAndInferenceTests.assertEquals((int)1, (int)ctx.getVariables().size());
    }

    public void testMultiTypeVarDeclr() {
        String ex = "String a, b, c";
        ParserContext ctx = new ParserContext();
        ExpressionCompiler compiler = new ExpressionCompiler(ex);
        compiler.compile(ctx);
        TypesAndInferenceTests.assertNotNull((Object)ctx.getVariables());
        TypesAndInferenceTests.assertEquals((int)3, (int)ctx.getVariables().entrySet().size());
        for (Map.Entry entry : ctx.getVariables().entrySet()) {
            TypesAndInferenceTests.assertEquals(String.class, entry.getValue());
        }
    }

    public void testMultiTypeVarDeclr2() {
        String ex = "String a = 'foo', b = 'baz', c = 'bar'";
        ParserContext ctx = new ParserContext();
        ExpressionCompiler compiler = new ExpressionCompiler(ex);
        compiler.compile(ctx);
        TypesAndInferenceTests.assertNotNull((Object)ctx.getVariables());
        TypesAndInferenceTests.assertEquals((int)3, (int)ctx.getVariables().entrySet().size());
        for (Map.Entry entry : ctx.getVariables().entrySet()) {
            TypesAndInferenceTests.assertEquals(String.class, entry.getValue());
        }
    }

    public void testMultiTypeVarDeclr3() {
        String ex = "int a = 52 * 3, b = 8, c = 16;";
        ParserContext ctx = new ParserContext();
        ExpressionCompiler compiler = new ExpressionCompiler(ex);
        CompiledExpression s = compiler.compile(ctx);
        TypesAndInferenceTests.assertNotNull((Object)ctx.getVariables());
        TypesAndInferenceTests.assertEquals((int)3, (int)ctx.getVariables().entrySet().size());
        for (Map.Entry entry : ctx.getVariables().entrySet()) {
            TypesAndInferenceTests.assertEquals(Integer.class, entry.getValue());
        }
        HashMap vars = new HashMap();
        MVEL.executeExpression((Object)s, vars);
        TypesAndInferenceTests.assertEquals((Object)156, vars.get("a"));
        TypesAndInferenceTests.assertEquals((Object)8, vars.get("b"));
        TypesAndInferenceTests.assertEquals((Object)16, vars.get("c"));
    }

    public void testTypeVarDeclr() {
        String ex = "String a;";
        ParserContext ctx = new ParserContext();
        ExpressionCompiler compiler = new ExpressionCompiler(ex);
        compiler.compile(ctx);
        TypesAndInferenceTests.assertNotNull((Object)ctx.getVariables());
        TypesAndInferenceTests.assertEquals((int)1, (int)ctx.getVariables().entrySet().size());
        for (Map.Entry entry : ctx.getVariables().entrySet()) {
            TypesAndInferenceTests.assertEquals(String.class, entry.getValue());
        }
    }

    public void testStrictTypingCompilation4() throws NoSuchMethodException {
        ParserContext ctx = new ParserContext();
        ctx.addImport(Foo.class);
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler("x_a = new Foo()");
        compiler.compile(ctx);
        TypesAndInferenceTests.assertEquals(Foo.class, ctx.getVariables().get("x_a"));
    }

    public void testEgressType() {
        ExpressionCompiler compiler = new ExpressionCompiler("( $cheese )");
        ParserContext context = new ParserContext();
        context.addInput("$cheese", Cheese.class);
        TypesAndInferenceTests.assertEquals(Cheese.class, (Object)compiler.compile(context).getKnownEgressType());
    }

    public void testEgressTypeCorrect() {
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)"type", (ParserContext)ParserContext.create().stronglyTyped().withInput("this", Cheese.class));
        TypesAndInferenceTests.assertEquals(String.class, (Object)stmt.getKnownEgressType());
    }

    public void testEgressTypeCorrect2() {
        ParserContext context = new ParserContext();
        context.setStrongTyping(true);
        context.addInput("this", SampleBean.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)"( map2[ 'yyy' ] )", (ParserContext)context);
        SampleBean s = new SampleBean();
        s.getMap2().put("yyy", 1);
        TypesAndInferenceTests.assertEquals((Object)new Integer(1), (Object)MVEL.executeExpression((Object)stmt, (Object)s));
    }

    public final void testDetermineEgressParametricType() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrongTyping(true);
        parserContext.addInput("strings", List.class, new Class[]{String.class});
        CompiledExpression expr = new ExpressionCompiler("strings").compile(parserContext);
        TypesAndInferenceTests.assertTrue((boolean)((Object)STRINGS).equals(MVEL.executeExpression((Object)expr, (Object)new A())));
        Type[] typeParameters = expr.getParserContext().getLastTypeParameters();
        TypesAndInferenceTests.assertTrue((typeParameters != null ? 1 : 0) != 0);
        TypesAndInferenceTests.assertTrue((boolean)String.class.equals((Object)typeParameters[0]));
    }

    public final void testDetermineEgressParametricType2() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrongTyping(true);
        parserContext.addInput("strings", List.class, new Class[]{String.class});
        CompiledExpression expr = new ExpressionCompiler("strings", parserContext).compile();
        TypesAndInferenceTests.assertTrue((boolean)((Object)STRINGS).equals(MVEL.executeExpression((Object)expr, (Object)new A())));
        Type[] typeParameters = expr.getParserContext().getLastTypeParameters();
        TypesAndInferenceTests.assertTrue((null != typeParameters ? 1 : 0) != 0);
        TypesAndInferenceTests.assertTrue((boolean)String.class.equals((Object)typeParameters[0]));
    }

    public void testJIRA151c() {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        B b = new B();
        C c = new C();
        ParserContext context = new ParserContext();
        Serializable expression = MVEL.compileExpression((String)"a.foo(value)", (ParserContext)context);
        for (int i = 0; i < 100; ++i) {
            System.out.println("i: " + i);
            System.out.flush();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("a", b);
            variables.put("value", 123);
            MVEL.executeExpression((Object)expression, variables);
            variables = new HashMap();
            variables.put("a", c);
            variables.put("value", 123);
            MVEL.executeExpression((Object)expression, variables);
        }
    }

    public void testJIRA151d() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        B b = new B();
        C c = new C();
        ParserContext context = new ParserContext();
        Serializable expression = MVEL.compileExpression((String)"a.foo(value)", (ParserContext)context);
        for (int i = 0; i < 100; ++i) {
            System.out.println("i: " + i);
            System.out.flush();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("a", b);
            variables.put("value", 123);
            MVEL.executeExpression((Object)expression, variables);
            variables = new HashMap();
            variables.put("a", c);
            variables.put("value", 123);
            MVEL.executeExpression((Object)expression, variables);
        }
    }

    public void testJIRA165b() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        B b = new B();
        A a = new A();
        ParserContext context = new ParserContext();
        Serializable expression = MVEL.compileExpression((String)"a.bar(value)", (ParserContext)context);
        for (int i = 0; i < 100; ++i) {
            System.out.println("i: " + i);
            System.out.flush();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("a", b);
            variables.put("value", 123);
            MVEL.executeExpression((Object)expression, variables);
            variables = new HashMap();
            variables.put("a", a);
            variables.put("value", 123);
            MVEL.executeExpression((Object)expression, variables);
        }
    }

    public void testJIRA165() {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        B b = new B();
        A a = new A();
        ParserContext context = new ParserContext();
        Serializable expression = MVEL.compileExpression((String)"a.bar(value)", (ParserContext)context);
        for (int i = 0; i < 100; ++i) {
            System.out.println("i: " + i);
            System.out.flush();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("a", b);
            variables.put("value", 123);
            MVEL.executeExpression((Object)expression, variables);
            variables = new HashMap();
            variables.put("a", a);
            variables.put("value", 123);
            MVEL.executeExpression((Object)expression, variables);
        }
    }

    public void testStrictTypingCompilationWithVarInsideConstructor() {
        ParserContext ctx = new ParserContext();
        ctx.addInput("$likes", String.class);
        ctx.addInput("results", List.class);
        ctx.addImport(Cheese.class);
        ctx.setStrongTyping(true);
        Serializable expr = null;
        try {
            expr = MVEL.compileExpression((String)"Cheese c = new Cheese( $likes, 15 );\nresults.add( c ); ", (ParserContext)ctx);
        }
        catch (CompileException e) {
            e.printStackTrace();
            TypesAndInferenceTests.fail((String)("This should not fail:\n" + e.getMessage()));
        }
        ArrayList results = new ArrayList();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("$likes", "stilton");
        vars.put("results", results);
        MVEL.executeExpression((Object)expr, vars);
        TypesAndInferenceTests.assertEquals((Object)new Cheese("stilton", 15), results.get(0));
    }

    public void testParameterizedTypeInStrictMode2() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("ctx", Object.class);
        ExpressionCompiler compiler = new ExpressionCompiler("org.mvel2.DataConversion.convert(ctx, String).toUpperCase()");
        TypesAndInferenceTests.assertEquals(String.class, (Object)compiler.compile(ctx).getKnownEgressType());
    }

    public void testParameterizedTypeInStrictMode3() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("base", Base.class);
        ExpressionCompiler compiler = new ExpressionCompiler("base.list");
        TypesAndInferenceTests.assertTrue((boolean)compiler.compile(ctx).getParserContext().getLastTypeParameters()[0].equals(String.class));
    }

    public void testParameterizedTypeInStrictMode4() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("base", Base.class);
        ExpressionCompiler compiler = new ExpressionCompiler("base.list.get(1).toUpperCase()");
        CompiledExpression ce = compiler.compile(ctx);
        TypesAndInferenceTests.assertEquals(String.class, (Object)ce.getKnownEgressType());
    }

    public void testReturnType1() {
        TypesAndInferenceTests.assertEquals(Double.class, (Object)new ExpressionCompiler("100.5").compile().getKnownEgressType());
    }

    public void testReturnType2() {
        TypesAndInferenceTests.assertEquals(Integer.class, (Object)new ExpressionCompiler("1").compile().getKnownEgressType());
    }

    public void testStrongTyping3() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        try {
            new ExpressionCompiler("foo.toUC(100.5").compile(ctx);
        }
        catch (Exception e) {
            return;
        }
        TypesAndInferenceTests.assertTrue((boolean)false);
    }

    public void testEgressType1() {
        TypesAndInferenceTests.assertEquals(Boolean.class, (Object)new ExpressionCompiler("foo != null").compile().getKnownEgressType());
    }

    public void testStrictStaticMethodCall() {
        ExpressionCompiler compiler = new ExpressionCompiler("Bar.staticMethod()");
        ParserContext ctx = new ParserContext();
        ctx.addImport("Bar", Bar.class);
        ctx.setStrictTypeEnforcement(true);
        CompiledExpression s = compiler.compile(ctx);
        TypesAndInferenceTests.assertEquals((Object)1, (Object)MVEL.executeExpression((Object)s));
    }

    public void testStrictTypingCompilation2() throws Exception {
        ParserContext ctx = new ParserContext();
        ctx.addImport("getRuntime", new MethodStub(Runtime.class.getMethod("getRuntime", new Class[0])));
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler("getRuntime()");
        StaticMethodImportResolverFactory si = new StaticMethodImportResolverFactory(ctx);
        CompiledExpression expression = compiler.compile(ctx);
        TypesAndInferenceTests.serializationTest((Serializable)expression);
        TypesAndInferenceTests.assertTrue((boolean)(MVEL.executeExpression((Object)expression, (VariableResolverFactory)si) instanceof Runtime));
    }

    public void testStrictTypingCompilation3() throws NoSuchMethodException {
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler("message='Hello';b=7;\nSystem.out.println(message + ';' + b);\nSystem.out.println(message + ';' + b); b");
        TypesAndInferenceTests.assertEquals((Object)7, (Object)MVEL.executeExpression((Object)compiler.compile(ctx), (VariableResolverFactory)new DefaultLocalVariableResolverFactory()));
    }

    public void testStrictStrongTypingCompilationErrors1() throws Exception {
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setStrongTyping(true);
        ctx.addImport(Foo.class);
        ctx.addInput("$bar", Bar.class);
        try {
            ExpressionCompiler compiler = new ExpressionCompiler("System.out.println( $ba );");
            compiler.compile(ctx);
            TypesAndInferenceTests.fail((String)"This should not compileShared");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testStrictStrongTypingCompilationErrors2() throws Exception {
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setStrongTyping(true);
        ctx.addImport(Foo.class);
        ctx.addInput("$bar", Bar.class);
        try {
            MVEL.compileExpression((String)"x_a = new Foo244( $ba ); x_a.equals($ba);", (ParserContext)ctx);
            TypesAndInferenceTests.fail((String)"This should not compileShared");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testProvidedExternalTypes() {
        ExpressionCompiler compiler = new ExpressionCompiler("foo.bar");
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.addInput("foo", Foo.class);
        compiler.compile(ctx);
    }

    public void testMVEL228() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.setStrictTypeEnforcement(true);
        HashMap<String, Class> params = new HashMap<String, Class>();
        params.put("helper", ScriptHelper228.class);
        params.put("person", Person228.class);
        ctx.setInputs(params);
        String script = "helper.methodB(2);\nperson.getName2();";
        try {
            CompiledExpression compiled = (CompiledExpression)MVEL.compileExpression((String)script, (ParserContext)ctx);
        }
        catch (Exception e) {
            return;
        }
        TypesAndInferenceTests.fail((String)"Should have thrown an exception");
    }

    public void testMVEL232() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.setStrictTypeEnforcement(true);
        String script = "for(int i=0;i<2;i++) {   System.out.println(i+\"\");}  return true;";
        try {
            CompiledExpression compiled = (CompiledExpression)MVEL.compileExpression((String)script, (ParserContext)ctx);
            HashMap map = new HashMap();
            MVEL.executeExpression((Object)compiled, map);
        }
        catch (Exception e) {
            e.printStackTrace();
            TypesAndInferenceTests.fail((String)"should now throw an exception");
        }
    }

    public void testMVEL234() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("import java.text.SimpleDateFormat;");
        buffer.append("if (\"test\".matches(\"[0-9]\")) {");
        buffer.append("  return false;");
        buffer.append("}else{");
        buffer.append("  SimpleDateFormat sqf = new SimpleDateFormat(\"yyyyMMdd\");");
        buffer.append("}");
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        try {
            CompiledExpression compiled = (CompiledExpression)MVEL.compileExpression((String)buffer.toString(), (ParserContext)ctx);
        }
        catch (Exception e) {
            TypesAndInferenceTests.fail((String)e.getMessage());
        }
    }

    public void testMVEL235() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("if(var1.equals(var2)) {");
        buffer.append("return true;");
        buffer.append("}");
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("var1", MyInterface2.class);
        ctx.addInput("var2", MyInterface2.class);
        try {
            Serializable compiled = MVEL.compileExpression((String)buffer.toString(), (ParserContext)ctx);
            System.out.println(compiled);
        }
        catch (Exception e) {
            TypesAndInferenceTests.fail((String)e.getMessage());
        }
    }

    public void testMVEL236() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MyInterface2 var2 = (MyInterface2)var1;");
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("var1", MyInterface3.class);
        ctx.addImport(MyInterface2.class);
        ctx.addImport(MyInterface3.class);
        try {
            CompiledExpression compiled = (CompiledExpression)MVEL.compileExpression((String)buffer.toString(), (ParserContext)ctx);
        }
        catch (Exception e) {
            TypesAndInferenceTests.fail((String)e.getMessage());
        }
    }

    public void testMapPropertyAccess() {
        ParserContext ctx = new ParserContext();
        ctx.addImport(MapWrapper.class);
        ctx.addInput("wrapper", MapWrapper.class);
        ctx.setStrongTyping(true);
        Serializable expr = MVEL.compileExpression((String)"wrapper.map[\"key\"]", (ParserContext)ctx);
        MapWrapper wrapper = new MapWrapper();
        wrapper.getMap().put("key", "value");
        HashMap<String, MapWrapper> vars = new HashMap<String, MapWrapper>();
        vars.put("wrapper", wrapper);
        TypesAndInferenceTests.assertEquals((Object)"value", (Object)MVEL.executeExpression((Object)expr, vars));
    }

    public void testTypeCast3() {
        HashMap<String, Foo> map = new HashMap<String, Foo>();
        map.put("foo", new Foo());
        ParserContext pCtx = new ParserContext();
        pCtx.setStrongTyping(true);
        pCtx.addInput("foo", Foo.class);
        Serializable s = MVEL.compileExpression((String)"((org.mvel2.tests.core.res.Bar) foo.getBar()).name != null", (ParserContext)pCtx);
        TypesAndInferenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)s, map));
        TypesAndInferenceTests.assertEquals((int)1, (int)pCtx.getInputs().size());
        TypesAndInferenceTests.assertEquals((boolean)true, (boolean)pCtx.getInputs().containsKey("foo"));
    }

    public void testMapWithStrictTyping() {
        ExpressionCompiler compiler = new ExpressionCompiler("map['KEY1'] == $msg");
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setStrongTyping(true);
        ctx.addInput("$msg", String.class);
        ctx.addInput("map", Map.class);
        CompiledExpression expr = compiler.compile(ctx);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("KEY1", "MSGONE");
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("$msg", "MSGONE");
        vars.put("map", map);
        Boolean bool = (Boolean)MVEL.executeExpression((Object)expr, map, vars);
        TypesAndInferenceTests.assertEquals((Object)Boolean.TRUE, (Object)bool);
    }

    public void testMapAsContextWithStrictTyping() {
        ExpressionCompiler compiler = new ExpressionCompiler("this['KEY1'] == $msg");
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.setStrongTyping(true);
        ctx.addInput("$msg", String.class);
        ctx.addInput("this", Map.class);
        CompiledExpression expr = compiler.compile(ctx);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("KEY1", "MSGONE");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("$msg", "MSGONE");
        Boolean bool = (Boolean)MVEL.executeExpression((Object)expr, map, vars);
        TypesAndInferenceTests.assertEquals((Object)Boolean.TRUE, (Object)bool);
    }

    public void testStrongTyping() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        try {
            new ExpressionCompiler("blah").compile(ctx);
        }
        catch (Exception e) {
            return;
        }
        TypesAndInferenceTests.assertTrue((boolean)false);
    }

    public void testStrongTyping2() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("blah", String.class);
        try {
            new ExpressionCompiler("1-blah").compile(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        TypesAndInferenceTests.assertTrue((boolean)false);
    }

    public void testParameterizedTypeInStrictMode() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("foo", HashMap.class, new Class[]{String.class, String.class});
        ExpressionCompiler compiler = new ExpressionCompiler("foo.get('bar').toUpperCase()");
        compiler.compile(ctx);
    }

    public void testSetAccessorOverloadedEqualsStrictMode2() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("foo", Foo.class);
        try {
            CompiledExpression expr = new ExpressionCompiler("foo.aValue = 'bar'").compile(ctx);
        }
        catch (CompileException e) {
            TypesAndInferenceTests.assertTrue((boolean)false);
        }
    }

    public void testDataConverterStrictMode() throws Exception {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        DataConversion.addConversionHandler(Date.class, (ConversionHandler)new MVELDateCoercion());
        ParserContext ctx = new ParserContext();
        ctx.addImport("Cheese", Cheese.class);
        ctx.setStrongTyping(true);
        ctx.setStrictTypeEnforcement(true);
        Locale.setDefault(Locale.US);
        Cheese expectedCheese = new Cheese();
        expectedCheese.setUseBy(new SimpleDateFormat("dd-MMM-yyyy").parse("10-Jul-1974"));
        ExpressionCompiler compiler = new ExpressionCompiler("c = new Cheese(); c.useBy = '10-Jul-1974'; return c");
        Cheese actualCheese = (Cheese)MVEL.executeExpression((Object)compiler.compile(ctx), (Map)TypesAndInferenceTests.createTestMap());
        TypesAndInferenceTests.assertEquals((Object)expectedCheese.getUseBy(), (Object)actualCheese.getUseBy());
    }

    public void testCompileTimeCoercion() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("foo", Foo.class);
        TypesAndInferenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)new ExpressionCompiler("foo.bar.woof == 'true'").compile(ctx), (Map)TypesAndInferenceTests.createTestMap()));
    }

    public void testSetCoercion() {
        Serializable s = MVEL.compileSetExpression((String)"name");
        Foo foo = new Foo();
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)12);
        TypesAndInferenceTests.assertEquals((String)"12", (String)foo.getName());
        foo = new Foo();
        MVEL.setProperty((Object)foo, (String)"name", (Object)12);
        TypesAndInferenceTests.assertEquals((String)"12", (String)foo.getName());
    }

    public void testSetCoercion2() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("sampleBean", SampleBean.class);
        Serializable s = MVEL.compileSetExpression((String)"sampleBean.map2['bleh']", (ParserContext)ctx);
        Foo foo = new Foo();
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)"12");
        TypesAndInferenceTests.assertEquals((int)12, (int)foo.getSampleBean().getMap2().get("bleh"));
        foo = new Foo();
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)"13");
        TypesAndInferenceTests.assertEquals((int)13, (int)foo.getSampleBean().getMap2().get("bleh"));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("sampleBean", SampleBean.class);
        s = MVEL.compileSetExpression((String)"sampleBean.map2['bleh']", (ParserContext)ctx);
        foo = new Foo();
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)"12");
        TypesAndInferenceTests.assertEquals((int)12, (int)foo.getSampleBean().getMap2().get("bleh"));
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)new Integer(12));
        TypesAndInferenceTests.assertEquals((int)12, (int)foo.getSampleBean().getMap2().get("bleh"));
    }

    public void testListCoercion() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("bar", Bar.class);
        Serializable s = MVEL.compileSetExpression((String)"bar.testList[0]", (ParserContext)ctx);
        Foo foo = new Foo();
        foo.getBar().getTestList().add(new Integer(-1));
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)"12");
        TypesAndInferenceTests.assertEquals((int)12, (int)foo.getBar().getTestList().get(0));
        foo = new Foo();
        foo.getBar().getTestList().add(new Integer(-1));
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)"13");
        TypesAndInferenceTests.assertEquals((int)13, (int)foo.getBar().getTestList().get(0));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("bar", Bar.class);
        s = MVEL.compileSetExpression((String)"bar.testList[0]", (ParserContext)ctx);
        foo = new Foo();
        foo.getBar().getTestList().add(new Integer(-1));
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)"12");
        TypesAndInferenceTests.assertEquals((int)12, (int)foo.getBar().getTestList().get(0));
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)"13");
        TypesAndInferenceTests.assertEquals((int)13, (int)foo.getBar().getTestList().get(0));
    }

    public void testFieldCoercion1() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("bar", Bar.class);
        Serializable s = MVEL.compileSetExpression((String)"bar.assignTest", (ParserContext)ctx);
        Foo foo = new Foo();
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)12);
        TypesAndInferenceTests.assertEquals((String)"12", (String)foo.getBar().getAssignTest());
        foo = new Foo();
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)13);
        TypesAndInferenceTests.assertEquals((String)"13", (String)foo.getBar().getAssignTest());
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("bar", Bar.class);
        s = MVEL.compileSetExpression((String)"bar.assignTest", (ParserContext)ctx);
        foo = new Foo();
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)12);
        TypesAndInferenceTests.assertEquals((String)"12", (String)foo.getBar().getAssignTest());
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)13);
        TypesAndInferenceTests.assertEquals((String)"13", (String)foo.getBar().getAssignTest());
    }

    public void testStaticTyping2() {
        String exp = "int x = 5; int y = 2; new int[] { x, y }";
        Integer[] res = (Integer[])MVEL.eval((String)exp, new HashMap());
        TypesAndInferenceTests.assertEquals((int)5, (int)res[0]);
        TypesAndInferenceTests.assertEquals((int)2, (int)res[1]);
    }

    public void testMVEL190a() {
        Serializable compiled = MVEL.compileExpression((String)"a.toString()", (ParserContext)ParserContext.create().stronglyTyped().withInput("a", String.class));
    }

    public void testPrimitiveTypes() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("base", Base.class);
        Serializable s = MVEL.compileExpression((String)"int x = 5; x = x + base.intValue; x", (ParserContext)ctx);
        HashMap<String, Base> vars = new HashMap<String, Base>();
        vars.put("base", new Base());
        Number x = (Number)MVEL.executeExpression((Object)s, vars);
        TypesAndInferenceTests.assertEquals((int)15, (int)x.intValue());
    }

    public void testAutoBoxing() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        Serializable s = MVEL.compileExpression((String)"(list = new java.util.ArrayList()).add( 5 ); list", (ParserContext)ctx);
        HashMap vars = new HashMap();
        List list = (List)MVEL.executeExpression((Object)s, vars);
        TypesAndInferenceTests.assertEquals((int)1, (int)list.size());
    }

    public void testAutoBoxing2() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("base", Base.class);
        Serializable s = MVEL.compileExpression((String)"java.util.List list = new java.util.ArrayList(); list.add( base.intValue ); list", (ParserContext)ctx);
        HashMap<String, Base> vars = new HashMap<String, Base>();
        vars.put("base", new Base());
        List list = (List)MVEL.executeExpression((Object)s, vars);
        TypesAndInferenceTests.assertEquals((int)1, (int)list.size());
    }

    public void testTypeCoercion() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("base", Base.class);
        Serializable s = MVEL.compileExpression((String)"java.math.BigInteger x = new java.math.BigInteger( \"5\" ); x + base.intValue;", (ParserContext)ctx);
        HashMap<String, Base> vars = new HashMap<String, Base>();
        vars.put("base", new Base());
        Number x = (Number)MVEL.executeExpression((Object)s, vars);
        TypesAndInferenceTests.assertEquals((int)15, (int)x.intValue());
    }

    public void testTypeCoercion2() {
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("base", Base.class);
        Serializable s = MVEL.compileExpression((String)"java.math.BigInteger x = new java.math.BigInteger( \"5\" ); x + base.intValue;", (ParserContext)ctx);
        HashMap<String, Base> vars = new HashMap<String, Base>();
        vars.put("base", new Base());
        Number x = (Number)MVEL.executeExpression((Object)s, vars);
        TypesAndInferenceTests.assertEquals((int)15, (int)x.intValue());
    }

    public void testStaticFieldAccessForInputs() {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        ParserContext pCtx = ParserContext.create();
        MVEL.analysisCompile((String)"java.math.BigDecimal.TEN", (ParserContext)pCtx);
        TypesAndInferenceTests.assertFalse((boolean)pCtx.getInputs().containsKey("java"));
        TypesAndInferenceTests.assertEquals((int)0, (int)pCtx.getInputs().size());
    }

    public void testStaticFieldAccessForInputsWithStrictStrong() {
        ParserContext pCtx = ParserContext.create();
        pCtx.setStrictTypeEnforcement(true);
        pCtx.setStrongTyping(true);
        MVEL.analysisCompile((String)"java.math.BigDecimal.TEN", (ParserContext)pCtx);
        TypesAndInferenceTests.assertFalse((boolean)pCtx.getInputs().containsKey("java"));
        TypesAndInferenceTests.assertEquals((int)0, (int)pCtx.getInputs().size());
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        pCtx = ParserContext.create();
        pCtx.setStrictTypeEnforcement(true);
        pCtx.setStrongTyping(true);
        MVEL.analysisCompile((String)"java.math.BigDecimal.TEN", (ParserContext)pCtx);
        TypesAndInferenceTests.assertFalse((boolean)pCtx.getInputs().containsKey("java"));
        TypesAndInferenceTests.assertEquals((int)0, (int)pCtx.getInputs().size());
    }

    public void testStaticMethodsInInputsBug() {
        String text = " getList( java.util.Formatter )";
        ParserConfiguration pconf = new ParserConfiguration();
        for (Method m : CoreConfidenceTests.StaticMethods.class.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers())) continue;
            pconf.addImport(m.getName(), m);
        }
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrictTypeEnforcement(false);
        pctx.setStrongTyping(false);
        HashMap vars = new HashMap();
        Serializable expr = MVEL.compileExpression((String)text, (ParserContext)pctx);
        List list = (List)MVEL.executeExpression((Object)expr, null, vars);
        TypesAndInferenceTests.assertEquals(Formatter.class, list.get(0));
        TypesAndInferenceTests.assertEquals((int)0, (int)pctx.getInputs().size());
    }

    public void testStaticMethodCallThrowsException() {
        String text = " ( throwException( ) ) ";
        ParserConfiguration pconf = new ParserConfiguration();
        for (Method m : CoreConfidenceTests.StaticMethods.class.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers())) continue;
            pconf.addImport(m.getName(), m);
        }
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        HashMap vars = new HashMap();
        Serializable expr = MVEL.compileExpression((String)text, (ParserContext)pctx);
        try {
            MVEL.executeExpression((Object)expr);
            TypesAndInferenceTests.fail((String)"this should throw an exception");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testContextMethodCallsInStrongMode() {
        ParserContext context = new ParserContext();
        context.setStrongTyping(true);
        context.addInput("this", EchoContext.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)"this.echo( 'Mac')", (ParserContext)context);
        stmt = (ExecutableStatement)MVEL.compileExpression((String)"echo( 'Mac')", (ParserContext)context);
        TypesAndInferenceTests.assertEquals((Object)"Mac", (Object)MVEL.executeExpression((Object)stmt, (Object)new EchoContext()));
    }

    public void testForLoopTypeCoercion() {
        ParserContext pCtx = ParserContext.create();
        pCtx.setStrongTyping(true);
        pCtx.addInput("$type", String.class);
        pCtx.addInput("l", List.class);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("$type", "pc!!");
        ArrayList list = new ArrayList();
        vars.put("l", list);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)"for (byte bt:$type.getBytes()) {l.add( bt);}", (ParserContext)pCtx);
        MVEL.executeExpression((Object)stmt, null, vars);
        byte[] exp = "pc!!".getBytes();
        for (int i = 0; i < exp.length; ++i) {
            TypesAndInferenceTests.assertEquals((Object)exp[i], list.get(i));
        }
    }

    public void testGetCorrectInputs() {
        String str = "total = total + $cheese.price";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("total", Integer.TYPE);
        pctx.addInput("$cheese", Cheese.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        TypesAndInferenceTests.assertTrue((String)("Should not contain" + pctx.getVariables()), (boolean)pctx.getVariables().isEmpty());
    }

    public void testTypeCalculation() {
        ParserContext ctx = ParserContext.create().stronglyTyped();
        ctx.addInput("foo", Foo.class);
        Class cls = MVEL.analyze((String)"foo.bar.testList.get(0)", (ParserContext)ctx);
        TypesAndInferenceTests.assertTrue((boolean)Integer.class.isAssignableFrom(cls));
    }

    public void testGenericMethods() {
        String str = "Integer.parseInt( a.getMap().get(\"x\") )";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("a", AGenericTestClass.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        AGenericTestClass a = new AGenericTestClass();
        a.setMap(new HashMap<String, String>());
        a.getMap().put("x", "10");
        HashMap<String, AGenericTestClass> variables = new HashMap<String, AGenericTestClass>();
        variables.put("a", a);
        Number result = (Number)MVEL.executeExpression((Object)stmt, null, variables);
        TypesAndInferenceTests.assertEquals((int)10, (int)result.intValue());
    }

    public void testGenerics1() {
        String str = "addresses[0] == new Address(\"s1\") && addresses[0].street == new Address(\"s1\").street";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("this", PersonAddresses.class);
        pctx.addImport(Address.class);
        pctx.addImport(PersonAddresses.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        PersonAddresses ctx = new PersonAddresses();
        ctx.getAddresses().add(new Address("s1"));
        Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)ctx);
        TypesAndInferenceTests.assertTrue((boolean)result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersonAddresses {
        private List<Address> addresses = new ArrayList<Address>();

        public List<Address> getAddresses() {
            return this.addresses;
        }

        public void setAddresses(List<Address> addresses) {
            this.addresses = addresses;
        }
    }

    public static class Address {
        private String street;

        public Address(String street) {
            this.street = street;
        }

        public String getStreet() {
            return this.street;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.street == null ? 0 : this.street.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Address other = (Address)obj;
            return !(this.street == null ? other.street != null : !this.street.equals(other.street));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AGenericTestClass {
        private Map<String, String> map;

        public Map<String, String> getMap() {
            return this.map;
        }

        public void setMap(Map<String, String> map) {
            this.map = map;
        }
    }

    public static class EchoContext {
        public String echo(String str) {
            return str;
        }
    }

    public static class MVELDateCoercion
    implements ConversionHandler {
        public boolean canConvertFrom(Class cls) {
            return cls == String.class || cls.isAssignableFrom(Date.class);
        }

        public Object convertFrom(Object o) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
                if (o instanceof String) {
                    return sdf.parse((String)o);
                }
                return o;
            }
            catch (Exception e) {
                throw new RuntimeException("Exception was thrown", e);
            }
        }
    }

    public static class MapWrapper {
        private Map map = new HashMap();

        public Map getMap() {
            return this.map;
        }

        public void setMap(Map map) {
            this.map = map;
        }
    }

    public static class Person228 {
        public String getName() {
            return "foo";
        }
    }

    public static class ScriptHelper228 {
        public void methodA() {
        }

        public void methodB(int param1) {
        }
    }

    public static class C
    extends A {
    }

    public static class B
    extends A {
        public void foo(String s) {
            super.foo(s);
        }

        public void bar(int s) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class A {
        public void foo(String s) {
        }

        public void bar(String s) {
        }

        public List<String> getStrings() {
            return STRINGS;
        }
    }
}

