/*
 * Decompiled with CFR 0.152.
 */
package org.obsidiantoaster.generator.rest;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;

@PreMatching
public class CorsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ORIGIN = "Origin";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    protected boolean allowCredentials = true;
    protected String allowedMethods;
    protected String allowedHeaders;
    protected String exposedHeaders;
    protected int corsMaxAge = -1;
    protected Set<String> allowedOrigins = new HashSet();

    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public String getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(String allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public String getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void setAllowedHeaders(String allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public int getCorsMaxAge() {
        return this.corsMaxAge;
    }

    public void setCorsMaxAge(int corsMaxAge) {
        this.corsMaxAge = corsMaxAge;
    }

    public String getExposedHeaders() {
        return this.exposedHeaders;
    }

    public void setExposedHeaders(String exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String origin = requestContext.getHeaderString(ORIGIN);
        if (origin == null) {
            return;
        }
        if (requestContext.getMethod().equalsIgnoreCase("OPTIONS")) {
            this.preflight(origin, requestContext);
        } else {
            this.checkOrigin(requestContext, origin);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String origin = requestContext.getHeaderString(ORIGIN);
        if (origin == null || requestContext.getMethod().equalsIgnoreCase("OPTIONS") || requestContext.getProperty("cors.failure") != null) {
            return;
        }
        responseContext.getHeaders().putSingle((Object)ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
        if (this.allowCredentials) {
            responseContext.getHeaders().putSingle((Object)ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        }
        if (this.exposedHeaders != null) {
            responseContext.getHeaders().putSingle((Object)ACCESS_CONTROL_EXPOSE_HEADERS, (Object)this.exposedHeaders);
        }
    }

    protected void preflight(String origin, ContainerRequestContext requestContext) throws IOException {
        String allowHeaders;
        String requestMethods;
        this.checkOrigin(requestContext, origin);
        Response.ResponseBuilder builder = Response.ok();
        builder.header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
        if (this.allowCredentials) {
            builder.header(ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        }
        if ((requestMethods = requestContext.getHeaderString(ACCESS_CONTROL_REQUEST_METHOD)) != null) {
            if (this.allowedMethods != null) {
                requestMethods = this.allowedMethods;
            }
            builder.header(ACCESS_CONTROL_ALLOW_METHODS, (Object)requestMethods);
        }
        if ((allowHeaders = requestContext.getHeaderString(ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
            if (this.allowedHeaders != null) {
                allowHeaders = this.allowedHeaders;
            }
            builder.header(ACCESS_CONTROL_ALLOW_HEADERS, (Object)allowHeaders);
        }
        if (this.corsMaxAge > -1) {
            builder.header(ACCESS_CONTROL_MAX_AGE, (Object)this.corsMaxAge);
        }
        requestContext.abortWith(builder.build());
    }

    protected void checkOrigin(ContainerRequestContext requestContext, String origin) {
        if (!this.allowedOrigins.contains("*") && !this.allowedOrigins.contains(origin)) {
            requestContext.setProperty("cors.failure", (Object)true);
            throw new ForbiddenException("Origin not allowed: " + origin);
        }
    }
}

