/*
 * Decompiled with CFR 0.152.
 */
package org.obsidiantoaster.generator.rest;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.ui.UIRuntime;
import org.jboss.forge.addon.ui.command.CommandFactory;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.CommandControllerFactory;
import org.jboss.forge.addon.ui.controller.WizardCommandController;
import org.jboss.forge.addon.ui.result.Failed;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.furnace.versions.Versions;
import org.jboss.forge.service.ui.RestUIContext;
import org.jboss.forge.service.ui.RestUIRuntime;
import org.jboss.forge.service.util.UICommandHelper;
import org.obsidiantoaster.generator.ForgeInitializer;
import org.obsidiantoaster.generator.util.JsonBuilder;

@Path(value="/forge")
public class ObsidianResource {
    private static final String ALLOWED_CMDS_VALIDATION_MESSAGE = "Supported commmands are 'obsidian-new-quickstart' or 'obsidian-new-project'";
    private static final String ALLOWED_CMDS_PATTERN = "(obsidian-new-quickstart)|(obsidian-new-project)";
    private static final String DEFAULT_COMMAND_NAME = "obsidian-new-quickstart";
    private Map<String, String> commandMap = new HashMap();
    @Inject
    private CommandFactory commandFactory;
    @Inject
    private CommandControllerFactory controllerFactory;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private UICommandHelper helper;

    public ObsidianResource() {
        this.commandMap.put(DEFAULT_COMMAND_NAME, "Obsidian: New Quickstart");
        this.commandMap.put("obsidian-new-project", "Obsidian: New Project");
    }

    @GET
    @Path(value="/version")
    @Produces(value={"application/json"})
    public JsonObject getInfo() {
        return Json.createObjectBuilder().add("backendVersion", String.valueOf(ForgeInitializer.getVersion())).add("forgeVersion", Versions.getImplementationVersionFor(UIContext.class).toString()).build();
    }

    @GET
    @Path(value="/commands/{commandName}")
    @Produces(value={"application/json"})
    public JsonObject getCommandInfo(@PathParam(value="commandName") @Pattern(regexp="(obsidian-new-quickstart)|(obsidian-new-project)", message="Supported commmands are 'obsidian-new-quickstart' or 'obsidian-new-project'") @DefaultValue(value="obsidian-new-quickstart") String commandName) throws Exception {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        try (CommandController controller = this.getCommand(commandName);){
            this.helper.describeController(builder, controller);
        }
        return builder.build();
    }

    @POST
    @Path(value="/commands/{commandName}/validate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonObject validateCommand(JsonObject content, @PathParam(value="commandName") @Pattern(regexp="(obsidian-new-quickstart)|(obsidian-new-project)", message="Supported commmands are 'obsidian-new-quickstart' or 'obsidian-new-project'") @DefaultValue(value="obsidian-new-quickstart") String commandName) throws Exception {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        try (CommandController controller = this.getCommand(commandName);){
            this.helper.populateControllerAllInputs(content, controller);
            this.helper.describeCurrentState(builder, controller);
            this.helper.describeValidation(builder, controller);
            this.helper.describeInputs(builder, controller);
        }
        return builder.build();
    }

    @POST
    @Path(value="/commands/{commandName}/next")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonObject nextStep(JsonObject content, @PathParam(value="commandName") @Pattern(regexp="(obsidian-new-quickstart)|(obsidian-new-project)", message="Supported commmands are 'obsidian-new-quickstart' or 'obsidian-new-project'") @DefaultValue(value="obsidian-new-quickstart") String commandName) throws Exception {
        int stepIndex = content.getInt("stepIndex", 1);
        JsonObjectBuilder builder = Json.createObjectBuilder();
        try (CommandController controller = this.getCommand(commandName);){
            if (!(controller instanceof WizardCommandController)) {
                throw new WebApplicationException("Controller is not a wizard", Response.Status.BAD_REQUEST);
            }
            WizardCommandController wizardController = (WizardCommandController)controller;
            for (int i = 0; i < stepIndex; ++i) {
                if (!wizardController.canMoveToNextStep()) continue;
                this.helper.populateController(content, (CommandController)wizardController);
                this.helper.describeValidation(builder, controller);
                wizardController.next().initialize();
            }
            this.helper.describeMetadata(builder, controller);
            this.helper.describeCurrentState(builder, controller);
            this.helper.describeInputs(builder, controller);
        }
        return builder.build();
    }

    @POST
    @Path(value="/commands/{commandName}/execute")
    @Consumes(value={"application/json"})
    public Response executeCommand(JsonObject content, @PathParam(value="commandName") @Pattern(regexp="(obsidian-new-quickstart)|(obsidian-new-project)", message="Supported commmands are 'obsidian-new-quickstart' or 'obsidian-new-project'") @DefaultValue(value="obsidian-new-quickstart") String commandName) throws Exception {
        try (CommandController controller = this.getCommand(commandName);){
            this.helper.populateControllerAllInputs(content, controller);
            if (controller.isValid()) {
                Result result = controller.execute();
                if (result instanceof Failed) {
                    Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)result.getMessage()).build();
                    return response;
                }
                UISelection selection = controller.getContext().getSelection();
                java.nio.file.Path path = Paths.get(selection.get().toString(), new String[0]);
                String artifactId = this.findArtifactId(content);
                byte[] zipContents = org.obsidiantoaster.generator.util.Paths.zip((String)artifactId, (java.nio.file.Path)path);
                org.obsidiantoaster.generator.util.Paths.deleteDirectory((java.nio.file.Path)path);
                Response response = Response.ok((Object)zipContents).type("application/zip").header("Content-Disposition", (Object)("attachment; filename=\"" + artifactId + ".zip\"")).build();
                return response;
            }
            JsonObjectBuilder builder = Json.createObjectBuilder();
            this.helper.describeValidation(builder, controller);
            Response response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)builder.build()).build();
            return response;
        }
    }

    private String findArtifactId(JsonObject content) {
        return content.getJsonArray("inputs").stream().filter(input -> "named".equals(((JsonObject)input).getString("name"))).map(input -> ((JsonString)((JsonObject)input).get((Object)"value")).getString()).findFirst().orElse("demo");
    }

    @POST
    @Path(value="/commands/{commandName}/execute")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response executeCommand(Form form, @PathParam(value="commandName") @Pattern(regexp="(obsidian-new-quickstart)|(obsidian-new-project)", message="Supported commmands are 'obsidian-new-quickstart' or 'obsidian-new-project'") @DefaultValue(value="obsidian-new-quickstart") String commandName) throws Exception {
        String stepIndex = (String)((List)form.asMap().remove((Object)"stepIndex")).get(0);
        JsonBuilder jsonBuilder = new JsonBuilder().createJson(Integer.valueOf(stepIndex).intValue());
        for (Map.Entry entry : form.asMap().entrySet()) {
            jsonBuilder.addInput((String)entry.getKey(), (List)entry.getValue());
        }
        Response response = this.executeCommand(jsonBuilder.build(), commandName);
        if (response.getEntity() instanceof JsonObject) {
            JsonObject responseEntity = (JsonObject)response.getEntity();
            String error = ((JsonObject)responseEntity.getJsonArray("messages").get(0)).getString("description");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)error).build();
        }
        return response;
    }

    private CommandController getCommand(String name) throws Exception {
        RestUIContext context = this.createUIContext();
        UICommand command = this.commandFactory.getNewCommandByName((UIContext)context, (String)this.commandMap.get(name));
        CommandController controller = this.controllerFactory.createController((UIContext)context, (UIRuntime)new RestUIRuntime(Collections.emptyList()), command);
        controller.initialize();
        return controller;
    }

    private RestUIContext createUIContext() {
        java.nio.file.Path rootPath = ForgeInitializer.getRoot();
        Resource selection = this.resourceFactory.create((Object)rootPath.toFile());
        return new RestUIContext(selection, Collections.emptyList());
    }
}

