/*
 * Decompiled with CFR 0.152.
 */
package org.obsidiantoaster.generator.util;

import java.util.Arrays;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public class JsonBuilder {
    private JsonBuilderFactory factory = Json.createBuilderFactory(null);
    private JsonArrayBuilder arrayBuilder;
    private int stepIndex;

    public JsonBuilder createJson() {
        this.arrayBuilder = this.factory.createArrayBuilder();
        return this;
    }

    public JsonBuilder createJson(int stepIndex) {
        this.createJson();
        this.stepIndex = stepIndex;
        return this;
    }

    public JsonBuilder setStepIndex(int stepIndex) {
        this.stepIndex = stepIndex;
        return this;
    }

    public JsonBuilder addInput(String name, List<String> value) {
        JsonObjectBuilder objectBuilder = this.factory.createObjectBuilder();
        objectBuilder.add("name", name);
        if (value.size() == 1) {
            objectBuilder.add("value", value.get(0));
        } else {
            JsonArrayBuilder valueArrayBuilder = this.factory.createArrayBuilder();
            value.forEach(arg_0 -> ((JsonArrayBuilder)valueArrayBuilder).add(arg_0));
            objectBuilder.add("value", valueArrayBuilder);
        }
        this.arrayBuilder.add(objectBuilder);
        return this;
    }

    public JsonBuilder addInput(String name, String ... value) {
        return this.addInput(name, Arrays.asList(value));
    }

    public JsonObject build() {
        JsonObjectBuilder jsonObjectBuilder = this.factory.createObjectBuilder();
        jsonObjectBuilder.add("inputs", this.arrayBuilder);
        jsonObjectBuilder.add("stepIndex", this.stepIndex);
        return jsonObjectBuilder.build();
    }
}

