/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolder;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScoreHolder;

public final class BendableLongScoreHolderImpl
extends AbstractScoreHolder<BendableLongScore>
implements BendableLongScoreHolder {
    protected final Map<Rule, AbstractScoreHolder.LongMatchExecutor> matchExecutorByNumberMap = new LinkedHashMap<Rule, AbstractScoreHolder.LongMatchExecutor>();
    protected final Map<Rule, AbstractScoreHolder.ScoreMatchExecutor<BendableLongScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, AbstractScoreHolder.ScoreMatchExecutor<BendableLongScore>>();
    private long[] hardScores;
    private long[] softScores;

    public BendableLongScoreHolderImpl(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new long[hardLevelsSize];
        this.softScores = new long[softLevelsSize];
    }

    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public long getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public long getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    @Override
    public void configureConstraintWeight(Rule rule, BendableLongScore constraintWeight) {
        AbstractScoreHolder.LongMatchExecutor matchExecutor;
        super.configureConstraintWeight(rule, constraintWeight);
        if (constraintWeight.equals((Object)BendableLongScore.zero((int)this.hardScores.length, (int)this.softScores.length))) {
            matchExecutor = (kcontext, matchWeight) -> {};
        } else {
            Integer singleLevel = null;
            Long singleLevelWeight = null;
            for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
                long levelWeight = constraintWeight.getHardOrSoftScore(i);
                if (levelWeight == 0L) continue;
                if (singleLevel != null) {
                    singleLevel = null;
                    singleLevelWeight = null;
                    break;
                }
                singleLevel = i;
                singleLevelWeight = levelWeight;
            }
            if (singleLevel != null) {
                long levelWeight = singleLevelWeight;
                if (singleLevel < constraintWeight.getHardLevelsSize()) {
                    int level = singleLevel;
                    matchExecutor = (kcontext, matchWeight) -> this.addHardConstraintMatch(kcontext, level, levelWeight * matchWeight);
                } else {
                    int level = singleLevel - constraintWeight.getHardLevelsSize();
                    matchExecutor = (kcontext, matchWeight) -> this.addSoftConstraintMatch(kcontext, level, levelWeight * matchWeight);
                }
            } else {
                matchExecutor = (kcontext, matchWeight) -> {
                    int i;
                    long[] hardWeights = new long[this.hardScores.length];
                    long[] softWeights = new long[this.softScores.length];
                    for (i = 0; i < hardWeights.length; ++i) {
                        hardWeights[i] = constraintWeight.getHardScore(i) * matchWeight;
                    }
                    for (i = 0; i < softWeights.length; ++i) {
                        softWeights[i] = constraintWeight.getSoftScore(i) * matchWeight;
                    }
                    this.addMultiConstraintMatch(kcontext, hardWeights, softWeights);
                };
            }
        }
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> {
            int i;
            long[] hardWeights = new long[this.hardScores.length];
            long[] softWeights = new long[this.softScores.length];
            for (i = 0; i < hardWeights.length; ++i) {
                hardWeights[i] = constraintWeight.getHardScore(i) * weightMultiplier.getHardScore(i);
            }
            for (i = 0; i < softWeights.length; ++i) {
                softWeights[i] = constraintWeight.getSoftScore(i) * weightMultiplier.getSoftScore(i);
            }
            this.addMultiConstraintMatch(kcontext, hardWeights, softWeights);
        });
    }

    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, -1L);
    }

    public void penalize(RuleContext kcontext, long weightMultiplier) {
        this.impactScore(kcontext, -weightMultiplier);
    }

    public void penalize(RuleContext kcontext, long[] hardWeightsMultiplier, long[] softWeightsMultiplier) {
        int i;
        long[] negatedHardWeightsMultiplier = new long[this.hardScores.length];
        long[] negatedSoftWeightsMultiplier = new long[this.softScores.length];
        for (i = 0; i < negatedHardWeightsMultiplier.length; ++i) {
            negatedHardWeightsMultiplier[i] = -hardWeightsMultiplier[i];
        }
        for (i = 0; i < negatedSoftWeightsMultiplier.length; ++i) {
            negatedSoftWeightsMultiplier[i] = -softWeightsMultiplier[i];
        }
        this.impactScore(kcontext, negatedHardWeightsMultiplier, negatedSoftWeightsMultiplier);
    }

    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, 1L);
    }

    public void reward(RuleContext kcontext, long weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    public void reward(RuleContext kcontext, long[] hardWeightsMultiplier, long[] softWeightsMultiplier) {
        this.impactScore(kcontext, hardWeightsMultiplier, softWeightsMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext) {
        this.impactScore(kcontext, 1L);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, (long)weightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.LongMatchExecutor matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support a BigDecimal weightMultiplier (" + weightMultiplier + ").\nIf you're using constraint streams, maybe switch from penalizeBigDecimal() to penalizeLong().");
    }

    private void impactScore(RuleContext kcontext, long[] hardWeightsMultiplier, long[] softWeightsMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.ScoreMatchExecutor<BendableLongScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, BendableLongScore.of((long[])hardWeightsMultiplier, (long[])softWeightsMultiplier));
    }

    public void addHardConstraintMatch(RuleContext kcontext, int hardLevel, long weight) {
        if (hardLevel >= this.hardScores.length) {
            throw new IllegalArgumentException("The hardLevel (" + hardLevel + ") isn't lower than the hardScores length (" + this.hardScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        int n = hardLevel;
        this.hardScores[n] = this.hardScores[n] + weight;
        this.registerConstraintMatch(kcontext, () -> {
            int n = hardLevel;
            this.hardScores[n] = this.hardScores[n] - weight;
        }, () -> {
            long[] newHardScores = new long[this.hardScores.length];
            long[] newSoftScores = new long[this.softScores.length];
            newHardScores[hardLevel] = weight;
            return BendableLongScore.of((long[])newHardScores, (long[])newSoftScores);
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, int softLevel, long weight) {
        if (softLevel >= this.softScores.length) {
            throw new IllegalArgumentException("The softLevel (" + softLevel + ") isn't lower than the softScores length (" + this.softScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        int n = softLevel;
        this.softScores[n] = this.softScores[n] + weight;
        this.registerConstraintMatch(kcontext, () -> {
            int n = softLevel;
            this.softScores[n] = this.softScores[n] - weight;
        }, () -> {
            long[] newHardScores = new long[this.hardScores.length];
            long[] newSoftScores = new long[this.softScores.length];
            newSoftScores[softLevel] = weight;
            return BendableLongScore.of((long[])newHardScores, (long[])newSoftScores);
        });
    }

    public void addMultiConstraintMatch(RuleContext kcontext, long[] hardWeights, long[] softWeights) {
        int i;
        if (hardWeights.length != this.hardScores.length) {
            throw new IllegalArgumentException("The hardWeights length (" + hardWeights.length + ") is different than the hardScores length (" + this.hardScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            int n = i;
            this.hardScores[n] = this.hardScores[n] + hardWeights[i];
        }
        if (softWeights.length != this.softScores.length) {
            throw new IllegalArgumentException("The softWeights length (" + softWeights.length + ") is different than the softScores length (" + this.softScores.length + ") defined by the @" + PlanningScore.class.getSimpleName() + " on the planning solution class.");
        }
        for (i = 0; i < this.softScores.length; ++i) {
            int n = i;
            this.softScores[n] = this.softScores[n] + softWeights[i];
        }
        this.registerConstraintMatch(kcontext, () -> {
            int i;
            for (i = 0; i < this.hardScores.length; ++i) {
                int n = i;
                this.hardScores[n] = this.hardScores[n] - hardWeights[i];
            }
            for (i = 0; i < this.softScores.length; ++i) {
                int n = i;
                this.softScores[n] = this.softScores[n] - softWeights[i];
            }
        }, () -> BendableLongScore.of((long[])hardWeights, (long[])softWeights));
    }

    @Override
    public BendableLongScore extractScore(int initScore) {
        return BendableLongScore.ofUninitialized((int)initScore, (long[])Arrays.copyOf(this.hardScores, this.hardScores.length), (long[])Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

